/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle.criterion;

import java.util.HashMap;
import java.util.Map;

public class SDOParameterMap {
    public static final String DISTANCE = "distance";
    public static final String SDO_BATCH_SIZE = "sdo_batch_size";
    public static final String SDO_NUM_RES = "sdo_num_res";
    public static final String UNIT = "unit";
    public static final String MIN_RESOLUTION = "min_resolution";
    public static final String MAX_RESOLUTION = "max_resolution";
    public static final String MASK = "mask";
    public static final String QUERYTYPE = "querytype";
    private Map<String, Object> params = new HashMap<String, Object>();

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Double getDistance() {
        return (Double)this.params.get(DISTANCE);
    }

    public void setDistance(Double distance) {
        if (distance != null) {
            this.params.put(DISTANCE, distance);
        }
    }

    public void removeDistance() {
        this.params.remove(DISTANCE);
    }

    public Integer getSdoBatchSize() {
        return (Integer)this.params.get(SDO_BATCH_SIZE);
    }

    public void setSdoBatchSize(Integer size) {
        if (size != null) {
            this.params.put(SDO_BATCH_SIZE, size);
        }
    }

    public void removeSdoBatchSize() {
        this.params.remove(SDO_BATCH_SIZE);
    }

    public Integer getSdoNumRes() {
        return (Integer)this.params.get(SDO_NUM_RES);
    }

    public void setSdoNumRes(Integer res) {
        if (res != null) {
            this.params.put(SDO_NUM_RES, res);
        }
    }

    public void removeSdoNumRes() {
        this.params.remove(SDO_NUM_RES);
    }

    public String getUnit() {
        return (String)this.params.get(UNIT);
    }

    public void setUnit(String unit) {
        if (unit != null) {
            this.params.put(UNIT, unit);
        }
    }

    public void removeUnit() {
        this.params.remove(UNIT);
    }

    public Double getMaxResolution() {
        return (Double)this.params.get(MAX_RESOLUTION);
    }

    public void setMaxResolution(Double res) {
        if (res != null) {
            this.params.put(MAX_RESOLUTION, res);
        }
    }

    public void removeMaxResolution() {
        this.params.remove(MAX_RESOLUTION);
    }

    public Double getMinResolution() {
        return (Double)this.params.get(MIN_RESOLUTION);
    }

    public void setMinResolution(Double res) {
        if (res != null) {
            this.params.put(MIN_RESOLUTION, res);
        }
    }

    public void removeMinResolution() {
        this.params.remove(MIN_RESOLUTION);
    }

    public String getMask() {
        return (String)this.params.get(MASK);
    }

    public void setMask(String mask) {
        if (mask != null) {
            this.params.put(MASK, mask);
        }
    }

    public void removeMask() {
        this.params.remove(MASK);
    }

    public void setQueryTypeToFilter() {
        this.params.put(QUERYTYPE, "FILTER");
    }

    public String getQueryType() {
        return (String)this.params.get(QUERYTYPE);
    }

    public void setQueryType(String queryType) {
        if (queryType != null) {
            this.params.put(QUERYTYPE, queryType);
        }
    }

    public void removeQueryType() {
        this.params.remove(QUERYTYPE);
    }

    public String toQuotedString() {
        StringBuilder stb = new StringBuilder();
        if (this.params.isEmpty()) {
            return "";
        }
        stb.append('\'');
        for (Map.Entry<String, Object> kv : this.params.entrySet()) {
            if (kv.getValue() == null) continue;
            stb.append(kv.getKey()).append("=").append(kv.getValue()).append(" ");
        }
        stb.deleteCharAt(stb.length() - 1);
        stb.append('\'');
        return stb.toString();
    }
}

