/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.asynchttpclient;

import org.http4s.client.asynchttpclient.UnicastSubscriber$;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!B\u0001\u0003\u0003\u0003Y!!E+oS\u000e\f7\u000f^*vEN\u001c'/\u001b2fe*\u00111\u0001B\u0001\u0010CNLhn\u00195uiB\u001cG.[3oi*\u0011QAB\u0001\u0007G2LWM\u001c;\u000b\u0005\u001dA\u0011A\u00025uiB$4OC\u0001\n\u0003\ry'oZ\u0002\u0001+\taQdE\u0002\u0001\u001bU\u0001\"AD\n\u000e\u0003=Q!\u0001E\t\u0002\t1\fgn\u001a\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rB\u0001\u0004PE*,7\r\u001e\t\u0004-eYR\"A\f\u000b\u0005aA\u0011a\u0004:fC\u000e$\u0018N^3tiJ,\u0017-\\:\n\u0005i9\"AC*vEN\u001c'/\u001b2feB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005\t\u0015C\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!I\u0014\n\u0005!\u0012#aA!os\"A!\u0006\u0001B\u0001B\u0003%1&\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"!\t\u0017\n\u00055\u0012#aA%oi\")q\u0006\u0001C\u0001a\u00051A(\u001b8jiz\"\"!M\u001a\u0011\u0007I\u00021$D\u0001\u0003\u0011\u001dQc\u0006%AA\u0002-Ba!\u000e\u0001!\u0002\u00131\u0014A\u00027pO\u001e,'\u000f\u0005\u00028u5\t\u0001H\u0003\u0002:\u0011\u0005)An\\45g&\u00111\b\u000f\u0002\u0007\u0019><w-\u001a:\t\u0013u\u0002\u0001\u0019!A!B\u0013q\u0014\u0001D:vEN\u001c'/\u001b9uS>t\u0007C\u0001\f@\u0013\t\u0001uC\u0001\u0007Tk\n\u001c8M]5qi&|g\u000e\u0003\u0004C\u0001\u0001\u0006KaQ\u0001\u0005I>tW\r\u0005\u0002\"\t&\u0011QI\t\u0002\b\u0005>|G.Z1o\u0011\u00159\u0005\u0001\"\u0011I\u0003-ygnU;cg\u000e\u0014\u0018NY3\u0015\u0005%c\u0005CA\u0011K\u0013\tY%E\u0001\u0003V]&$\b\"B'G\u0001\u0004q\u0014!A:\t\u000b=\u0003A\u0011\t)\u0002\r=tg*\u001a=u)\tI\u0015\u000bC\u0003S\u001d\u0002\u00071$A\u0004fY\u0016lWM\u001c;\t\u000bQ\u0003A\u0011B+\u0002\r\u0019Lg.[:i)\u0005I\u0005\"B,\u0001\r#A\u0016\u0001C<iK:tU\r\u001f;\u0015\u0005\rK\u0006\"\u0002*W\u0001\u0004Y\u0002\"B.\u0001\t#a\u0016a\u0002:fcV,7\u000f\u001e\u000b\u0003\u0013vCQA\u0018.A\u0002-\n\u0011A\u001c\u0005\u0006A\u0002!\t%Y\u0001\b_:,%O]8s)\tI%\rC\u0003d?\u0002\u0007A-A\u0001u!\t)WN\u0004\u0002gW:\u0011qM[\u0007\u0002Q*\u0011\u0011NC\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!\u0001\u001c\u0012\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\u001c\u0012\t\u000bE\u0004A\u0011I+\u0002\u0015=t7i\\7qY\u0016$XmB\u0004t\u0005\u0005\u0005\t\u0012\u0001;\u0002#Us\u0017nY1tiN+(m]2sS\n,'\u000f\u0005\u00023k\u001a9\u0011AAA\u0001\u0012\u000318CA;x!\t\t\u00030\u0003\u0002zE\t1\u0011I\\=SK\u001aDQaL;\u0005\u0002m$\u0012\u0001\u001e\u0005\b{V\f\n\u0011\"\u0001\u007f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0019q0!\u0006\u0016\u0005\u0005\u0005!fA\u0016\u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010\t\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003\u001fy\n\u0007q\u0004")
public abstract class UnicastSubscriber<A>
implements Subscriber<A> {
    private final Logger logger = LoggerFactory.getLogger(UnicastSubscriber.class);
    private Subscription subscription;
    private boolean done = false;

    public static <A> int $lessinit$greater$default$1() {
        return UnicastSubscriber$.MODULE$.$lessinit$greater$default$1();
    }

    public void onSubscribe(Subscription s) {
        if (s == null) {
            throw null;
        }
        if (this.subscription != null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This is a unicast subscriber. Canceling second subscription ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})));
            }
            try {
                s.cancel();
            }
            catch (Throwable t) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " violated the Reactive Streams rule 3.15 by throwing an exception from cancel."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s})), t);
                }
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subscriber ", " starting subscription to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, s})));
            }
            this.subscription = s;
            this.request(1);
        }
    }

    public void onNext(A element) {
        block7: {
            block9: {
                block8: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received element ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element})));
                    }
                    if (this.subscription != null) break block8;
                    if (!this.logger.isErrorEnabled()) break block7;
                    this.logger.error("Publisher violated the Reactive Streams rule 1.09 signalling onNext prior to onSubscribe.", (Throwable)new IllegalStateException());
                    break block7;
                }
                if (element == null) {
                    throw null;
                }
                if (this.done) break block9;
                try {
                    if (!this.whenNext(element)) {
                        this.finish();
                    }
                    break block7;
                }
                catch (Throwable t) {
                    this.finish();
                    try {
                        this.onError(t);
                        break block7;
                    }
                    catch (Throwable t2) {
                        if (!this.logger.isErrorEnabled()) break block7;
                        this.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " violated the Reactive Streams rule 2.13 by throwing an exception from onError."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this})), t2);
                    }
                }
                break block7;
            }
            if (!this.logger.isInfoEnabled()) break block7;
            this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"We were already done before we received ", ". Not handed to whenNext."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{element})));
        }
    }

    private void finish() {
        block3: {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Subscriber ", " closing subscription to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, this.subscription})));
            }
            this.done = true;
            try {
                this.subscription.cancel();
            }
            catch (Throwable t) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " violated the Reactive Streams rule 3.15 by throwing an exception from cancel."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscription})), t);
            }
        }
    }

    public abstract boolean whenNext(A var1);

    public void request(int n) {
        block3: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Triggering request of ", " elements to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), this.subscription})));
                }
                this.subscription.request((long)n);
            }
            catch (Throwable t) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " violated the Reactive Streams rule 3.16 by throwing an exception from request."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscription})), t);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.subscription == null) {
            this.logger.error("Publisher violated the Reactive Streams rule 1.09 signalling onError prior to onSubscribe.");
        } else if (t == null) {
            throw null;
        }
    }

    public void onComplete() {
        block0: {
            if (this.subscription != null) break block0;
            this.logger.error("Publisher violated the Reactive Streams rule 1.09 signalling onComplete prior to onSubscribe.");
        }
    }

    public UnicastSubscriber(int bufferSize) {
    }
}

