/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.infinispan.cli.shell.Color;
import org.infinispan.cli.shell.Shell;

public class Prompt {
    /*
     * Enabled aggressive block sorting
     */
    public static String promptExpressionParser(Shell shell, String input) {
        int i;
        StringBuilder builder = new StringBuilder();
        char[] expr = input.toCharArray();
        Color c = null;
        int start = 0;
        block22: for (i = 0; i < expr.length; ++i) {
            switch (expr[i]) {
                case '\\': {
                    if (i + 1 >= expr.length) continue block22;
                    block3 : switch (expr[++i]) {
                        case '\\': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append("\\");
                            start = i + 1;
                            break;
                        }
                        case 'w': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append(shell.getCWD());
                            start = i + 1;
                            break;
                        }
                        case 'W': {
                            builder.append(new String(expr, start, i - start - 1));
                            String v = shell.getCWD();
                            builder.append(v.substring(v.lastIndexOf(47) + 1));
                            start = i + 1;
                            break;
                        }
                        case 'd': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append(new SimpleDateFormat("EEE MMM dd").format(new Date()));
                            start = i + 1;
                            break;
                        }
                        case 't': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append(new SimpleDateFormat("HH:mm:ss").format(new Date()));
                            start = i + 1;
                            break;
                        }
                        case 'T': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append(new SimpleDateFormat("hh:mm:ss").format(new Date()));
                            start = i + 1;
                            break;
                        }
                        case '@': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append(new SimpleDateFormat("KK:mmaa").format(new Date()));
                            start = i + 1;
                            break;
                        }
                        case '$': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append("\\$");
                            start = i + 1;
                            break;
                        }
                        case 'r': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append("\r");
                            start = i + 1;
                            break;
                        }
                        case 'n': {
                            builder.append(new String(expr, start, i - start - 1));
                            builder.append("\n");
                            start = i + 1;
                            break;
                        }
                        case 'c': {
                            if (i + 1 >= expr.length) break;
                            switch (expr[++i]) {
                                case '{': {
                                    boolean nextNodeColor = false;
                                    builder.append(new String(expr, start, i - start - 2));
                                    start = i;
                                    while (i < input.length() && input.charAt(i) != '}') {
                                        ++i;
                                    }
                                    if (i == input.length() && input.charAt(i) != '}') {
                                        builder.append(new String(expr, start, i - start));
                                        break block3;
                                    }
                                    String color = new String(expr, start + 1, i - start - 1);
                                    start = ++i;
                                    block24: while (i < expr.length) {
                                        switch (expr[i]) {
                                            case '\\': {
                                                if (i + 1 < expr.length && expr[i + 1] == 'c') {
                                                    if (i + 2 >= expr.length || expr[i + 2] != '{') break block24;
                                                    nextNodeColor = true;
                                                    break block24;
                                                }
                                            }
                                            default: {
                                                ++i;
                                                continue block24;
                                            }
                                        }
                                    }
                                    if (c != null && c != Color.NONE) {
                                        builder.append(shell.renderColor(Color.NONE, ""));
                                    }
                                    c = Color.NONE;
                                    for (Color sc : Color.values()) {
                                        if (!sc.name().equalsIgnoreCase(color == null ? "" : color.trim())) continue;
                                        c = sc;
                                        break;
                                    }
                                    String toColorize = Prompt.promptExpressionParser(shell, new String(expr, start, i - start));
                                    String cStr = shell.renderColor(c, toColorize);
                                    builder.append(cStr);
                                    if (nextNodeColor) {
                                        start = i--;
                                        break block3;
                                    }
                                    start = i += 2;
                                    break block3;
                                }
                            }
                            start = i += 2;
                        }
                    }
                    continue block22;
                }
            }
        }
        if (start < expr.length && i > start) {
            builder.append(new String(expr, start, i - start));
        }
        return builder.toString();
    }

    public static String echo(Shell shell, String input) {
        char[] expr = input.toCharArray();
        StringBuilder out = new StringBuilder();
        int start = 0;
        int i = 0;
        block4: while (i < expr.length && i < expr.length) {
            switch (expr[i]) {
                case '\\': {
                    if (i + 1 >= expr.length || expr[i + 1] != '$') break;
                    out.append(new String(expr, start, i - start));
                    out.append('$');
                    start = i += 2;
                    break;
                }
                case '$': {
                    out.append(new String(expr, start, i - start));
                    start = ++i;
                    while (i != expr.length && Character.isJavaIdentifierPart(expr[i]) && expr[i] != '\u001b') {
                        ++i;
                    }
                    String var = new String(expr, start, i - start);
                    String val = shell.getContext().getProperty(var);
                    if (val != null) {
                        out.append(String.valueOf(val));
                    }
                    start = i;
                    break;
                }
                default: {
                    if (!Character.isWhitespace(expr[i])) break;
                    out.append(new String(expr, start, i - start));
                    start = i;
                    while (i != expr.length && Character.isWhitespace(expr[i])) {
                        ++i;
                    }
                    out.append(new String(expr, start, i - start));
                    start = i;
                    continue block4;
                }
            }
            ++i;
        }
        if (start < expr.length && i > start) {
            out.append(new String(expr, start, i - start));
        }
        return out.toString();
    }
}

