/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadFactoryConfiguration;

public class ThreadFactoryConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<ThreadFactoryConfiguration> {
    private final AttributeSet attributes = ThreadFactoryConfiguration.attributeDefinitionSet();
    private String nodeName;

    ThreadFactoryConfigurationBuilder(GlobalConfigurationBuilder globalConfig, String name) {
        super(globalConfig);
        this.attributes.attribute(ThreadFactoryConfiguration.NAME).set((Object)name);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ThreadFactoryConfigurationBuilder groupName(ThreadGroup threadGroup) {
        this.attributes.attribute(ThreadFactoryConfiguration.GROUP).set((Object)threadGroup);
        return this;
    }

    public ThreadFactoryConfigurationBuilder threadNamePattern(String threadNamePattern) {
        this.attributes.attribute(ThreadFactoryConfiguration.THREAD_NAME_PATTERN).set((Object)threadNamePattern);
        return this;
    }

    public ThreadFactoryConfigurationBuilder priority(Integer priority) {
        this.attributes.attribute(ThreadFactoryConfiguration.PRIORITY).set((Object)priority);
        return this;
    }

    public ThreadFactoryConfigurationBuilder nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public String name() {
        return (String)this.attributes.attribute(ThreadFactoryConfiguration.NAME).get();
    }

    public Integer priority() {
        return (Integer)this.attributes.attribute(ThreadFactoryConfiguration.PRIORITY).get();
    }

    public ThreadGroup group() {
        return (ThreadGroup)this.attributes.attribute(ThreadFactoryConfiguration.GROUP).get();
    }

    public String threadNamePattern() {
        return (String)this.attributes.attribute(ThreadFactoryConfiguration.THREAD_NAME_PATTERN).get();
    }

    public String nodeName() {
        return this.nodeName;
    }

    public void validate() {
    }

    public ThreadFactoryConfiguration create() {
        return new ThreadFactoryConfiguration(this.attributes.protect(), this.nodeName);
    }

    public ThreadFactoryConfigurationBuilder read(ThreadFactoryConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "ThreadFactoryConfigurationBuilder{attributes=" + this.attributes + '}';
    }
}

