/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ContentTypeConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.EncodingConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.configuration.cache.SecurityConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfigurationBuilder;
import org.infinispan.configuration.global.SerializationConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolBuilderAdapter;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadsConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.global.WhiteListConfigurationBuilder;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParserScope;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLResourceResolver;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.persistence.cluster.ClusterLoader;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.BuiltinJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.jgroups.conf.ProtocolConfiguration;

@Namespaces(value={@Namespace(root="infinispan"), @Namespace(uri="urn:infinispan:config:*", root="infinispan")})
public class Parser
implements ConfigurationParser {
    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.TCP(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.UDP(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.KUBERNETES(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.EC2(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.GOOGLE(reader.getProperties()));
        holder.addJGroupsStack(BuiltinJGroupsChannelConfigurator.AZURE(reader.getProperties()));
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, holder);
                    continue block5;
                }
                case JGROUPS: {
                    this.parseJGroups(reader, holder);
                    continue block5;
                }
                case THREADS: {
                    this.parseThreads(reader, holder);
                    continue block5;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseSerialization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block9;
                }
                case VERSION: {
                    Log.CONFIG.serializationVersionDeprecated();
                    builder.serialization().version(value);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    Log.CONFIG.advancedExternalizerDeprecated();
                    this.parseAdvancedExternalizer(reader, holder.getClassLoader(), builder.serialization());
                    continue block10;
                }
                case SERIALIZATION_CONTEXT_INITIALIZER: {
                    this.parseSerializationContextInitializer(reader, holder.getClassLoader(), builder.serialization());
                    continue block10;
                }
                case WHITE_LIST: {
                    if (reader.getSchema().since(10, 0)) {
                        this.parseWhiteList(reader, builder.serialization().whiteList());
                        continue block10;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseSerializationContextInitializer(XMLExtendedStreamReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.addContextInitializer((SerializationContextInitializer)Util.getInstance((String)value, (ClassLoader)classLoader));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseWhiteList(XMLExtendedStreamReader reader, WhiteListConfigurationBuilder builder) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS: {
                    builder.addClass(reader.getElementText());
                    continue block4;
                }
                case REGEX: {
                    builder.addRegexp(reader.getElementText());
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizer(XMLExtendedStreamReader reader, ClassLoader classLoader, SerializationConfigurationBuilder builder) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        AdvancedExternalizer advancedExternalizer = null;
        Integer id = null;
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        block4: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    advancedExternalizer = (AdvancedExternalizer)Util.getInstance((String)value, (ClassLoader)classLoader);
                    continue block4;
                }
                case ID: {
                    id = Integer.valueOf(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        if (id != null) {
            builder.addAdvancedExternalizer(id, advancedExternalizer);
        } else {
            builder.addAdvancedExternalizer(advancedExternalizer);
        }
    }

    private void parseThreads(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, holder);
                    continue block6;
                }
                case CACHED_THREAD_POOL: {
                    this.parseCachedThreadPool(reader, holder);
                    continue block6;
                }
                case SCHEDULED_THREAD_POOL: {
                    this.parseScheduledThreadPool(reader, holder);
                    continue block6;
                }
                case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBlockingBoundedQueueThreadPool(reader, holder);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseBlockingBoundedQueueThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        int maxThreads = 0;
        int coreThreads = 0;
        int queueLength = 0;
        long keepAlive = 0L;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block8;
                }
                case CORE_THREADS: {
                    coreThreads = Integer.valueOf(value);
                    continue block8;
                }
                case MAX_THREADS: {
                    maxThreads = Integer.valueOf(value);
                    continue block8;
                }
                case QUEUE_LENGTH: {
                    queueLength = Integer.valueOf(value);
                    continue block8;
                }
                case KEEP_ALIVE_TIME: {
                    keepAlive = Long.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addBoundedThreadPool(name).threadFactory(threadFactoryName).coreThreads(coreThreads).maxThreads(maxThreads).queueLength(queueLength).keepAliveTime(keepAlive);
        ParseUtils.requireNoContent(reader);
    }

    private void parseScheduledThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addScheduledThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseCachedThreadPool(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ThreadsConfigurationBuilder threadsBuilder = holder.getGlobalConfigurationBuilder().threads();
        String name = null;
        String threadFactoryName = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block4;
                }
                case THREAD_FACTORY: {
                    threadFactoryName = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        threadsBuilder.addCachedThreadPool(name).threadFactory(threadFactoryName);
        ParseUtils.requireNoContent(reader);
    }

    private void parseThreadFactory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String name = null;
        ThreadGroup threadGroup = null;
        String threadNamePattern = null;
        int priority = 1;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                case GROUP_NAME: {
                    threadGroup = new ThreadGroup(value);
                    continue block6;
                }
                case THREAD_NAME_PATTERN: {
                    threadNamePattern = value;
                    continue block6;
                }
                case PRIORITY: {
                    priority = Integer.valueOf(value);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        holder.getGlobalConfigurationBuilder().threads().addThreadFactory(name).groupName(threadGroup).priority(priority).threadNamePattern(threadNamePattern);
        ParseUtils.requireNoContent(reader);
    }

    private void parseJGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Transport transport = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TRANSPORT: {
                    transport = (Transport)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (transport == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        } else {
            holder.getGlobalConfigurationBuilder().transport().transport(transport);
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK_FILE: {
                    this.parseStackFile(reader, holder);
                    continue block8;
                }
                case STACK: {
                    if (!reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    this.parseJGroupsStack(reader, holder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void addJGroupsStackFile(ConfigurationBuilderHolder holder, String name, String path, Properties properties, XMLResourceResolver resourceResolver) {
        URL url = FileLookupFactory.newInstance().lookupFileLocation(path, holder.getClassLoader());
        try (InputStream xml = (url != null ? url : resourceResolver.resolveResource(path)).openStream();){
            holder.addJGroupsStack(new FileJGroupsChannelConfigurator(name, path, xml, properties));
        }
        catch (FileNotFoundException e) {
            throw Log.CONFIG.jgroupsConfigurationNotFound(path);
        }
        catch (IOException e) {
            throw Log.CONFIG.unableToAddJGroupsStack(name, e);
        }
    }

    private void parseJGroupsStack(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String stackName = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
        EmbeddedJGroupsChannelConfigurator stackConfigurator = new EmbeddedJGroupsChannelConfigurator(stackName);
        String extend = null;
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block7;
                }
                case EXTENDS: {
                    extend = value;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        List<ProtocolConfiguration> stack = stackConfigurator.getProtocolStack();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITES: {
                    this.parseJGroupsRelay(reader, holder, stackConfigurator);
                    continue block8;
                }
            }
            String protocolName = reader.getLocalName();
            HashMap<String, String> protocolAttributes = new HashMap<String, String>();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                protocolAttributes.put(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
            }
            ParseUtils.requireNoContent(reader);
            stack.add(new ProtocolConfiguration(protocolName, protocolAttributes));
        }
        holder.addJGroupsStack(stackConfigurator, extend);
    }

    private void parseJGroupsRelay(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, EmbeddedJGroupsChannelConfigurator stackConfigurator) throws XMLStreamException {
        String defaultStack = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.DEFAULT_STACK);
        if (holder.getJGroupsStack(defaultStack) == null) {
            throw Log.CONFIG.missingJGroupsStack(defaultStack);
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    String remoteSite = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME)[0];
                    String stack = defaultStack;
                    block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                continue block8;
                            }
                            case STACK: {
                                stack = reader.getAttributeValue(i);
                                if (holder.getJGroupsStack(stack) != null) continue block8;
                                throw Log.CONFIG.missingJGroupsStack(stack);
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    stackConfigurator.addRemoteSite(remoteSite, holder.getJGroupsStack(stack));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseStackFile(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME, Attribute.PATH);
        ParseUtils.requireNoContent(reader);
        this.addJGroupsStackFile(holder, attributes[0], attributes[1], reader.getProperties(), reader.getResourceResolver());
    }

    private void parseContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        holder.pushScope(ParserScope.CACHE_CONTAINER);
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block34: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!ParseUtils.isNoNamespaceAttribute(reader, i)) continue;
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    builder.cacheManagerName(value);
                    continue block34;
                }
                case DEFAULT_CACHE: {
                    builder.defaultCacheName(value);
                    continue block34;
                }
                case ALIASES: 
                case JNDI_NAME: 
                case MODULE: 
                case START: {
                    Parser.ignoreAttribute(reader, attribute);
                    continue block34;
                }
                case ASYNC_EXECUTOR: {
                    builder.asyncThreadPoolName(value);
                    builder.asyncThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.async", holder));
                    continue block34;
                }
                case LISTENER_EXECUTOR: {
                    builder.listenerThreadPoolName(value);
                    builder.listenerThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.notification", holder));
                    continue block34;
                }
                case EVICTION_EXECUTOR: {
                    Log.CONFIG.evictionExecutorDeprecated();
                }
                case EXPIRATION_EXECUTOR: {
                    builder.expirationThreadPoolName(value);
                    builder.expirationThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.expiration", holder));
                    continue block34;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block34;
                }
                case PERSISTENCE_EXECUTOR: {
                    builder.persistenceThreadPoolName(value);
                    builder.persistenceThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.persistence", holder));
                    continue block34;
                }
                case STATE_TRANSFER_EXECUTOR: {
                    Parser.ignoreAttribute(reader, Attribute.STATE_TRANSFER_EXECUTOR);
                    continue block34;
                }
                case STATISTICS: {
                    boolean statistics = Boolean.parseBoolean(value);
                    builder.cacheContainer().statistics(statistics);
                    if (reader.getSchema().since(10, 1)) continue block34;
                    builder.jmx().enabled(statistics);
                    continue block34;
                }
                case SHUTDOWN_HOOK: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block34;
                }
                case ZERO_CAPACITY_NODE: {
                    builder.zeroCapacityNode(Boolean.parseBoolean(value));
                    continue block34;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block35: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    continue block35;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, holder, false);
                    continue block35;
                }
                case LOCAL_CACHE_CONFIGURATION: {
                    this.parseLocalCache(reader, holder, true);
                    continue block35;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, holder, false);
                    continue block35;
                }
                case INVALIDATION_CACHE_CONFIGURATION: {
                    this.parseInvalidationCache(reader, holder, true);
                    continue block35;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, holder, false);
                    continue block35;
                }
                case REPLICATED_CACHE_CONFIGURATION: {
                    this.parseReplicatedCache(reader, holder, true);
                    continue block35;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, holder, false);
                    continue block35;
                }
                case DISTRIBUTED_CACHE_CONFIGURATION: {
                    this.parseDistributedCache(reader, holder, true);
                    continue block35;
                }
                case SCATTERED_CACHE: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, false);
                        continue block35;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SCATTERED_CACHE_CONFIGURATION: {
                    if (reader.getSchema().since(9, 1)) {
                        this.parseScatteredCache(reader, holder, true);
                        continue block35;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block35;
                }
                case MODULES: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    this.parseModules(reader, holder);
                    continue block35;
                }
                case METRICS: {
                    this.parseMetrics(reader, holder);
                    continue block35;
                }
                case JMX: {
                    this.parseJmx(reader, holder);
                    continue block35;
                }
                case SECURITY: {
                    this.parseGlobalSecurity(reader, holder);
                    continue block35;
                }
                case GLOBAL_STATE: {
                    if (reader.getSchema().since(8, 1)) {
                        this.parseGlobalState(reader, holder);
                        continue block35;
                    }
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
            reader.handleAny(holder);
        }
        holder.popScope();
    }

    private static void ignoreAttribute(XMLExtendedStreamReader reader, Attribute attribute) {
        Log.CONFIG.ignoreXmlAttribute((Object)attribute, reader.getLocation().getLineNumber(), reader.getLocation().getColumnNumber());
    }

    private static void ignoreElement(XMLExtendedStreamReader reader, Element element) {
        Log.CONFIG.ignoreXmlElement((Object)element, reader.getLocation().getLineNumber(), reader.getLocation().getColumnNumber());
    }

    private void parseGlobalSecurity(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalAuthorization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalAuthorizationConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().security().authorization().enable();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    builder.auditLogger((AuditLogger)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        PrincipalRoleMapper roleMapper = null;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new IdentityRoleMapper();
                    continue block11;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new CommonNameRoleMapper();
                    continue block11;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    roleMapper = new ClusterRoleMapper();
                    continue block11;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    roleMapper = this.parseCustomMapper(reader, holder);
                    continue block11;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, builder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (roleMapper != null) {
            builder.principalRoleMapper(roleMapper);
        }
    }

    private PrincipalRoleMapper parseCustomMapper(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String mapperClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return (PrincipalRoleMapper)Util.getInstance((String)mapperClass, (ClassLoader)holder.getClassLoader());
    }

    private void parseGlobalRole(XMLExtendedStreamReader reader, GlobalAuthorizationConfigurationBuilder builder) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName(), Attribute.PERMISSIONS.getLocalName());
        GlobalRoleConfigurationBuilder role = builder.role(attributes[0]);
        for (String permission : attributes[1].split("\\s+")) {
            role.permission(permission);
        }
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: 
                case PERMISSIONS: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseMetrics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case GAUGES: {
                    builder.metrics().gauges(Boolean.parseBoolean(value));
                    continue block6;
                }
                case HISTOGRAMS: {
                    builder.metrics().histograms(Boolean.parseBoolean(value));
                    continue block6;
                }
                case PREFIX: {
                    builder.metrics().prefix(value);
                    continue block6;
                }
                case NAMES_AS_TAGS: {
                    builder.metrics().namesAsTags(Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmx(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    builder.jmx().enabled(Boolean.parseBoolean(value));
                    continue block6;
                }
                case DOMAIN: {
                    builder.jmx().domain(value);
                    continue block6;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.jmx().mBeanServerLookup((MBeanServerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block6;
                }
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.jmx().allowDuplicateDomains(Boolean.parseBoolean(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = Parser.parseProperties(reader);
        builder.jmx().withProperties(properties);
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder globalBuilder = holder.getGlobalConfigurationBuilder();
        if (holder.getGlobalConfigurationBuilder().transport().getTransport() == null) {
            holder.getGlobalConfigurationBuilder().transport().defaultTransport();
        }
        TransportConfigurationBuilder transport = holder.getGlobalConfigurationBuilder().transport();
        block15: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    JGroupsChannelConfigurator jGroupsStack = holder.getJGroupsStack(value);
                    if (jGroupsStack == null) {
                        throw Log.CONFIG.missingJGroupsStack(value);
                    }
                    Properties p = new Properties();
                    p.put("channelConfigurator", jGroupsStack);
                    p.put("stack", value);
                    transport.withProperties(p);
                    continue block15;
                }
                case CLUSTER: {
                    transport.clusterName(value);
                    continue block15;
                }
                case EXECUTOR: {
                    transport.transportExecutor(value);
                    transport.transportThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.transport", holder));
                    continue block15;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Log.CONFIG.ignoredAttribute("total order executor", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block15;
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    transport.remoteExecutor(value);
                    transport.remoteCommandThreadPool().read(this.createThreadPoolConfiguration(value, "org.infinispan.executors.remote", holder));
                    continue block15;
                }
                case LOCK_TIMEOUT: {
                    transport.distributedSyncTimeout(Long.valueOf(value));
                    continue block15;
                }
                case NODE_NAME: {
                    transport.nodeName(value);
                    holder.getGlobalConfigurationBuilder().threads().nodeName(value);
                    continue block15;
                }
                case LOCKING: {
                    continue block15;
                }
                case MACHINE_ID: {
                    transport.machineId(value);
                    continue block15;
                }
                case RACK_ID: {
                    transport.rackId(value);
                    continue block15;
                }
                case SITE: {
                    transport.siteId(value);
                    continue block15;
                }
                case INITIAL_CLUSTER_SIZE: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterSize(Integer.valueOf(value));
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                case INITIAL_CLUSTER_TIMEOUT: {
                    if (reader.getSchema().since(8, 2)) {
                        transport.initialClusterTimeout(Long.parseLong(value), TimeUnit.MILLISECONDS);
                        continue block15;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobalState(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        GlobalStateConfigurationBuilder builder = holder.getGlobalConfigurationBuilder().globalState().enable();
        ConfigurationStorage storage = null;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::persistentLocation);
                    continue block10;
                }
                case SHARED_PERSISTENT_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::sharedPersistentLocation);
                    continue block10;
                }
                case TEMPORARY_LOCATION: {
                    this.parseGlobalStatePath(reader, builder::temporaryLocation);
                    continue block10;
                }
                case IMMUTABLE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.IMMUTABLE;
                    continue block10;
                }
                case VOLATILE_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.VOLATILE;
                    continue block10;
                }
                case OVERLAY_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    ParseUtils.requireNoAttributes(reader);
                    ParseUtils.requireNoContent(reader);
                    storage = ConfigurationStorage.OVERLAY;
                    continue block10;
                }
                case MANAGED_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    throw Log.CONFIG.managerConfigurationStorageUnavailable();
                }
                case CUSTOM_CONFIGURATION_STORAGE: {
                    if (storage != null) {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                    storage = ConfigurationStorage.CUSTOM;
                    builder.configurationStorageSupplier(this.parseCustomConfigurationStorage(reader, holder));
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (storage != null) {
            builder.configurationStorage(storage);
        }
    }

    private void parseGlobalStatePath(XMLExtendedStreamReader reader, BiConsumer<String, String> pathItems) throws XMLStreamException {
        String path = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.PATH.getLocalName())[0];
        String relativeTo = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty(reader, i);
                    continue block4;
                }
                case PATH: {
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
        pathItems.accept(path, relativeTo);
    }

    private Supplier<? extends LocalConfigurationStorage> parseCustomConfigurationStorage(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String storageClass = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.CLASS.getLocalName());
        ParseUtils.requireNoContent(reader);
        return Util.getInstanceSupplier((String)storageClass, (ClassLoader)holder.getClassLoader());
    }

    private ThreadPoolConfiguration createThreadPoolConfiguration(String threadPoolName, String componentName, ConfigurationBuilderHolder holder) {
        ThreadsConfigurationBuilder threads = holder.getGlobalConfigurationBuilder().threads();
        ThreadPoolBuilderAdapter threadPool = threads.getThreadPool(threadPoolName);
        if (threadPool == null) {
            throw Log.CONFIG.undefinedThreadPoolName(threadPoolName);
        }
        ThreadPoolConfiguration threadPoolConfiguration = threadPool.asThreadPoolConfigurationBuilder();
        DefaultThreadFactory threadFactory = (DefaultThreadFactory)threadPoolConfiguration.threadFactory();
        if (threadFactory != null) {
            threadFactory.setComponent(KnownComponentNames.shortened(componentName));
        }
        return threadPoolConfiguration;
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, builder);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder) throws XMLStreamException {
        switch (attribute) {
            case NAME: 
            case CONFIGURATION: {
                break;
            }
            case JNDI_NAME: 
            case MODULE: 
            case START: {
                Parser.ignoreAttribute(reader, attribute);
                break;
            }
            case SIMPLE_CACHE: {
                builder.simpleCache(Boolean.parseBoolean(value));
                break;
            }
            case STATISTICS: {
                builder.statistics().enabled(Boolean.parseBoolean(value));
                break;
            }
            case STATISTICS_AVAILABLE: {
                builder.statistics().available(Boolean.parseBoolean(value));
                break;
            }
            case SPIN_DURATION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                }
                Parser.ignoreAttribute(reader, attribute);
                break;
            }
            case UNRELIABLE_RETURN_VALUES: {
                builder.unsafe().unreliableReturnValues(Boolean.parseBoolean(value));
                break;
            }
            default: {
                if (!ParseUtils.isNoNamespaceAttribute(reader, index)) break;
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseSharedStateCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case STATE_TRANSFER: {
                this.parseStateTransfer(reader, builder);
                break;
            }
            default: {
                this.parseCacheElement(reader, element, holder);
            }
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.sites().backups().clear();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        PartitionHandlingConfigurationBuilder ph = builder.clustering().partitionHandling();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    Log.CONFIG.partitionHandlingConfigurationEnabledDeprecated();
                    ph.enabled(Boolean.valueOf(value));
                    continue block5;
                }
                case WHEN_SPLIT: {
                    ph.whenSplit(PartitionHandling.valueOf(value.toUpperCase()));
                    continue block5;
                }
                case MERGE_POLICY: {
                    MergePolicy mp = MergePolicy.fromString(value);
                    MergePolicy mergePolicy = mp == MergePolicy.CUSTOM ? (EntryMergePolicy)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()) : mp;
                    ph.mergePolicy(mergePolicy);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackup(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        BackupConfigurationBuilder backup = builder.sites().addBackup();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    backup.site(value);
                    continue block13;
                }
                case STRATEGY: {
                    backup.strategy(BackupConfiguration.BackupStrategy.valueOf(value));
                    continue block13;
                }
                case BACKUP_FAILURE_POLICY: {
                    backup.backupFailurePolicy(BackupFailurePolicy.valueOf(value));
                    continue block13;
                }
                case TIMEOUT: {
                    backup.replicationTimeout(Long.valueOf(value));
                    continue block13;
                }
                case ENABLED: {
                    backup.enabled(Boolean.valueOf(value));
                    continue block13;
                }
                case USE_TWO_PHASE_COMMIT: {
                    backup.useTwoPhaseCommit(Boolean.parseBoolean(value));
                    continue block13;
                }
                case FAILURE_POLICY_CLASS: {
                    backup.failurePolicyClass(value);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (backup.site() == null) {
            throw ParseUtils.missingRequired(reader, Collections.singleton(Attribute.SITE));
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, backup);
                    continue block14;
                }
                case STATE_TRANSFER: {
                    this.parseXSiteStateTransfer(reader, backup);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    backup.takeOffline().afterFailures(Integer.valueOf(value));
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    backup.takeOffline().minTimeToWait(Long.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseXSiteStateTransfer(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHUNK_SIZE: {
                    backup.stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                case TIMEOUT: {
                    backup.stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case MAX_RETRIES: {
                    backup.stateTransfer().maxRetries(Integer.parseInt(value));
                    continue block6;
                }
                case WAIT_TIME: {
                    backup.stateTransfer().waitTime(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        builder.sites().backupFor().reset();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    builder.sites().backupFor().remoteCache(value);
                    continue block4;
                }
                case REMOTE_SITE: {
                    builder.sites().backupFor().remoteSite(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCacheSecurity(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        SecurityConfigurationBuilder securityBuilder = builder.security();
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, securityBuilder.authorization().enable());
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCacheAuthorization(XMLExtendedStreamReader reader, AuthorizationConfigurationBuilder authzBuilder) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    authzBuilder.enabled(Boolean.parseBoolean(value));
                    continue block4;
                }
                case ROLES: {
                    for (String role : value.split("\\s+")) {
                        authzBuilder.role(role);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseCacheElement(XMLExtendedStreamReader reader, Element element, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        switch (element) {
            case LOCKING: {
                this.parseLocking(reader, builder);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, builder, holder);
                break;
            }
            case EVICTION: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                this.parseEviction(reader, builder);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, builder);
                break;
            }
            case ENCODING: {
                this.parseDataType(reader, builder, holder);
                break;
            }
            case PERSISTENCE: {
                this.parsePersistence(reader, holder);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, holder);
                break;
            }
            case CUSTOM_INTERCEPTORS: {
                Log.CONFIG.customInterceptorsDeprecated();
                this.parseCustomInterceptors(reader, holder);
                break;
            }
            case VERSIONING: {
                this.parseVersioning(reader, holder);
                break;
            }
            case COMPATIBILITY: {
                if (reader.getSchema().since(10, 0)) break;
                this.parseCompatibility(reader, holder);
                break;
            }
            case STORE_AS_BINARY: {
                this.parseStoreAsBinary(reader, holder);
                break;
            }
            case MODULES: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                this.parseModules(reader, holder);
                break;
            }
            case DATA_CONTAINER: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.unexpectedElement(reader);
                }
                this.parseDataContainer(reader);
                break;
            }
            case MEMORY: {
                this.parseMemory(reader, holder);
                break;
            }
            case BACKUPS: {
                this.parseBackups(reader, builder);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, builder);
                break;
            }
            case PARTITION_HANDLING: {
                this.parsePartitionHandling(reader, holder);
                break;
            }
            case SECURITY: {
                this.parseCacheSecurity(reader, builder);
                break;
            }
            default: {
                reader.handleAny(holder);
            }
        }
    }

    private void parseDataContainer(XMLExtendedStreamReader reader) throws XMLStreamException {
        Parser.ignoreElement(reader, Element.DATA_CONTAINER);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: 
                case KEY_EQUIVALENCE: 
                case VALUE_EQUIVALENCE: {
                    Parser.ignoreAttribute(reader, attribute);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties properties = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.ignoreElement(reader, element);
                    Parser.parseProperty(reader, properties);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseMemory(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        ParseUtils.requireNoAttributes(reader);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case OFF_HEAP: {
                    memoryBuilder.storageType(StorageType.OFF_HEAP);
                    this.parseOffHeapMemoryAttributes(reader, holder);
                    continue block5;
                }
                case OBJECT: {
                    memoryBuilder.storageType(StorageType.OBJECT);
                    this.parseObjectMemoryAttributes(reader, holder);
                    continue block5;
                }
                case BINARY: {
                    memoryBuilder.storageType(StorageType.BINARY);
                    this.parseBinaryMemoryAttributes(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseOffHeapMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block6;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block6;
                }
                case ADDRESS_COUNT: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Parser.ignoreAttribute(reader, attribute);
                    continue block6;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseObjectMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block4;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBinaryMemoryAttributes(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        MemoryConfigurationBuilder memoryBuilder = holder.getCurrentConfigurationBuilder().memory();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SIZE: {
                    memoryBuilder.size(Long.parseLong(value));
                    continue block5;
                }
                case EVICTION: {
                    memoryBuilder.evictionType(EvictionType.valueOf(value));
                    continue block5;
                }
                case STRATEGY: {
                    memoryBuilder.evictionStrategy(EvictionStrategy.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        Log.CONFIG.elementDeprecatedUseOther(Element.STORE_AS_BINARY, Element.MEMORY);
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean binaryKeys = null;
        Boolean binaryValues = null;
        builder.memory().storageType(StorageType.BINARY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STORE_KEYS_AS_BINARY: {
                    binaryKeys = Boolean.parseBoolean(value);
                    continue block4;
                }
                case STORE_VALUES_AS_BINARY: {
                    binaryValues = Boolean.parseBoolean(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (binaryKeys != null && !binaryKeys.booleanValue() && binaryValues != null && !binaryValues.booleanValue()) {
            builder.memory().storageType(StorageType.OBJECT);
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        EncodingConfigurationBuilder encoding = builder.encoding();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.valueOf(value).booleanValue()) {
                        encoding.key().mediaType("application/x-java-object");
                        encoding.value().mediaType("application/x-java-object");
                    }
                }
                case MARSHALLER_CLASS: {
                    Log.CONFIG.marshallersNotSupported();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseVersioning(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Log.CONFIG.ignoredAttribute("versioning", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseCustomInterceptors(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case CLASS: {
                    interceptorBuilder.interceptorClass(Util.loadClass((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block7;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        interceptorBuilder.withProperties(Parser.parseProperties(reader));
    }

    protected void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block7;
                }
                case STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block7;
                }
                case ACQUIRE_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block7;
                }
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block7;
                }
                case WRITE_SKEW_CHECK: {
                    Log.CONFIG.ignoredAttribute("write skew attribute", "9.0", attribute.getLocalName(), reader.getLocation().getLineNumber());
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        CacheMode cacheMode;
        if (!reader.getSchema().since(9, 0) && !(cacheMode = builder.clustering().cacheMode()).isSynchronous()) {
            Log.CONFIG.unsupportedAsyncCacheMode(cacheMode, cacheMode.toSync());
            builder.clustering().cacheMode(cacheMode.toSync());
        }
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block12;
                }
                case MODE: {
                    TransactionMode txMode = TransactionMode.valueOf(value);
                    builder.transaction().transactionMode(txMode.getMode());
                    builder.transaction().useSynchronization(!txMode.isXAEnabled() && txMode.getMode().isTransactional());
                    builder.transaction().recovery().enabled(txMode.isRecoveryEnabled());
                    builder.invocationBatching().enable(txMode.isBatchingEnabled());
                    continue block12;
                }
                case LOCKING: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block12;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block12;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(Long.parseLong(value));
                    continue block12;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(Long.parseLong(value));
                    continue block12;
                }
                case TRANSACTION_PROTOCOL: {
                    builder.transaction().transactionProtocol(TransactionProtocol.valueOf(value));
                    continue block12;
                }
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block12;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    builder.transaction().recovery().recoveryInfoCacheName(value);
                    continue block12;
                }
                case NOTIFICATIONS: {
                    builder.transaction().notifications(Boolean.parseBoolean(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    protected void parseDataType(XMLExtendedStreamReader reader, ConfigurationBuilder builder, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        EncodingConfigurationBuilder encodingBuilder = builder.encoding();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_DATA_TYPE: {
                    ContentTypeConfigurationBuilder keyBuilder = encodingBuilder.key();
                    this.parseContentType(reader, holder, keyBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block4;
                }
                case VALUE_DATA_TYPE: {
                    ContentTypeConfigurationBuilder valueBuilder = encodingBuilder.value();
                    this.parseContentType(reader, holder, valueBuilder);
                    ParseUtils.requireNoContent(reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseContentType(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ContentTypeConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MEDIA_TYPE: {
                    builder.mediaType(value);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
    }

    private void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        Log.CONFIG.elementDeprecatedUseOther(Element.EVICTION, Element.MEMORY);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: 
                case THREAD_POLICY: 
                case TYPE: {
                    Parser.ignoreAttribute(reader, attribute);
                    continue block4;
                }
                case SIZE: 
                case MAX_ENTRIES: {
                    builder.memory().size(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block5;
                }
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block5;
                }
                case INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.INVALIDATION_SYNC : CacheMode.INVALIDATION_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY_PARTITIONER: {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block5;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, builder, baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseSegmentedCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, ClassLoader classLoader, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case SEGMENTS: {
                builder.clustering().hash().numSegments(Integer.parseInt(value));
                break;
            }
            case CONSISTENT_HASH_FACTORY: {
                builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance((String)value, (ClassLoader)classLoader));
                break;
            }
            case KEY_PARTITIONER: {
                if (reader.getSchema().since(8, 2)) {
                    builder.clustering().hash().keyPartitioner((KeyPartitioner)Util.getInstance((String)value, (ClassLoader)classLoader));
                    break;
                }
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
            default: {
                this.parseClusteredCacheAttribute(reader, index, attribute, value, builder, baseCacheMode);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ConfigurationBuilder builder, CacheMode baseCacheMode) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                if (reader.getSchema().since(9, 0)) {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                }
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case MODE: {
                Mode mode = Mode.valueOf(value);
                builder.clustering().cacheMode(mode.apply(baseCacheMode));
                break;
            }
            case QUEUE_SIZE: {
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                Log.CONFIG.ignoredReplicationQueueAttribute(attribute.getLocalName(), reader.getLocation().getLineNumber());
                break;
            }
            case REMOTE_TIMEOUT: {
                builder.clustering().remoteTimeout(Long.parseLong(value));
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, builder);
            }
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.REPL_SYNC : CacheMode.REPL_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case ENABLED: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        holder.pushScope(template ? ParserScope.CACHE_TEMPLATE : ParserScope.CACHE);
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.DIST_SYNC : CacheMode.DIST_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block9;
                }
                case L1_LIFESPAN: {
                    long lifespan = Long.parseLong(value);
                    if (lifespan > 0L) {
                        builder.clustering().l1().enable().lifespan(lifespan);
                        continue block9;
                    }
                    builder.clustering().l1().disable();
                    continue block9;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block9;
                }
                case CAPACITY_FACTOR: {
                    builder.clustering().hash().capacityFactor(Float.parseFloat(value));
                    continue block9;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block10;
                }
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
        holder.popScope();
    }

    private void parseGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String value;
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireSingleAttribute((XMLStreamReader)reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader()));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseScatteredCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, boolean template) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Attribute.NAME.getLocalName());
        if (!template && GlobUtils.isGlob((String)name)) {
            throw Log.CONFIG.wildcardsNotAllowedInCacheNames(name);
        }
        String configuration = reader.getAttributeValue(null, Attribute.CONFIGURATION.getLocalName());
        ConfigurationBuilder builder = this.getConfigurationBuilder(holder, name, template, configuration);
        CacheMode baseCacheMode = configuration == null ? CacheMode.SCATTERED_SYNC : CacheMode.SCATTERED_SYNC.toSync(builder.clustering().cacheMode().isSynchronous());
        builder.clustering().cacheMode(baseCacheMode);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INVALIDATION_BATCH_SIZE: {
                    builder.clustering().invalidationBatchSize(Integer.parseInt(value));
                    continue block5;
                }
                default: {
                    this.parseSegmentedCacheAttribute(reader, i, attribute, value, builder, holder.getClassLoader(), baseCacheMode);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseSharedStateCacheElement(reader, element, holder);
        }
    }

    private ConfigurationBuilder getConfigurationBuilder(ConfigurationBuilderHolder holder, String name, boolean template, String baseConfigurationName) {
        if (holder.getNamedConfigurationBuilders().containsKey(name)) {
            throw Log.CONFIG.duplicateCacheName(name);
        }
        ConfigurationBuilder builder = holder.newConfigurationBuilder(name);
        if (baseConfigurationName != null) {
            ConfigurationBuilder baseConfigurationBuilder = holder.getNamedConfigurationBuilders().get(baseConfigurationName);
            if (baseConfigurationBuilder == null) {
                throw Log.CONFIG.undeclaredConfiguration(baseConfigurationName, name);
            }
            Configuration baseConfiguration = baseConfigurationBuilder.build();
            if (!baseConfiguration.isTemplate()) {
                throw Log.CONFIG.noConfiguration(baseConfigurationName);
            }
            builder.read(baseConfiguration);
        }
        return builder.template(template);
    }

    private void parsePersistence(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block12: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.persistence().passivation(Boolean.parseBoolean(value));
                    continue block12;
                }
                case AVAILABILITY_INTERVAL: {
                    builder.persistence().availabilityInterval(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_ATTEMPTS: {
                    builder.persistence().connectionAttempts(Integer.parseInt(value));
                    continue block12;
                }
                case CONNECTION_INTERVAL: {
                    builder.persistence().connectionInterval(Integer.parseInt(value));
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        builder.persistence().clearStores();
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_LOADER: {
                    this.parseClusterLoader(reader, holder);
                    continue block13;
                }
                case FILE_STORE: {
                    this.parseFileStore(reader, holder);
                    continue block13;
                }
                case STORE: {
                    this.parseCustomStore(reader, holder);
                    continue block13;
                }
                case LOADER: {
                    Parser.ignoreElement(reader, element);
                    continue block13;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterLoaderConfigurationBuilder cclb = builder.persistence().addClusterLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    cclb.remoteCallTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    Parser.parseStoreAttribute(reader, i, cclb);
                }
            }
        }
        this.parseStoreElements(reader, cclb);
    }

    protected void parseFileStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        SingleFileStoreConfigurationBuilder storeBuilder = holder.getCurrentConfigurationBuilder().persistence().addSingleFileStore();
        String path = null;
        String relativeTo = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = ParseUtils.requireAttributeProperty(reader, i);
                    continue block6;
                }
                case PATH: {
                    path = value;
                    continue block6;
                }
                case MAX_ENTRIES: {
                    storeBuilder.maxEntries(Integer.valueOf(value));
                    continue block6;
                }
                case FRAGMENTATION_FACTOR: {
                    storeBuilder.fragmentationFactor(Float.parseFloat(value));
                    continue block6;
                }
                default: {
                    Parser.parseStoreAttribute(reader, i, storeBuilder);
                }
            }
        }
        if ((path = ParseUtils.resolvePath(path, relativeTo)) != null) {
            storeBuilder.location(path);
        }
        this.parseStoreElements(reader, storeBuilder);
    }

    public static void parseStoreAttribute(XMLExtendedStreamReader reader, int index, AbstractStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        if (reader.getSchema().getMajor() < 10) {
            storeBuilder.segmented(false);
        }
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case SHARED: {
                storeBuilder.shared(Boolean.parseBoolean(value));
                break;
            }
            case READ_ONLY: {
                storeBuilder.ignoreModifications(Boolean.valueOf(value));
                break;
            }
            case PRELOAD: {
                storeBuilder.preload(Boolean.parseBoolean(value));
                break;
            }
            case FETCH_STATE: {
                storeBuilder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case PURGE: {
                storeBuilder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case SINGLETON: {
                if (reader.getSchema().since(10, 0)) {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
                }
                Parser.ignoreAttribute(reader, attribute);
                break;
            }
            case TRANSACTIONAL: {
                storeBuilder.transactional(Boolean.parseBoolean(value));
                break;
            }
            case MAX_BATCH_SIZE: {
                storeBuilder.maxBatchSize(Integer.parseInt(value));
                break;
            }
            case SEGMENTED: {
                storeBuilder.segmented(Boolean.parseBoolean(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, index);
            }
        }
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser.parseStoreElement(reader, storeBuilder);
        }
    }

    public static void parseStoreElement(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case WRITE_BEHIND: {
                Parser.parseStoreWriteBehind(reader, storeBuilder.async().enable());
                break;
            }
            case PROPERTY: {
                Parser.parseStoreProperty(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseStoreWriteBehind(XMLExtendedStreamReader reader, AsyncStoreConfigurationBuilder<?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Parser.ignoreAttribute(reader, attribute);
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case FAIL_SILENTLY: {
                    storeBuilder.failSilently(Boolean.parseBoolean(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    if (reader.getSchema().since(9, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, attribute.getLocalName());
                    }
                    Parser.ignoreAttribute(reader, attribute);
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.threadPoolSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseStoreProperty(XMLExtendedStreamReader reader, StoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        String property = ParseUtils.requireSingleAttribute((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String value = reader.getElementText();
        storeBuilder.addProperty(property, value);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Boolean preload = null;
        Boolean shared = null;
        Boolean transactional = null;
        Object store = null;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store = (CacheLoader)Util.getInstance((String)value, (ClassLoader)holder.getClassLoader());
                    continue block10;
                }
                case FETCH_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block10;
                }
                case READ_ONLY: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block10;
                }
                case PURGE: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block10;
                }
                case PRELOAD: {
                    preload = Boolean.parseBoolean(value);
                    continue block10;
                }
                case SHARED: {
                    shared = Boolean.parseBoolean(value);
                    continue block10;
                }
                case SINGLETON: {
                    if (reader.getSchema().since(10, 0)) {
                        throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                    }
                    Parser.ignoreAttribute(reader, attribute);
                    continue block10;
                }
                case TRANSACTIONAL: {
                    transactional = Boolean.parseBoolean(value);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        if (store != null) {
            if (store instanceof SingleFileStore) {
                SingleFileStoreConfigurationBuilder sfs = builder.persistence().addSingleFileStore();
                if (fetchPersistentState != null) {
                    sfs.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    sfs.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    sfs.purgeOnStartup(purgeOnStartup);
                }
                if (preload != null) {
                    sfs.preload(preload);
                }
                if (shared != null) {
                    sfs.shared(shared);
                }
                if (transactional != null) {
                    sfs.transactional(transactional);
                }
                this.parseStoreElements(reader, sfs);
            } else if (store instanceof ClusterLoader) {
                ClusterLoaderConfigurationBuilder cscb = builder.persistence().addClusterLoader();
                this.parseStoreElements(reader, cscb);
            } else {
                Class configuredBy;
                ConfiguredBy annotation = store.getClass().getAnnotation(ConfiguredBy.class);
                Class<StoreConfigurationBuilder> builderClass = null;
                if (annotation != null && (configuredBy = annotation.value()) != null) {
                    BuiltBy builtBy = configuredBy.getAnnotation(BuiltBy.class);
                    builderClass = builtBy.value().asSubclass(StoreConfigurationBuilder.class);
                }
                Object configBuilder = builderClass == null ? builder.persistence().addStore(CustomStoreConfigurationBuilder.class).customStoreClass(store.getClass()) : builder.persistence().addStore(builderClass);
                if (fetchPersistentState != null) {
                    configBuilder.fetchPersistentState(fetchPersistentState.booleanValue());
                }
                if (ignoreModifications != null) {
                    configBuilder.ignoreModifications(ignoreModifications.booleanValue());
                }
                if (purgeOnStartup != null) {
                    configBuilder.purgeOnStartup(purgeOnStartup.booleanValue());
                }
                if (preload != null) {
                    configBuilder.preload(preload.booleanValue());
                }
                if (shared != null) {
                    configBuilder.shared(shared.booleanValue());
                }
                if (transactional != null) {
                    configBuilder.transactional(transactional.booleanValue());
                }
                this.parseStoreElements(reader, (StoreConfigurationBuilder<?, ?>)configBuilder);
            }
        }
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    if ("LOCAL".equals(value)) {
                        value = "PRIMARY_OWNER";
                        Log.CONFIG.indexLocalIsNotSupported();
                    }
                    Index index = Index.valueOf(value);
                    builder.indexing().index(index);
                    continue block9;
                }
                case AUTO_CONFIG: {
                    builder.indexing().autoConfig(Boolean.parseBoolean(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        Properties indexingProperties = new Properties();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMERS: {
                    this.parseKeyTransformers(reader, holder, builder);
                    continue block10;
                }
                case INDEXED_ENTITIES: {
                    this.parseIndexedEntities(reader, holder, builder);
                    continue block10;
                }
                case PROPERTY: {
                    Parser.parseProperty(reader, indexingProperties);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        builder.indexing().withProperties(indexingProperties);
    }

    private void parseKeyTransformers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_TRANSFORMER: {
                    this.parseKeyTransformer(reader, holder, builder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseKeyTransformer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        String[] attrs = ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.KEY.getLocalName(), Attribute.TRANSFORMER.getLocalName());
        Class keyClass = Util.loadClass((String)attrs[0], (ClassLoader)holder.getClassLoader());
        Class transformerClass = Util.loadClass((String)attrs[1], (ClassLoader)holder.getClassLoader());
        builder.indexing().addKeyTransformer(keyClass, transformerClass);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case KEY: 
                case TRANSFORMER: {
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexedEntities(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder, ConfigurationBuilder builder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INDEXED_ENTITY: {
                    ParseUtils.requireNoAttributes(reader);
                    String className = reader.getElementText();
                    Class indexedEntity = Util.loadClass((String)className, (ClassLoader)holder.getClassLoader());
                    builder.indexing().addIndexedEntity(indexedEntity);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private static void parseProperty(XMLExtendedStreamReader reader, Properties properties) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        ParseUtils.requireAttributes((XMLStreamReader)reader, Attribute.NAME.getLocalName());
        String key = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    key = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, i);
                }
            }
        }
        String propertyValue = reader.getElementText();
        properties.setProperty(key, propertyValue);
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        Properties properties = new Properties();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    Parser.parseProperty(reader, properties);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return properties;
    }

    @Override
    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    public static enum Mode {
        SYNC(true),
        ASYNC(false);

        private final boolean sync;

        private Mode(boolean sync) {
            this.sync = sync;
        }

        public static Mode forCacheMode(CacheMode mode) {
            return mode.isSynchronous() ? SYNC : ASYNC;
        }

        public CacheMode apply(CacheMode mode) {
            return this.sync ? mode.toSync() : mode.toAsync();
        }

        public boolean isSynchronous() {
            return this.sync;
        }
    }

    public static enum TransactionMode {
        NONE(org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL, false, false, false),
        BATCH(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, true),
        NON_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, false, false, false),
        NON_DURABLE_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, false, false),
        FULL_XA(org.infinispan.transaction.TransactionMode.TRANSACTIONAL, true, true, false);

        private final org.infinispan.transaction.TransactionMode mode;
        private final boolean xaEnabled;
        private final boolean recoveryEnabled;
        private final boolean batchingEnabled;

        private TransactionMode(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            this.mode = mode;
            this.xaEnabled = xaEnabled;
            this.recoveryEnabled = recoveryEnabled;
            this.batchingEnabled = batchingEnabled;
        }

        public static TransactionMode fromConfiguration(org.infinispan.transaction.TransactionMode mode, boolean xaEnabled, boolean recoveryEnabled, boolean batchingEnabled) {
            if (mode == org.infinispan.transaction.TransactionMode.NON_TRANSACTIONAL) {
                return NONE;
            }
            for (TransactionMode txMode : TransactionMode.values()) {
                if (txMode.mode != mode || txMode.xaEnabled != xaEnabled || txMode.recoveryEnabled != recoveryEnabled || txMode.batchingEnabled != batchingEnabled) continue;
                return txMode;
            }
            throw Log.CONFIG.unknownTransactionConfiguration(mode, xaEnabled, recoveryEnabled, batchingEnabled);
        }

        public org.infinispan.transaction.TransactionMode getMode() {
            return this.mode;
        }

        public boolean isXAEnabled() {
            return this.xaEnabled;
        }

        public boolean isRecoveryEnabled() {
            return this.recoveryEnabled;
        }

        public boolean isBatchingEnabled() {
            return this.batchingEnabled;
        }
    }
}

