/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationCacheLoaderInterceptor<K, V>
extends CacheLoaderInterceptor<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    DataOperationOrderer orderer;
    @Inject
    ActivationManager activationManager;

    @Override
    public CompletionStage<InternalCacheEntry<K, V>> loadAndStoreInDataContainer(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        Supplier<CompletionStage<InternalCacheEntry<K, V>>> supplier = () -> super.loadAndStoreInDataContainer(ctx, key, segment, cmd);
        return PassivationCacheLoaderInterceptor.handlePassivationLoad(key, segment, this.orderer, this.activationManager, supplier);
    }

    static <K, V> CompletionStage<InternalCacheEntry<K, V>> handlePassivationLoad(Object key, int segment, DataOperationOrderer orderer, ActivationManager activationManager, Supplier<CompletionStage<InternalCacheEntry<K, V>>> supplier) {
        CompletableFuture<DataOperationOrderer.Operation> future = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage<DataOperationOrderer.Operation> delayStage = orderer.orderOn(key, future);
        CompletionStage<InternalCacheEntry<K, V>> retrievalStage = delayStage != null ? delayStage.thenCompose(ignore -> (CompletionStage)supplier.get()) : supplier.get();
        return retrievalStage.whenComplete((value, t) -> {
            if (value != null) {
                if (trace) {
                    log.tracef("Activating key: %s - not waiting for response", value.getKey());
                }
                activationManager.activateAsync(value.getKey(), segment).whenComplete((ignore, throwable) -> {
                    if (throwable != null) {
                        log.warnf("Activation of key %s failed for some reason", t);
                    }
                    orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
                });
            } else {
                orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ);
            }
        });
    }
}

