/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;

public class OptimisticBackupInterceptor
extends BaseBackupInterceptor {
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.shouldInvokeRemoteTxCommand(ctx) || this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupPrepare(command, (AbstractCacheTransaction)ctx.getCacheTransaction(), ctx.getTransaction());
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.shouldInvokeRemoteTxCommand(ctx) ? this.backupSender.backupCommit(command, ctx.getTransaction()) : InvocationStage.completedNullStage();
        return this.invokeNextThenApply(ctx, command, (rCtx, rCommand, rv) -> {
            this.iracManager.trackKeysFromTransaction(this.getModificationsFrom((CommitCommand)rCommand), rCommand.getGlobalTransaction());
            return stage.thenReturn(rCtx, rCommand, rv);
        });
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.shouldRollbackRemoteTxCommand(ctx)) {
            return this.invokeNext(ctx, command);
        }
        if (this.isTxFromRemoteSite(command.getGlobalTransaction())) {
            return this.invokeNext(ctx, command);
        }
        InvocationStage stage = this.backupSender.backupRollback(command, ctx.getTransaction());
        return this.invokeNextAndWaitForCrossSite(ctx, command, stage);
    }

    private boolean shouldRollbackRemoteTxCommand(TxInvocationContext<?> ctx) {
        return this.shouldInvokeRemoteTxCommand(ctx) && this.hasBeenPrepared((LocalTxInvocationContext)ctx);
    }

    private boolean hasBeenPrepared(LocalTxInvocationContext ctx) {
        return !ctx.getRemoteLocksAcquired().isEmpty();
    }
}

