/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeListener;
import org.infinispan.commons.stat.DefaultSimpleStat;
import org.infinispan.commons.stat.SimpleStat;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.logging.TraceException;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

@MBean(objectName="RpcManager", description="Manages all remote calls to remote cache instances in the cluster.")
@Scope(value=Scopes.NAMED_CACHE)
public class RpcManagerImpl
implements RpcManager,
JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(RpcManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    Transport t;
    @Inject
    Configuration configuration;
    @Inject
    ComponentRef<CommandsFactory> cf;
    @Inject
    DistributionManager distributionManager;
    @Inject
    TimeService timeService;
    private final Function<ReplicableCommand, ReplicableCommand> toCacheRpcCommand = this::toCacheRpcCommand;
    private final AttributeListener<Long> updateRpcOptions = this::updateRpcOptions;
    private final XSiteResponse.XSiteResponseCompleted xSiteResponseCompleted = this::registerXSiteTime;
    private final AtomicLong replicationCount = new AtomicLong(0L);
    private final AtomicLong replicationFailures = new AtomicLong(0L);
    private final AtomicLong totalReplicationTime = new AtomicLong(0L);
    private volatile SimpleStat xSiteReplicationTime = new DefaultSimpleStat();
    private boolean statisticsEnabled = false;
    private volatile RpcOptions syncRpcOptions;

    @Start(priority=9)
    void start() {
        this.statisticsEnabled = this.configuration.statistics().enabled();
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).addListener(this.updateRpcOptions);
        this.updateRpcOptions((Attribute<Long>)this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT), null);
    }

    @Stop
    void stop() {
        this.configuration.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT).removeListener(this.updateRpcOptions);
    }

    private void updateRpcOptions(Attribute<Long> attribute, Long oldValue) {
        this.syncRpcOptions = new RpcOptions(DeliverOrder.NONE, (Long)attribute.get(), TimeUnit.MILLISECONDS);
    }

    @ManagedAttribute(description="Retrieves the committed view.", displayName="Committed view", dataType=DataType.TRAIT)
    public String getCommittedViewAsString() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        return cacheTopology.getCurrentCH().getMembers().toString();
    }

    @ManagedAttribute(description="Retrieves the pending view.", displayName="Pending view", dataType=DataType.TRAIT)
    public String getPendingViewAsString() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            return "N/A";
        }
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        return pendingCH != null ? pendingCH.getMembers().toString() : "null";
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommand(target, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommand(target, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    private void checkTopologyId(ReplicableCommand command) {
        if (command instanceof TopologyAffectedCommand && ((TopologyAffectedCommand)command).getTopologyId() < 0) {
            throw new IllegalArgumentException("Command does not have a topology id");
        }
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommand(targets, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommand(targets, (ReplicableCommand)cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    private <T> T updateStatistics(long startTimeNanos, T response, Throwable throwable) {
        long timeTaken = this.timeService.timeDuration(startTimeNanos, TimeUnit.MILLISECONDS);
        this.totalReplicationTime.getAndAdd(timeTaken);
        if (throwable == null) {
            if (this.statisticsEnabled) {
                this.replicationCount.incrementAndGet();
            }
            return response;
        }
        if (this.statisticsEnabled) {
            this.replicationFailures.incrementAndGet();
        }
        return this.rethrowAsCacheException(throwable);
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        List<Address> cacheMembers = this.distributionManager.getCacheTopology().getMembers();
        if (!this.statisticsEnabled) {
            return this.t.invokeCommandOnAll(cacheMembers, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommandOnAll(cacheMembers, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        if (!this.statisticsEnabled) {
            return this.t.invokeCommandStaggered(targets, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommandStaggered(targets, cacheRpc, collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, RpcOptions rpcOptions) {
        CompletionStage<Object> invocation;
        if (!this.statisticsEnabled) {
            return this.t.invokeCommands(targets, commandGenerator.andThen(this.toCacheRpcCommand), collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        long startTimeNanos = this.timeService.time();
        try {
            invocation = this.t.invokeCommands(targets, commandGenerator.andThen(this.toCacheRpcCommand), collector, rpcOptions.deliverOrder(), rpcOptions.timeout(), rpcOptions.timeUnit());
        }
        catch (Exception e) {
            return (CompletionStage)this.errorReplicating(e);
        }
        return invocation.handle((response, throwable) -> this.updateStatistics(startTimeNanos, (Object)response, (Throwable)throwable));
    }

    @Override
    public <T> T blocking(CompletionStage<T> request) {
        try {
            return CompletableFutures.await(request.toCompletableFuture());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CacheException("Thread interrupted while invoking RPC", (Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            cause.addSuppressed((Throwable)new TraceException());
            if (cause instanceof CacheException) {
                throw (CacheException)cause;
            }
            throw new CacheException("Unexpected exception replicating command", cause);
        }
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpc, RpcOptions options) {
        CompletableFuture<Map<Address, Response>> invocation;
        this.setTopologyId(rpc);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(rpc);
        long startTimeNanos = this.statisticsEnabled ? this.timeService.time() : 0L;
        try {
            invocation = this.t.invokeRemotelyAsync(recipients, cacheRpc, ResponseMode.SYNCHRONOUS, options.timeUnit().toMillis(options.timeout()), null, options.deliverOrder(), this.configuration.clustering().cacheMode().isDistributed());
        }
        catch (Exception e) {
            Log.CLUSTER.unexpectedErrorReplicating(e);
            if (this.statisticsEnabled) {
                this.replicationFailures.incrementAndGet();
            }
            return (CompletableFuture)this.rethrowAsCacheException(e);
        }
        return invocation.whenComplete((responseMap, throwable) -> {
            if (this.statisticsEnabled) {
                this.updateStatistics(startTimeNanos, (Object)responseMap, (Throwable)throwable);
            }
        });
    }

    private <T> T rethrowAsCacheException(Throwable throwable) {
        if (throwable.getCause() != null && throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof CacheException) {
            log.trace("Replication exception", throwable);
            throw (CacheException)throwable;
        }
        Log.CLUSTER.unexpectedErrorReplicating(throwable);
        throw new CacheException(throwable);
    }

    private CacheRpcCommand toCacheRpcCommand(ReplicableCommand command) {
        this.checkTopologyId(command);
        return command instanceof CacheRpcCommand ? (CacheRpcCommand)command : this.cf.wired().buildSingleRpcCommand((VisitableCommand)command);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendTo(destination, cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public void sendToMany(Collection<Address> destinations, ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendToMany(destinations, cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.setTopologyId(command);
        CacheRpcCommand cacheRpc = this.toCacheRpcCommand(command);
        try {
            this.t.sendToAll(cacheRpc, deliverOrder);
        }
        catch (Exception e) {
            this.errorReplicating(e);
        }
    }

    @Override
    public XSiteResponse invokeXSite(XSiteBackup backup, XSiteReplicateCommand command) {
        if (!this.statisticsEnabled) {
            return this.t.backupRemotely(backup, command);
        }
        XSiteResponse rsp = this.t.backupRemotely(backup, command);
        rsp.whenCompleted(this.xSiteResponseCompleted);
        return rsp;
    }

    private void registerXSiteTime(XSiteBackup backup, long sendDurationNanos, long durationNanos, Throwable ignored) {
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(durationNanos);
        this.xSiteReplicationTime.record(durationMillis);
    }

    private <T> T errorReplicating(Throwable t) {
        Log.CLUSTER.unexpectedErrorReplicating(t);
        if (this.statisticsEnabled) {
            this.replicationFailures.incrementAndGet();
        }
        return this.rethrowAsCacheException(t);
    }

    @Override
    public Transport getTransport() {
        return this.t;
    }

    private void setTopologyId(ReplicableCommand command) {
        TopologyAffectedCommand topologyAffectedCommand;
        if (command instanceof TopologyAffectedCommand && (topologyAffectedCommand = (TopologyAffectedCommand)command).getTopologyId() == -1) {
            int currentTopologyId = this.distributionManager.getCacheTopology().getTopologyId();
            if (trace) {
                log.tracef("Topology id missing on command %s, setting it to %d", command, currentTopologyId);
            }
            topologyAffectedCommand.setTopologyId(currentTopologyId);
        }
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.replicationCount.set(0L);
        this.replicationFailures.set(0L);
        this.totalReplicationTime.set(0L);
        this.xSiteReplicationTime = new DefaultSimpleStat();
    }

    @ManagedAttribute(description="Number of successful replications", displayName="Number of successful replications", measurementType=MeasurementType.TRENDSUP)
    public long getReplicationCount() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationCount.get();
    }

    @ManagedAttribute(description="Number of failed replications", displayName="Number of failed replications", measurementType=MeasurementType.TRENDSUP)
    public long getReplicationFailures() {
        if (!this.isStatisticsEnabled()) {
            return -1L;
        }
        return this.replicationFailures.get();
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    @Deprecated
    @ManagedOperation(displayName="Enable/disable statistics. Deprecated, use the statisticsEnabled attribute instead.")
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications", displayName="Successful replications ratio")
    public String getSuccessRatio() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double ration = this.calculateSuccessRatio() * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    @ManagedAttribute(description="Successful replications as a ratio of total replications in numeric double format", displayName="Successful replication ratio", units=Units.PERCENTAGE)
    public double getSuccessRatioFloatingPoint() {
        if (this.replicationCount.get() == 0L || !this.statisticsEnabled) {
            return 0.0;
        }
        return this.calculateSuccessRatio();
    }

    private double calculateSuccessRatio() {
        double totalCount = this.replicationCount.get() + this.replicationFailures.get();
        return (double)this.replicationCount.get() / totalCount;
    }

    @ManagedAttribute(description="The average time spent in the transport layer, in milliseconds", displayName="Average time spent in the transport layer", units=Units.MILLISECONDS)
    public long getAverageReplicationTime() {
        if (this.replicationCount.get() == 0L) {
            return 0L;
        }
        return this.totalReplicationTime.get() / this.replicationCount.get();
    }

    @ManagedAttribute(description="Retrieves the x-site view.", displayName="Cross site (x-site) view", dataType=DataType.TRAIT)
    public String getSitesView() {
        Set<String> sitesView = this.t.getSitesView();
        return sitesView != null ? sitesView.toString() : "N/A";
    }

    @ManagedAttribute(description="Returns the average replication time, in milliseconds, for a cross-site replication request", displayName="Average Cross-Site replication time", units=Units.MILLISECONDS)
    public long getAverageXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteReplicationTime.getAverage(-1L) : -1L;
    }

    @ManagedAttribute(description="Returns the minimum replication time, in milliseconds, for a cross-site replication request", displayName="Minimum Cross-Site replication time", units=Units.MILLISECONDS)
    public long getMinimumXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteReplicationTime.getMin(-1L) : -1L;
    }

    @ManagedAttribute(description="Returns the maximum replication time, in milliseconds, for a cross-site replication request", displayName="Minimum Cross-Site replication time", units=Units.MILLISECONDS)
    public long getMaximumXSiteReplicationTime() {
        return this.isStatisticsEnabled() ? this.xSiteReplicationTime.getMax(-1L) : -1L;
    }

    @ManagedAttribute(description="Returns the number of sync cross-site requests", displayName="Cross-Site replication requests")
    public long getNumberXSiteRequests() {
        return this.isStatisticsEnabled() ? this.xSiteReplicationTime.count() : 0L;
    }

    public void setTransport(Transport t) {
        this.t = t;
    }

    @Override
    public Address getAddress() {
        return this.t != null ? this.t.getAddress() : null;
    }

    @Override
    public int getTopologyId() {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        return cacheTopology != null ? cacheTopology.getTopologyId() : -1;
    }

    @Override
    public RpcOptions getSyncRpcOptions() {
        return this.syncRpcOptions;
    }

    @Override
    public List<Address> getMembers() {
        return this.distributionManager.getCacheTopology().getMembers();
    }
}

