/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.AbstractTypedPropertiesConfiguration;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class IndexingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<IndexingConfiguration>,
ConfigurationBuilderInfo {
    private static final String DIRECTORY_PROVIDER_SUFFIX = "directory.type";
    private static final String DIRECTORY_PROVIDER_KEY1 = "hibernate.search.backends.infinispan_backend.directory.type";
    private static final String DIRECTORY_PROVIDER_KEY2 = "directory.type";
    private static final String EXCLUSIVE_INDEX_USE = "hibernate.search.default.exclusive_index_use";
    private static final String INDEX_MANAGER = "hibernate.search.default.indexmanager";
    private static final String READER_STRATEGY = "hibernate.search.default.reader.strategy";
    private static final String FS_PROVIDER = "filesystem";
    @Deprecated
    private static final String RAM_DIRECTORY_PROVIDER = "ram";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER = "local-heap";
    private static final String LOCAL_HEAP_DIRECTORY_PROVIDER_FQN = "org.hibernate.search.store.impl.RAMDirectoryProvider";
    private final AttributeSet attributes;
    private final Set<Class<?>> resolvedIndexedClasses = new HashSet();

    IndexingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = IndexingConfiguration.attributeDefinitionSet();
    }

    public IndexingConfigurationBuilder enabled(boolean enabled) {
        if (this.attributes.attribute(IndexingConfiguration.INDEX).isModified()) {
            throw Log.CONFIG.indexEnabledAndIndexModeAreExclusive();
        }
        this.attributes.attribute(IndexingConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    public IndexingConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public IndexingConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public boolean enabled() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.ENABLED).get();
    }

    public IndexingConfigurationBuilder addKeyTransformer(Class<?> keyClass, Class<?> keyTransformerClass) {
        Map<Class<?>, Class<?>> indexedEntities = this.keyTransformers();
        indexedEntities.put(keyClass, keyTransformerClass);
        this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).set(indexedEntities);
        return this;
    }

    private Map<Class<?>, Class<?>> keyTransformers() {
        return (Map)this.attributes.attribute(IndexingConfiguration.KEY_TRANSFORMERS).get();
    }

    public IndexingConfigurationBuilder addProperty(String key, String value) {
        return this.setProperty(key, value);
    }

    public IndexingConfigurationBuilder setProperty(String key, Object value) {
        TypedProperties properties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        properties.put((Object)key, value);
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)properties);
        return this;
    }

    public IndexingConfigurationBuilder withProperties(Properties props) {
        this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)TypedProperties.toTypedProperties((Properties)props));
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder index(Index index) {
        if (this.attributes.attribute(IndexingConfiguration.ENABLED).isModified()) {
            throw Log.CONFIG.indexEnabledAndIndexModeAreExclusive();
        }
        this.enabled(index != null && index != Index.NONE);
        this.attributes.attribute(IndexingConfiguration.INDEX).set((Object)index);
        return this;
    }

    @Deprecated
    public IndexingConfigurationBuilder autoConfig(boolean autoConfig) {
        if (autoConfig && !this.attributes.attribute(IndexingConfiguration.ENABLED).isModified()) {
            this.enable();
        }
        this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).set((Object)autoConfig);
        return this;
    }

    @Deprecated
    public boolean autoConfig() {
        return (Boolean)this.attributes.attribute(IndexingConfiguration.AUTO_CONFIG).get();
    }

    public IndexingConfigurationBuilder addIndexedEntity(String indexedEntity) {
        if (indexedEntity == null || indexedEntity.length() == 0) {
            throw new CacheConfigurationException("Type name must not be null or empty");
        }
        Set<String> indexedEntitySet = this.indexedEntities();
        indexedEntitySet.add(indexedEntity);
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    public IndexingConfigurationBuilder addIndexedEntities(String ... indexedEntities) {
        Set<String> indexedEntitySet = this.indexedEntities();
        for (String typeName : indexedEntities) {
            if (typeName == null || typeName.length() == 0) {
                throw new CacheConfigurationException("Type name must not be null or empty");
            }
            indexedEntitySet.add(typeName);
        }
        this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).set(indexedEntitySet);
        return this;
    }

    public IndexingConfigurationBuilder addIndexedEntity(Class<?> indexedEntity) {
        this.addIndexedEntity(indexedEntity.getName());
        this.resolvedIndexedClasses.add(indexedEntity);
        return this;
    }

    public IndexingConfigurationBuilder addIndexedEntities(Class<?> ... indexedEntities) {
        this.addIndexedEntities((String[])Arrays.stream(indexedEntities).map(Class::getName).toArray(String[]::new));
        Collections.addAll(this.resolvedIndexedClasses, indexedEntities);
        return this;
    }

    public Set<String> indexedEntities() {
        return (Set)this.attributes.attribute(IndexingConfiguration.INDEXED_ENTITIES).get();
    }

    public void validate() {
        if (this.enabled()) {
            if (this.clustering().cacheMode().isInvalidation()) {
                throw Log.CONFIG.invalidConfigurationIndexingWithInvalidation();
            }
            if (this.indexedEntities().isEmpty() && !this.getBuilder().template()) {
                Log.CONFIG.noIndexableClassesDefined();
            }
        } else if (!this.indexedEntities().isEmpty()) {
            // empty if block
        }
        if (this.attributes.attribute(IndexingConfiguration.INDEX).get() == Index.PRIMARY_OWNER) {
            throw Log.CONFIG.indexModeNotSupported(Index.PRIMARY_OWNER.name());
        }
        this.ensureSingleIndexingProvider();
    }

    private void ensureSingleIndexingProvider() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        String defaultProvider = typedProperties.getProperty(DIRECTORY_PROVIDER_KEY1);
        if (defaultProvider == null) {
            defaultProvider = typedProperties.getProperty("directory.type", FS_PROVIDER);
        }
        HashSet<String> providers = new HashSet<String>();
        providers.add(defaultProvider.trim().toLowerCase());
        typedProperties.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("directory.type")).forEach(e -> providers.add(((String)e.getValue()).trim().toLowerCase()));
        if (providers.size() > 1) {
            throw Log.CONFIG.foundMultipleDirectoryProviders();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        if (this.enabled()) {
            try {
                String clazz = "org.infinispan.query.Search";
                Util.loadClassStrict((String)clazz, (ClassLoader)globalConfig.classLoader());
            }
            catch (ClassNotFoundException e) {
                throw Log.CONFIG.invalidConfigurationIndexingWithoutModule();
            }
        }
    }

    private void applyAutoConfig(TypedProperties properties) {
        properties.putIfAbsent(DIRECTORY_PROVIDER_KEY1, FS_PROVIDER);
        properties.putIfAbsent(EXCLUSIVE_INDEX_USE, "true");
        properties.putIfAbsent(INDEX_MANAGER, "near-real-time");
        properties.putIfAbsent(READER_STRATEGY, "shared");
    }

    public IndexingConfiguration create() {
        TypedProperties typedProperties = (TypedProperties)this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).get();
        if (this.autoConfig()) {
            this.applyAutoConfig(typedProperties);
            this.attributes.attribute(AbstractTypedPropertiesConfiguration.PROPERTIES).set((Object)typedProperties);
            this.ensureSingleIndexingProvider();
        }
        boolean isVolatile = typedProperties.entrySet().stream().anyMatch(e -> {
            if (((String)e.getKey()).endsWith("directory.type")) {
                String directoryImplementationName = String.valueOf(e.getValue()).trim();
                return LOCAL_HEAP_DIRECTORY_PROVIDER.equalsIgnoreCase(directoryImplementationName) || LOCAL_HEAP_DIRECTORY_PROVIDER_FQN.equalsIgnoreCase(directoryImplementationName) || RAM_DIRECTORY_PROVIDER.equals(directoryImplementationName);
            }
            return false;
        });
        return new IndexingConfiguration(this.attributes.protect(), isVolatile, this.resolvedIndexedClasses);
    }

    public IndexingConfigurationBuilder read(IndexingConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public ElementDefinition getElementDefinition() {
        return IndexingConfiguration.ELEMENT_DEFINITION;
    }

    public String toString() {
        return "IndexingConfigurationBuilder [attributes=" + this.attributes + "]";
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

