/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializing;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.CachedThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.CustomStoreConfiguration;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.global.AllowListConfiguration;
import org.infinispan.configuration.global.GlobalAuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxConfiguration;
import org.infinispan.configuration.global.GlobalMetricsConfiguration;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TemporaryGlobalStatePathConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.serializing.AbstractStoreSerializer;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.ConfigurationSerializer;
import org.infinispan.configuration.serializing.SerializeUtils;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.factories.threads.NonBlockingThreadPoolExecutorFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.jgroups.EmbeddedJGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.FileJGroupsChannelConfigurator;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.mappers.ClusterRoleMapper;
import org.infinispan.security.mappers.CommonNameRoleMapper;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.util.logging.Log;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;

public class Serializer
extends AbstractStoreSerializer
implements ConfigurationSerializer<ConfigurationHolder> {
    private static final Map<String, Element> THREAD_POOL_FACTORIES = new ConcurrentHashMap<String, Element>();

    @Override
    public void serialize(XMLExtendedStreamWriter writer, ConfigurationHolder holder) throws XMLStreamException {
        GlobalConfiguration globalConfiguration = holder.getGlobalConfiguration();
        if (globalConfiguration != null) {
            this.writeJGroups(writer, globalConfiguration);
            this.writeThreads(writer, globalConfiguration);
        }
        this.writeCacheContainer(writer, holder);
    }

    private void writeJGroups(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        if (globalConfiguration.isClustered()) {
            writer.writeStartElement(Element.JGROUPS);
            writer.writeAttribute(Attribute.TRANSPORT, globalConfiguration.transport().transport().getClass().getName());
            TypedProperties properties = globalConfiguration.transport().properties();
            for (Object oProperty : properties.keySet()) {
                String property = oProperty.toString();
                if (!"channelConfigurator".equals(property)) continue;
                ProtocolStackConfigurator configurator = (ProtocolStackConfigurator)properties.get((Object)property);
                if (configurator.getClass() == FileJGroupsChannelConfigurator.class) {
                    FileJGroupsChannelConfigurator fileConfigurator = (FileJGroupsChannelConfigurator)configurator;
                    writer.writeStartElement(Element.STACK_FILE);
                    writer.writeAttribute(Attribute.NAME, fileConfigurator.getName());
                    writer.writeAttribute(Attribute.PATH, fileConfigurator.getPath());
                    writer.writeEndElement();
                    continue;
                }
                if (!(configurator instanceof EmbeddedJGroupsChannelConfigurator)) continue;
                EmbeddedJGroupsChannelConfigurator embeddedConfigurator = (EmbeddedJGroupsChannelConfigurator)configurator;
                writer.writeStartElement(Element.STACK);
                writer.writeAttribute(Attribute.NAME, embeddedConfigurator.getName());
                for (ProtocolConfiguration protocol : embeddedConfigurator.getProtocolStack()) {
                    writer.writeStartElement(protocol.getProtocolName());
                    for (Map.Entry attr : protocol.getProperties().entrySet()) {
                        writer.writeAttribute((String)attr.getKey(), (String)attr.getValue());
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeThreads(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        writer.writeStartElement(Element.THREADS);
        ConcurrentHashMap<String, DefaultThreadFactory> threadFactories = new ConcurrentHashMap<String, DefaultThreadFactory>();
        for (ThreadPoolConfiguration threadPoolConfiguration : Arrays.asList(globalConfiguration.expirationThreadPool(), globalConfiguration.listenerThreadPool(), globalConfiguration.nonBlockingThreadPool(), globalConfiguration.blockingThreadPool(), globalConfiguration.transport().remoteCommandThreadPool(), globalConfiguration.transport().transportThreadPool())) {
            Object threadFactory = threadPoolConfiguration.threadFactory();
            if (!(threadFactory instanceof DefaultThreadFactory)) continue;
            DefaultThreadFactory tf = (DefaultThreadFactory)threadFactory;
            threadFactories.putIfAbsent(tf.getName(), tf);
        }
        for (DefaultThreadFactory threadFactory : threadFactories.values()) {
            this.writeThreadFactory(writer, threadFactory);
        }
        this.writeThreadPool(writer, globalConfiguration.nonBlockingThreadPoolName(), globalConfiguration.nonBlockingThreadPool());
        this.writeThreadPool(writer, globalConfiguration.expirationThreadPoolName(), globalConfiguration.expirationThreadPool());
        this.writeThreadPool(writer, globalConfiguration.listenerThreadPoolName(), globalConfiguration.listenerThreadPool());
        this.writeThreadPool(writer, globalConfiguration.blockingThreadPoolName(), globalConfiguration.blockingThreadPool());
        this.writeThreadPool(writer, globalConfiguration.transport().remoteThreadPoolName(), globalConfiguration.transport().remoteCommandThreadPool());
        writer.writeEndElement();
    }

    private void writeThreadFactory(XMLExtendedStreamWriter writer, DefaultThreadFactory threadFactory) throws XMLStreamException {
        writer.writeStartElement(Element.THREAD_FACTORY);
        SerializeUtils.writeOptional(writer, Attribute.NAME, threadFactory.getName());
        SerializeUtils.writeOptional(writer, Attribute.GROUP_NAME, threadFactory.threadGroup().getName());
        SerializeUtils.writeOptional(writer, Attribute.THREAD_NAME_PATTERN, threadFactory.threadNamePattern());
        writer.writeAttribute(Attribute.PRIORITY, Integer.toString(threadFactory.initialPriority()));
        writer.writeEndElement();
    }

    private void writeThreadPool(XMLExtendedStreamWriter writer, String name, ThreadPoolConfiguration threadPoolConfiguration) throws XMLStreamException {
        Object threadPoolFactory = threadPoolConfiguration.threadPoolFactory();
        if (threadPoolFactory != null) {
            Element element = THREAD_POOL_FACTORIES.get(threadPoolFactory.getClass().getName());
            if (element == Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL && threadPoolFactory.createsNonBlockingThreads()) {
                element = Element.NON_BLOCKING_BOUNDED_QUEUE_THREAD_POOL;
            }
            writer.writeStartElement(element);
            writer.writeAttribute(Attribute.NAME, name);
            Object threadFactory = threadPoolConfiguration.threadFactory();
            if (threadFactory instanceof DefaultThreadFactory) {
                DefaultThreadFactory tf = (DefaultThreadFactory)threadFactory;
                writer.writeAttribute(Attribute.THREAD_FACTORY, tf.getName());
            }
            if (threadPoolFactory instanceof BlockingThreadPoolExecutorFactory) {
                BlockingThreadPoolExecutorFactory pool = (BlockingThreadPoolExecutorFactory)threadPoolFactory;
                writer.writeAttribute(Attribute.MAX_THREADS, Integer.toString(pool.maxThreads()));
                writer.writeAttribute(Attribute.CORE_THREADS, Integer.toString(pool.coreThreads()));
                writer.writeAttribute(Attribute.QUEUE_LENGTH, Integer.toString(pool.queueLength()));
                writer.writeAttribute(Attribute.KEEP_ALIVE_TIME, Long.toString(pool.keepAlive()));
            }
            writer.writeEndElement();
        }
    }

    private void writeCacheContainer(XMLExtendedStreamWriter writer, ConfigurationHolder holder) throws XMLStreamException {
        writer.writeStartElement(Element.CACHE_CONTAINER);
        GlobalConfiguration globalConfiguration = holder.getGlobalConfiguration();
        if (globalConfiguration != null) {
            writer.writeAttribute(Attribute.NAME, globalConfiguration.cacheManagerName());
            if (globalConfiguration.shutdown().hookBehavior() != ShutdownHookBehavior.DEFAULT) {
                writer.writeAttribute(Attribute.SHUTDOWN_HOOK, globalConfiguration.shutdown().hookBehavior().name());
            }
            writer.writeAttribute(Attribute.STATISTICS, String.valueOf(globalConfiguration.statistics()));
            if (globalConfiguration.nonBlockingThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute(Attribute.NON_BLOCKING_EXECUTOR, globalConfiguration.nonBlockingThreadPoolName());
            }
            if (globalConfiguration.expirationThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute(Attribute.EXPIRATION_EXECUTOR, globalConfiguration.expirationThreadPoolName());
            }
            if (globalConfiguration.listenerThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute(Attribute.LISTENER_EXECUTOR, globalConfiguration.listenerThreadPoolName());
            }
            if (globalConfiguration.blockingThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute(Attribute.BLOCKING_EXECUTOR, globalConfiguration.blockingThreadPoolName());
            }
            this.writeTransport(writer, globalConfiguration);
            this.writeSecurity(writer, globalConfiguration);
            this.writeSerialization(writer, globalConfiguration);
            this.writeMetrics(writer, globalConfiguration);
            this.writeJMX(writer, globalConfiguration);
            this.writeGlobalState(writer, globalConfiguration);
            this.writeExtraConfiguration(writer, globalConfiguration.modules());
        }
        for (Map.Entry<String, Configuration> configuration : holder.getConfigurations().entrySet()) {
            Configuration config = configuration.getValue();
            switch (config.clustering().cacheMode()) {
                case LOCAL: {
                    this.writeLocalCache(writer, configuration.getKey(), config);
                    break;
                }
                case DIST_ASYNC: 
                case DIST_SYNC: {
                    this.writeDistributedCache(writer, configuration.getKey(), config);
                    break;
                }
                case INVALIDATION_ASYNC: 
                case INVALIDATION_SYNC: {
                    this.writeInvalidationCache(writer, configuration.getKey(), config);
                    break;
                }
                case REPL_ASYNC: 
                case REPL_SYNC: {
                    this.writeReplicatedCache(writer, configuration.getKey(), config);
                    break;
                }
                case SCATTERED_SYNC: {
                    this.writeScatteredCache(writer, configuration.getKey(), config);
                    break;
                }
            }
        }
    }

    private void writeExtraConfiguration(XMLExtendedStreamWriter writer, Map<Class<?>, ?> modules) throws XMLStreamException {
        for (Map.Entry<Class<?>, ?> entry : modules.entrySet()) {
            SerializedWith serializedWith = entry.getKey().getAnnotation(SerializedWith.class);
            if (serializedWith == null) continue;
            try {
                ConfigurationSerializer serializer = (ConfigurationSerializer)Util.getInstanceStrict(serializedWith.value());
                serializer.serialize(writer, entry.getValue());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Log.CONFIG.unableToInstantiateSerializer(serializedWith.value());
            }
        }
    }

    private void writeGlobalState(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        GlobalStateConfiguration configuration = globalConfiguration.globalState();
        if (configuration.enabled()) {
            writer.writeStartElement(Element.GLOBAL_STATE);
            if (configuration.persistenceConfiguration().attributes().attribute(GlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement(Element.PERSISTENT_LOCATION);
                writer.writeAttribute(Attribute.PATH, configuration.persistentLocation());
                writer.writeEndElement();
            }
            if (configuration.sharedPersistenceConfiguration().attributes().attribute(GlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement(Element.SHARED_PERSISTENT_LOCATION);
                writer.writeAttribute(Attribute.PATH, configuration.sharedPersistentLocation());
                writer.writeEndElement();
            }
            if (configuration.temporaryLocationConfiguration().attributes().attribute(TemporaryGlobalStatePathConfiguration.PATH).isModified()) {
                writer.writeStartElement(Element.TEMPORARY_LOCATION);
                writer.writeAttribute(Attribute.PATH, configuration.temporaryLocation());
                writer.writeEndElement();
            }
            switch (configuration.configurationStorage()) {
                case IMMUTABLE: {
                    writer.writeEmptyElement(Element.IMMUTABLE_CONFIGURATION_STORAGE);
                    break;
                }
                case VOLATILE: {
                    writer.writeEmptyElement(Element.VOLATILE_CONFIGURATION_STORAGE);
                    break;
                }
                case OVERLAY: {
                    writer.writeEmptyElement(Element.OVERLAY_CONFIGURATION_STORAGE);
                    break;
                }
                case MANAGED: {
                    writer.writeEmptyElement(Element.MANAGED_CONFIGURATION_STORAGE);
                    break;
                }
                case CUSTOM: {
                    writer.writeStartElement(Element.CUSTOM_CONFIGURATION_STORAGE);
                    writer.writeAttribute(Attribute.CLASS, configuration.configurationStorageClass().get().getClass().getName());
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }

    private void writeSecurity(XMLExtendedStreamWriter writer, GlobalConfiguration configuration) throws XMLStreamException {
        GlobalAuthorizationConfiguration authorization = configuration.security().authorization();
        AttributeSet attributes = authorization.attributes();
        if (attributes.isModified() && authorization.enabled()) {
            writer.writeStartElement(Element.SECURITY);
            writer.writeStartElement(Element.AUTHORIZATION);
            attributes.write((XMLStreamWriter)writer, GlobalAuthorizationConfiguration.AUDIT_LOGGER, (Enum)Attribute.AUDIT_LOGGER);
            PrincipalRoleMapper mapper = authorization.principalRoleMapper();
            if (mapper != null) {
                if (mapper instanceof IdentityRoleMapper) {
                    writer.writeEmptyElement(Element.IDENTITY_ROLE_MAPPER);
                } else if (mapper instanceof CommonNameRoleMapper) {
                    writer.writeEmptyElement(Element.COMMON_NAME_ROLE_MAPPER);
                } else if (mapper instanceof ClusterRoleMapper) {
                    writer.writeEmptyElement(Element.CLUSTER_ROLE_MAPPER);
                } else {
                    writer.writeStartElement(Element.CUSTOM_ROLE_MAPPER);
                    writer.writeAttribute(Attribute.CLASS, mapper.getClass().getName());
                    writer.writeEndElement();
                }
            }
            for (Role role : authorization.roles().values()) {
                writer.writeStartElement(Element.ROLE);
                writer.writeAttribute(Attribute.NAME, role.getName());
                this.writeCollectionAsAttribute(writer, Attribute.PERMISSIONS, role.getPermissions());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeReplicatedCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.REPLICATED_CACHE);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        writer.writeEndElement();
    }

    private void writeDistributedCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.DISTRIBUTED_CACHE);
        configuration.clustering().hash().attributes().write((XMLStreamWriter)writer);
        configuration.clustering().l1().attributes().write((XMLStreamWriter)writer);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        GroupsConfiguration groups = configuration.clustering().hash().groups();
        if (groups.attributes().isModified()) {
            writer.writeStartElement(Element.GROUPS);
            groups.attributes().write((XMLStreamWriter)writer, GroupsConfiguration.ENABLED);
            for (Grouper<?> grouper : groups.groupers()) {
                writer.writeStartElement(Element.GROUPER);
                writer.writeAttribute(Attribute.CLASS, grouper.getClass().getName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        this.writeExtraConfiguration(writer, configuration.modules());
        writer.writeEndElement();
    }

    private void writeInvalidationCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.INVALIDATION_CACHE);
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        writer.writeEndElement();
    }

    private void writeScatteredCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.SCATTERED_CACHE);
        writer.writeAttribute(Attribute.INVALIDATION_BATCH_SIZE, Integer.toString(configuration.clustering().invalidationBatchSize()));
        writer.writeAttribute(Attribute.BIAS_ACQUISITION, configuration.clustering().biasAcquisition().toString());
        writer.writeAttribute(Attribute.BIAS_LIFESPAN, Long.toString(configuration.clustering().biasLifespan()));
        this.writeCommonClusteredCacheAttributes(writer, configuration);
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        writer.writeEndElement();
    }

    private void writeLocalCache(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.LOCAL_CACHE);
        if (configuration.simpleCache()) {
            configuration.attributes().write((XMLStreamWriter)writer, Configuration.SIMPLE_CACHE, (Enum)Attribute.SIMPLE_CACHE);
        }
        this.writeCommonCacheAttributesElements(writer, name, configuration);
        this.writeExtraConfiguration(writer, configuration.modules());
        writer.writeEndElement();
    }

    private void writeTransport(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        TransportConfiguration transport = globalConfiguration.transport();
        AttributeSet attributes = transport.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.TRANSPORT);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.CLUSTER_NAME, (Enum)Attribute.CLUSTER);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.MACHINE_ID, (Enum)Attribute.MACHINE_ID);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.RACK_ID, (Enum)Attribute.RACK_ID);
            if (transport.siteId() != null) {
                attributes.write((XMLStreamWriter)writer, TransportConfiguration.SITE_ID, (Enum)Attribute.SITE);
            }
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.NODE_NAME, (Enum)Attribute.NODE_NAME);
            TypedProperties properties = globalConfiguration.transport().properties();
            if (properties.containsKey((Object)"stack")) {
                writer.writeAttribute(Attribute.STACK, properties.getProperty("stack"));
            }
            if (transport.remoteCommandThreadPool().threadPoolFactory() != null) {
                writer.writeAttribute(Attribute.REMOTE_COMMAND_EXECUTOR, transport.remoteThreadPoolName());
            }
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.DISTRIBUTED_SYNC_TIMEOUT, (Enum)Attribute.LOCK_TIMEOUT);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.INITIAL_CLUSTER_SIZE, (Enum)Attribute.INITIAL_CLUSTER_SIZE);
            attributes.write((XMLStreamWriter)writer, TransportConfiguration.INITIAL_CLUSTER_TIMEOUT, (Enum)Attribute.INITIAL_CLUSTER_TIMEOUT);
            writer.writeEndElement();
        }
    }

    private void writeSerialization(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        SerializationConfiguration serialization = globalConfiguration.serialization();
        AttributeSet attributes = serialization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.SERIALIZATION);
            attributes.write((XMLStreamWriter)writer, SerializationConfiguration.MARSHALLER, (Enum)Attribute.MARSHALLER_CLASS);
            SerializationConfiguration config = globalConfiguration.serialization();
            this.writeAdvancedSerializers(writer, config);
            this.writeSerializationContextInitializers(writer, config);
            this.writeClassAllowList(writer, config.allowList());
            writer.writeEndElement();
        }
    }

    private void writeAdvancedSerializers(XMLExtendedStreamWriter writer, SerializationConfiguration config) throws XMLStreamException {
        Map<Integer, AdvancedExternalizer<?>> externalizers = config.advancedExternalizers();
        boolean userExternalizerExists = externalizers.entrySet().stream().anyMatch(entry -> (Integer)entry.getKey() >= 2500);
        if (userExternalizerExists) {
            for (Map.Entry<Integer, AdvancedExternalizer<?>> externalizer : externalizers.entrySet()) {
                writer.writeStartElement(Element.ADVANCED_EXTERNALIZER);
                writer.writeAttribute(Attribute.ID, Integer.toString(externalizer.getKey()));
                writer.writeAttribute(Attribute.CLASS, externalizer.getValue().getClass().getName());
                writer.writeEndElement();
            }
        }
    }

    private void writeSerializationContextInitializers(XMLExtendedStreamWriter writer, SerializationConfiguration config) throws XMLStreamException {
        List<SerializationContextInitializer> scis = config.contextInitializers();
        if (scis != null) {
            for (SerializationContextInitializer sci : config.contextInitializers()) {
                writer.writeStartElement(Element.SERIALIZATION_CONTEXT_INITIALIZER);
                writer.writeAttribute(Attribute.CLASS, sci.getClass().getName());
                writer.writeEndElement();
            }
        }
    }

    private void writeClassAllowList(XMLExtendedStreamWriter writer, AllowListConfiguration config) throws XMLStreamException {
        writer.writeStartElement(Element.ALLOW_LIST);
        this.writeClassAllowListElements(writer, Element.CLASS, config.getClasses());
        this.writeClassAllowListElements(writer, Element.REGEX, config.getRegexps());
        writer.writeEndElement();
    }

    private void writeClassAllowListElements(XMLExtendedStreamWriter writer, Element element, Collection<String> values) throws XMLStreamException {
        for (String value : values) {
            writer.writeStartElement(element);
            writer.writeCharacters(value);
            writer.writeEndElement();
        }
    }

    private void writeMetrics(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        GlobalMetricsConfiguration metrics = globalConfiguration.metrics();
        AttributeSet attributes = metrics.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.METRICS);
            attributes.write((XMLStreamWriter)writer, GlobalMetricsConfiguration.GAUGES, (Enum)Attribute.GAUGES);
            attributes.write((XMLStreamWriter)writer, GlobalMetricsConfiguration.HISTOGRAMS, (Enum)Attribute.HISTOGRAMS);
            attributes.write((XMLStreamWriter)writer, GlobalMetricsConfiguration.PREFIX, (Enum)Attribute.PREFIX);
            attributes.write((XMLStreamWriter)writer, GlobalMetricsConfiguration.NAMES_AS_TAGS, (Enum)Attribute.NAMES_AS_TAGS);
            writer.writeEndElement();
        }
    }

    private void writeJMX(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration) throws XMLStreamException {
        GlobalJmxConfiguration jmx = globalConfiguration.jmx();
        AttributeSet attributes = jmx.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.JMX);
            attributes.write((XMLStreamWriter)writer, GlobalJmxConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            attributes.write((XMLStreamWriter)writer, GlobalJmxConfiguration.DOMAIN, (Enum)Attribute.DOMAIN);
            attributes.write((XMLStreamWriter)writer, GlobalJmxConfiguration.MBEAN_SERVER_LOOKUP, (Enum)Attribute.MBEAN_SERVER_LOOKUP);
            SerializeUtils.writeTypedProperties(writer, (TypedProperties)attributes.attribute(GlobalJmxConfiguration.PROPERTIES).get());
            writer.writeEndElement();
        }
    }

    private void writeTransaction(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        TransactionConfiguration transaction = configuration.transaction();
        AttributeSet attributes = transaction.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.TRANSACTION);
            Parser.TransactionMode mode = Parser.TransactionMode.fromConfiguration(transaction, configuration.invocationBatching().enabled());
            writer.writeAttribute(Attribute.MODE, mode.toString());
            attributes.write((XMLStreamWriter)writer);
            if (mode != Parser.TransactionMode.NONE) {
                attributes.write((XMLStreamWriter)writer, TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP);
            }
            if (transaction.recovery().enabled()) {
                transaction.recovery().attributes().write((XMLStreamWriter)writer, RecoveryConfiguration.RECOVERY_INFO_CACHE_NAME, (Enum)Attribute.RECOVERY_INFO_CACHE_NAME);
            }
            writer.writeEndElement();
        }
    }

    private void writeSecurity(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        AuthorizationConfiguration authorization = configuration.security().authorization();
        AttributeSet attributes = authorization.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.SECURITY);
            writer.writeStartElement(Element.AUTHORIZATION);
            attributes.write((XMLStreamWriter)writer, AuthorizationConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            this.writeCollectionAsAttribute(writer, Attribute.ROLES, authorization.roles());
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void writeCommonClusteredCacheAttributes(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        ClusteringConfiguration clustering = configuration.clustering();
        writer.writeAttribute(Attribute.MODE, clustering.cacheMode().isSynchronous() ? "SYNC" : "ASYNC");
        clustering.attributes().write((XMLStreamWriter)writer, ClusteringConfiguration.REMOTE_TIMEOUT, (Enum)Attribute.REMOTE_TIMEOUT);
    }

    private void writeCommonCacheAttributesElements(XMLExtendedStreamWriter writer, String name, Configuration configuration) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME, name);
        configuration.statistics().attributes().write((XMLStreamWriter)writer, StatisticsConfiguration.ENABLED, (Enum)Attribute.STATISTICS);
        configuration.unsafe().attributes().write((XMLStreamWriter)writer);
        this.writeBackup(writer, configuration);
        this.writeEncoding(writer, configuration);
        configuration.sites().backupFor().attributes().write((XMLStreamWriter)writer, Element.BACKUP_FOR.getLocalName());
        configuration.locking().attributes().write((XMLStreamWriter)writer, Element.LOCKING.getLocalName());
        this.writeTransaction(writer, configuration);
        configuration.expiration().attributes().write((XMLStreamWriter)writer, Element.EXPIRATION.getLocalName());
        this.writeMemory(writer, configuration);
        this.writePersistence(writer, configuration);
        this.writeIndexing(writer, configuration);
        this.writeCustomInterceptors(writer, configuration);
        this.writeSecurity(writer, configuration);
        if (configuration.clustering().cacheMode().needsStateTransfer()) {
            configuration.clustering().stateTransfer().attributes().write((XMLStreamWriter)writer, Element.STATE_TRANSFER.getLocalName());
        }
        this.writePartitionHandling(writer, configuration);
    }

    private void writeEncoding(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        MediaType keyDataType = configuration.encoding().keyDataType().mediaType();
        MediaType valueDataType = configuration.encoding().valueDataType().mediaType();
        if (keyDataType != null || valueDataType != null) {
            writer.writeStartElement(Element.ENCODING);
            if (keyDataType != null) {
                writer.writeStartElement(Element.KEY_DATA_TYPE);
                writer.writeAttribute(Attribute.MEDIA_TYPE, keyDataType.toString());
                writer.writeEndElement();
            }
            if (valueDataType != null) {
                writer.writeStartElement(Element.VALUE_DATA_TYPE);
                writer.writeAttribute(Attribute.MEDIA_TYPE, valueDataType.toString());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writePartitionHandling(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        PartitionHandlingConfiguration partitionHandling = configuration.clustering().partitionHandling();
        AttributeSet attributes = partitionHandling.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.PARTITION_HANDLING);
            attributes.write((XMLStreamWriter)writer, PartitionHandlingConfiguration.WHEN_SPLIT, (Enum)Attribute.WHEN_SPLIT);
            EntryMergePolicy policyImpl = partitionHandling.mergePolicy();
            MergePolicy policy = MergePolicy.fromConfiguration(policyImpl);
            String output = policy == MergePolicy.CUSTOM ? policyImpl.getClass().getName() : policy.toString();
            writer.writeAttribute(Attribute.MERGE_POLICY, output);
            writer.writeEndElement();
        }
    }

    private void writeCustomInterceptors(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        CustomInterceptorsConfiguration customInterceptors = configuration.customInterceptors();
        if (customInterceptors.interceptors().size() > 0) {
            writer.writeStartElement(Element.CUSTOM_INTERCEPTORS);
            for (InterceptorConfiguration interceptor : customInterceptors.interceptors()) {
                AttributeSet attributes = interceptor.attributes();
                if (attributes.attribute(InterceptorConfiguration.INTERCEPTOR_CLASS).isNull()) continue;
                writer.writeStartElement(Element.INTERCEPTOR);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.INTERCEPTOR_CLASS, (Enum)Attribute.CLASS);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.AFTER, (Enum)Attribute.AFTER);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.BEFORE, (Enum)Attribute.BEFORE);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.INDEX, (Enum)Attribute.INDEX);
                attributes.write((XMLStreamWriter)writer, InterceptorConfiguration.POSITION, (Enum)Attribute.POSITION);
                SerializeUtils.writeTypedProperties(writer, interceptor.properties());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeMemory(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        MemoryConfiguration memory = configuration.memory();
        AttributeSet attributes = memory.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.MEMORY);
            attributes.write((XMLStreamWriter)writer, MemoryConfiguration.STORAGE, (Enum)Attribute.STORAGE);
            if ((Long)attributes.attribute(MemoryConfiguration.MAX_COUNT).get() > 0L) {
                attributes.write((XMLStreamWriter)writer, MemoryConfiguration.MAX_COUNT, (Enum)Attribute.MAX_COUNT);
            } else if (attributes.attribute(MemoryConfiguration.MAX_SIZE).get() != null) {
                attributes.write((XMLStreamWriter)writer, MemoryConfiguration.MAX_SIZE, (Enum)Attribute.MAX_SIZE);
            }
            attributes.write((XMLStreamWriter)writer, MemoryConfiguration.WHEN_FULL, (Enum)Attribute.WHEN_FULL);
            writer.writeEndElement();
        }
    }

    private void writeIndexing(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        IndexingConfiguration indexing = configuration.indexing();
        AttributeSet attributes = indexing.attributes();
        if (attributes.isModified()) {
            writer.writeStartElement(Element.INDEXING);
            attributes.write((XMLStreamWriter)writer, IndexingConfiguration.AUTO_CONFIG, (Enum)Attribute.AUTO_CONFIG);
            attributes.write((XMLStreamWriter)writer, IndexingConfiguration.ENABLED, (Enum)Attribute.ENABLED);
            if (!indexing.indexedEntityTypes().isEmpty()) {
                writer.writeStartElement(Element.INDEXED_ENTITIES);
                for (String string : indexing.indexedEntityTypes()) {
                    writer.writeStartElement(Element.INDEXED_ENTITY);
                    writer.writeCharacters(string);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (!indexing.keyTransformers().isEmpty()) {
                writer.writeStartElement(Element.KEY_TRANSFORMERS);
                for (Map.Entry entry : indexing.keyTransformers().entrySet()) {
                    writer.writeStartElement(Element.KEY_TRANSFORMER);
                    writer.writeAttribute(Attribute.KEY, ((Class)entry.getKey()).getName());
                    writer.writeAttribute(Attribute.TRANSFORMER, ((Class)entry.getValue()).getName());
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            SerializeUtils.writeTypedProperties(writer, indexing.properties());
            writer.writeEndElement();
        }
    }

    private void writePersistence(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        PersistenceConfiguration persistence = configuration.persistence();
        AttributeSet attributes = persistence.attributes();
        if (attributes.isModified() || persistence.stores().size() > 0) {
            writer.writeStartElement(Element.PERSISTENCE);
            attributes.write((XMLStreamWriter)writer, PersistenceConfiguration.PASSIVATION, (Enum)Attribute.PASSIVATION);
            attributes.write((XMLStreamWriter)writer, PersistenceConfiguration.AVAILABILITY_INTERVAL, (Enum)Attribute.AVAILABILITY_INTERVAL);
            attributes.write((XMLStreamWriter)writer, PersistenceConfiguration.CONNECTION_ATTEMPTS, (Enum)Attribute.CONNECTION_ATTEMPTS);
            attributes.write((XMLStreamWriter)writer, PersistenceConfiguration.CONNECTION_INTERVAL, (Enum)Attribute.CONNECTION_INTERVAL);
            for (StoreConfiguration store : persistence.stores()) {
                this.writeStore(writer, store);
            }
            writer.writeEndElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeStore(XMLExtendedStreamWriter writer, StoreConfiguration configuration) throws XMLStreamException {
        if (configuration instanceof SingleFileStoreConfiguration) {
            this.writeFileStore(writer, (SingleFileStoreConfiguration)configuration);
            return;
        }
        if (configuration instanceof ClusterLoaderConfiguration) {
            this.writeClusterLoader(writer, (ClusterLoaderConfiguration)configuration);
            return;
        }
        if (configuration instanceof CustomStoreConfiguration) {
            this.writeCustomStore(writer, (CustomStoreConfiguration)configuration);
            return;
        }
        SerializedWith serializedWith = configuration.getClass().getAnnotation(SerializedWith.class);
        if (serializedWith == null) {
            ConfigurationFor configurationFor = configuration.getClass().getAnnotation(ConfigurationFor.class);
            if (!(configuration instanceof AbstractStoreConfiguration) || configurationFor == null) throw new UnsupportedOperationException("Cannot serialize store configuration " + configuration.getClass().getName());
            writer.writeComment("A serializer for the store configuration class " + configuration.getClass().getName() + " was not found. Using custom store mode");
            AbstractStoreConfiguration asc = (AbstractStoreConfiguration)configuration;
            this.writeGenericStore(writer, configurationFor.value().getName(), asc);
            return;
        }
        try {
            ConfigurationSerializer serializer = (ConfigurationSerializer)Util.getInstanceStrict(serializedWith.value());
            serializer.serialize(writer, configuration);
            return;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Log.CONFIG.unableToInstantiateSerializer(serializedWith.value());
        }
    }

    private void writeBackup(XMLExtendedStreamWriter writer, Configuration configuration) throws XMLStreamException {
        SitesConfiguration sites = configuration.sites();
        if (sites.allBackups().size() > 0) {
            writer.writeStartElement(Element.BACKUPS);
            for (BackupConfiguration backup : sites.allBackups()) {
                AttributeSet takeOffline;
                writer.writeStartElement(Element.BACKUP);
                backup.attributes().write((XMLStreamWriter)writer);
                AttributeSet stateTransfer = backup.stateTransfer().attributes();
                if (stateTransfer.isModified()) {
                    writer.writeStartElement(Element.STATE_TRANSFER);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.CHUNK_SIZE, (Enum)Attribute.CHUNK_SIZE);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.MAX_RETRIES, (Enum)Attribute.MAX_RETRIES);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.TIMEOUT, (Enum)Attribute.TIMEOUT);
                    stateTransfer.write((XMLStreamWriter)writer, XSiteStateTransferConfiguration.WAIT_TIME, (Enum)Attribute.WAIT_TIME);
                    writer.writeEndElement();
                }
                if ((takeOffline = backup.takeOffline().attributes()).isModified()) {
                    writer.writeStartElement(Element.TAKE_OFFLINE);
                    takeOffline.write((XMLStreamWriter)writer, TakeOfflineConfiguration.AFTER_FAILURES, (Enum)Attribute.TAKE_BACKUP_OFFLINE_AFTER_FAILURES);
                    takeOffline.write((XMLStreamWriter)writer, TakeOfflineConfiguration.MIN_TIME_TO_WAIT, (Enum)Attribute.TAKE_BACKUP_OFFLINE_MIN_WAIT);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeCollectionAsAttribute(XMLExtendedStreamWriter writer, Attribute attribute, Collection<?> collection) throws XMLStreamException {
        if (!collection.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean separator = false;
            for (Object item : collection) {
                if (separator) {
                    result.append(" ");
                }
                result.append(item);
                separator = true;
            }
            writer.writeAttribute(attribute, result.toString());
        }
    }

    private void writeFileStore(XMLExtendedStreamWriter writer, SingleFileStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.FILE_STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeClusterLoader(XMLExtendedStreamWriter writer, ClusterLoaderConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.CLUSTER_LOADER);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeCustomStore(XMLExtendedStreamWriter writer, CustomStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.STORE);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    private void writeGenericStore(XMLExtendedStreamWriter writer, String storeClassName, AbstractStoreConfiguration configuration) throws XMLStreamException {
        writer.writeStartElement(Element.STORE);
        writer.writeAttribute(Attribute.CLASS.getLocalName(), storeClassName);
        configuration.attributes().write((XMLStreamWriter)writer);
        this.writeCommonStoreSubAttributes(writer, configuration);
        this.writeCommonStoreElements(writer, configuration);
        writer.writeEndElement();
    }

    static {
        THREAD_POOL_FACTORIES.put(CachedThreadPoolExecutorFactory.class.getName(), Element.CACHED_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(NonBlockingThreadPoolExecutorFactory.class.getName(), Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(EnhancedQueueExecutorFactory.class.getName(), Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL);
        THREAD_POOL_FACTORIES.put(ScheduledThreadPoolExecutorFactory.class.getName(), Element.SCHEDULED_THREAD_POOL);
    }
}

