/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.CacheConfigurationMBean;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.conflict.impl.InternalConflictManager;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.AbstractComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.persistence.manager.OrderedUpdatesManager;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.PublisherHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.scattered.BiasManager;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;
import org.infinispan.xsite.status.TakeOfflineManager;

@Scope(value=Scopes.NAMED_CACHE)
@SurvivesRestarts
public class ComponentRegistry
extends AbstractComponentRegistry {
    private static final Log log = LogFactory.getLog(ComponentRegistry.class);
    private final String cacheName;
    private final ByteString cacheByteString;
    private final Configuration configuration;
    private final GlobalComponentRegistry globalComponents;
    @Inject
    CacheManagerNotifier cacheManagerNotifier;
    @Inject
    GlobalComponentRegistry.ModuleInitializer moduleInitializer;
    private ComponentRef<AdvancedCache> cache;
    private ComponentRef<AsyncInterceptorChain> asyncInterceptorChain;
    private ComponentRef<BackupReceiver> backupReceiver;
    private ComponentRef<BackupSender> backupSender;
    private ComponentRef<BiasManager> biasManager;
    private ComponentRef<CacheNotifier> cacheNotifier;
    private ComponentRef<ClusterCacheNotifier> clusterCacheNotifier;
    private ComponentRef<CommandAckCollector> commandAckCollector;
    private ComponentRef<CommandsFactory> commandsFactory;
    private ComponentRef<InternalConflictManager> conflictManager;
    private ComponentRef<DistributionManager> distributionManager;
    private ComponentRef<InternalDataContainer> internalDataContainer;
    private ComponentRef<InternalEntryFactory> internalEntryFactory;
    private ComponentRef<InvocationContextFactory> invocationContextFactory;
    private ComponentRef<IracManager> iracManager;
    private ComponentRef<IracVersionGenerator> iracVersionGenerator;
    private ComponentRef<LocalPublisherManager> localPublisherManager;
    private ComponentRef<LockManager> lockManager;
    private ComponentRef<OrderedUpdatesManager> orderedUpdatesManager;
    private ComponentRef<PerCacheInboundInvocationHandler> inboundInvocationHandler;
    private ComponentRef<PersistenceMarshaller> persistenceMarshaller;
    private ComponentRef<PublisherHandler> publisherHandler;
    private ComponentRef<RecoveryManager> recoveryManager;
    private ComponentRef<ResponseGenerator> responseGenerator;
    private ComponentRef<RpcManager> rpcManager;
    private ComponentRef<StateTransferLock> stateTransferLock;
    private ComponentRef<StateTransferManager> stateTransferManager;
    private ComponentRef<StreamingMarshaller> internalMarshaller;
    private ComponentRef<TakeOfflineManager> takeOfflineManager;
    private ComponentRef<TransactionTable> transactionTable;
    private ComponentRef<VersionGenerator> versionGenerator;
    private ComponentRef<XSiteStateTransferManager> xSiteStateTransferManager;

    public ComponentRegistry(String cacheName, Configuration configuration, AdvancedCache<?, ?> cache, GlobalComponentRegistry globalComponents, ClassLoader defaultClassLoader) {
        super(globalComponents.moduleRepository, false, globalComponents.getComponent(BasicComponentRegistry.class));
        if (cacheName == null) {
            throw new CacheConfigurationException("Cache name cannot be null!");
        }
        try {
            this.cacheName = cacheName;
            this.cacheByteString = ByteString.fromString(cacheName);
            this.configuration = configuration;
            this.globalComponents = globalComponents;
            this.basicComponentRegistry.registerComponent("cacheName", cacheName, false);
            this.basicComponentRegistry.registerComponent(ComponentRegistry.class, this, false);
            this.basicComponentRegistry.registerComponent(Configuration.class, configuration, false);
            this.bootstrapComponents();
        }
        catch (Exception e) {
            throw new CacheException("Unable to construct a ComponentRegistry!", (Throwable)e);
        }
    }

    @Override
    protected ClassLoader getClassLoader() {
        return this.globalComponents.getClassLoader();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public final <T> T getComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        Class componentType = Util.loadClass((String)componentTypeName, (ClassLoader)this.getClassLoader());
        ComponentRef component = this.basicComponentRegistry.getComponent(name, componentType);
        return component != null ? (T)component.running() : null;
    }

    public final <T> T getLocalComponent(String componentTypeName, String name, boolean nameIsFQCN) {
        Class componentType = Util.loadClass((String)componentTypeName, (ClassLoader)this.getClassLoader());
        ComponentRef componentRef = this.basicComponentRegistry.getComponent(name, componentType);
        if (componentRef == null || componentRef.wired() == null) {
            return null;
        }
        Class<?> componentClass = componentRef.wired().getClass();
        ComponentAccessor<Object> metadata = this.moduleRepository.getComponentAccessor(componentClass.getName());
        if (metadata != null && metadata.isGlobalScope()) {
            return null;
        }
        return componentRef.running();
    }

    public final <T> T getLocalComponent(Class<T> componentType) {
        String componentTypeName = componentType.getName();
        return this.getLocalComponent(componentTypeName, componentTypeName, true);
    }

    public final GlobalComponentRegistry getGlobalComponentRegistry() {
        return this.globalComponents;
    }

    @Override
    protected final <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        ComponentRef component = this.basicComponentRegistry.getComponent(name, componentClass);
        return component != null ? (T)component.running() : null;
    }

    @Override
    public void start() {
        if (this.state.needToDestroyFailedCache()) {
            this.stop();
        }
        if (this.state.needToInitializeBeforeStart()) {
            this.state = ComponentStatus.INSTANTIATED;
            this.rewire();
        }
        super.start();
    }

    @Override
    protected void preStart() {
        this.cacheComponents();
        this.globalComponents.registerNamedComponentRegistry(this, this.cacheName);
        this.notifyCacheStarting(this.configuration);
    }

    @Override
    protected void postStart() {
        CompletionStages.join(this.cacheManagerNotifier.notifyCacheStarted(this.cacheName));
    }

    private void notifyCacheStarting(Configuration configuration) {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStarting()", l);
            }
            l.cacheStarting(this, configuration, this.cacheName);
        }
    }

    @Override
    protected void preStop() {
        this.globalComponents.unregisterNamedComponentRegistry(this.cacheName);
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStopping()", l);
            }
            try {
                l.cacheStopping(this, this.cacheName);
            }
            catch (Throwable t) {
                log.moduleStopError(l.getClass().getName() + ":" + this.cacheName, t);
            }
        }
    }

    @Override
    protected void postStop() {
        for (ModuleLifecycle l : this.globalComponents.moduleLifecycles) {
            if (log.isTraceEnabled()) {
                log.tracef("Invoking %s.cacheStopped()", l);
            }
            try {
                l.cacheStopped(this, this.cacheName);
            }
            catch (Throwable t) {
                log.moduleStopError(l.getClass().getName() + ":" + this.cacheName, t);
            }
        }
        CompletionStages.join(this.cacheManagerNotifier.notifyCacheStopped(this.cacheName));
    }

    @Override
    public void rewire() {
        super.rewire();
        this.cacheComponents();
    }

    @Override
    public TimeService getTimeService() {
        return this.globalComponents.getTimeService();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    @Deprecated
    public StreamingMarshaller getCacheMarshaller() {
        return this.internalMarshaller.wired();
    }

    public StreamingMarshaller getInternalMarshaller() {
        return this.internalMarshaller.wired();
    }

    public PersistenceMarshaller getPersistenceMarshaller() {
        return this.persistenceMarshaller.wired();
    }

    public StateTransferManager getStateTransferManager() {
        return this.stateTransferManager.wired();
    }

    public DistributionManager getDistributionManager() {
        return this.distributionManager == null ? null : this.distributionManager.wired();
    }

    public ResponseGenerator getResponseGenerator() {
        return this.responseGenerator.wired();
    }

    public CommandsFactory getCommandsFactory() {
        return this.commandsFactory.wired();
    }

    public StateTransferLock getStateTransferLock() {
        return this.stateTransferLock.wired();
    }

    public VersionGenerator getVersionGenerator() {
        return this.versionGenerator == null ? null : this.versionGenerator.wired();
    }

    public PerCacheInboundInvocationHandler getPerCacheInboundInvocationHandler() {
        return this.inboundInvocationHandler.wired();
    }

    protected void bootstrapComponents() {
    }

    public void cacheComponents() {
        this.asyncInterceptorChain = this.basicComponentRegistry.getComponent(AsyncInterceptorChain.class);
        this.biasManager = this.basicComponentRegistry.getComponent(BiasManager.class);
        this.backupReceiver = this.basicComponentRegistry.lazyGetComponent(BackupReceiver.class);
        this.backupSender = this.basicComponentRegistry.getComponent(BackupSender.class);
        this.takeOfflineManager = this.basicComponentRegistry.getComponent(TakeOfflineManager.class);
        this.cache = this.basicComponentRegistry.getComponent(AdvancedCache.class);
        this.cacheNotifier = this.basicComponentRegistry.getComponent(CacheNotifier.class);
        this.conflictManager = this.basicComponentRegistry.getComponent(InternalConflictManager.class);
        this.commandsFactory = this.basicComponentRegistry.getComponent(CommandsFactory.class);
        this.clusterCacheNotifier = this.basicComponentRegistry.getComponent(ClusterCacheNotifier.class);
        this.commandAckCollector = this.basicComponentRegistry.getComponent(CommandAckCollector.class);
        this.distributionManager = this.basicComponentRegistry.getComponent(DistributionManager.class);
        this.inboundInvocationHandler = this.basicComponentRegistry.getComponent(PerCacheInboundInvocationHandler.class);
        this.internalDataContainer = this.basicComponentRegistry.getComponent(InternalDataContainer.class);
        this.internalEntryFactory = this.basicComponentRegistry.getComponent(InternalEntryFactory.class);
        this.internalMarshaller = this.basicComponentRegistry.getComponent("org.infinispan.marshaller.internal", StreamingMarshaller.class);
        this.invocationContextFactory = this.basicComponentRegistry.getComponent(InvocationContextFactory.class);
        this.iracManager = this.basicComponentRegistry.getComponent(IracManager.class);
        this.iracVersionGenerator = this.basicComponentRegistry.getComponent(IracVersionGenerator.class);
        this.localPublisherManager = this.basicComponentRegistry.getComponent(LocalPublisherManager.class);
        this.lockManager = this.basicComponentRegistry.getComponent(LockManager.class);
        this.orderedUpdatesManager = this.basicComponentRegistry.getComponent(OrderedUpdatesManager.class);
        this.persistenceMarshaller = this.basicComponentRegistry.getComponent("org.infinispan.marshaller.persistence", PersistenceMarshaller.class);
        this.publisherHandler = this.basicComponentRegistry.getComponent(PublisherHandler.class);
        this.recoveryManager = this.basicComponentRegistry.getComponent(RecoveryManager.class);
        this.responseGenerator = this.basicComponentRegistry.getComponent(ResponseGenerator.class);
        this.rpcManager = this.basicComponentRegistry.getComponent(RpcManager.class);
        this.stateTransferLock = this.basicComponentRegistry.getComponent(StateTransferLock.class);
        this.stateTransferManager = this.basicComponentRegistry.getComponent(StateTransferManager.class);
        this.transactionTable = this.basicComponentRegistry.getComponent(TransactionTable.class);
        this.versionGenerator = this.basicComponentRegistry.getComponent(VersionGenerator.class);
        this.xSiteStateTransferManager = this.basicComponentRegistry.getComponent(XSiteStateTransferManager.class);
        this.basicComponentRegistry.getComponent(ClusterCacheStats.class);
        this.basicComponentRegistry.getComponent(CacheConfigurationMBean.class);
        this.basicComponentRegistry.getComponent(InternalConflictManager.class);
        this.basicComponentRegistry.getComponent(ClusterPublisherManager.class);
        this.basicComponentRegistry.getComponent(PreloadManager.class);
    }

    public final TransactionTable getTransactionTable() {
        return this.transactionTable.wired();
    }

    public final ComponentRef<TransactionTable> getTransactionTableRef() {
        return this.transactionTable;
    }

    public final synchronized void registerVersionGenerator(NumericVersionGenerator newVersionGenerator) {
        this.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
        this.versionGenerator = this.basicComponentRegistry.getComponent(VersionGenerator.class);
    }

    public ComponentRef<AdvancedCache> getCache() {
        return this.cache;
    }

    public ComponentRef<AsyncInterceptorChain> getInterceptorChain() {
        return this.asyncInterceptorChain;
    }

    public ComponentRef<BackupSender> getBackupSender() {
        return this.backupSender;
    }

    public ComponentRef<TakeOfflineManager> getTakeOfflineManager() {
        return this.takeOfflineManager;
    }

    public ComponentRef<IracManager> getIracManager() {
        return this.iracManager;
    }

    public ComponentRef<IracVersionGenerator> getIracVersionGenerator() {
        return this.iracVersionGenerator;
    }

    public ComponentRef<BiasManager> getBiasManager() {
        return this.biasManager;
    }

    public ByteString getCacheByteString() {
        return this.cacheByteString;
    }

    public ComponentRef<CacheNotifier> getCacheNotifier() {
        return this.cacheNotifier;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ComponentRef<InternalConflictManager> getConflictManager() {
        return this.conflictManager;
    }

    public ComponentRef<ClusterCacheNotifier> getClusterCacheNotifier() {
        return this.clusterCacheNotifier;
    }

    public ComponentRef<CommandAckCollector> getCommandAckCollector() {
        return this.commandAckCollector;
    }

    public ComponentRef<InternalDataContainer> getInternalDataContainer() {
        return this.internalDataContainer;
    }

    public ComponentRef<InternalEntryFactory> getInternalEntryFactory() {
        return this.internalEntryFactory;
    }

    public ComponentRef<InvocationContextFactory> getInvocationContextFactory() {
        return this.invocationContextFactory;
    }

    public ComponentRef<LocalPublisherManager> getLocalPublisherManager() {
        return this.localPublisherManager;
    }

    public ComponentRef<PublisherHandler> getPublisherHandler() {
        return this.publisherHandler;
    }

    public ComponentRef<LockManager> getLockManager() {
        return this.lockManager;
    }

    public ComponentRef<OrderedUpdatesManager> getOrderedUpdatesManager() {
        return this.orderedUpdatesManager;
    }

    public ComponentRef<RecoveryManager> getRecoveryManager() {
        return this.recoveryManager;
    }

    public ComponentRef<RpcManager> getRpcManager() {
        return this.rpcManager;
    }

    public ComponentRef<XSiteStateTransferManager> getXSiteStateTransferManager() {
        return this.xSiteStateTransferManager;
    }

    public ComponentRef<BackupReceiver> getBackupReceiver() {
        return this.backupReceiver;
    }
}

