/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;

class ClusterHealthImpl
implements ClusterHealth {
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;

    ClusterHealthImpl(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    @Override
    public HealthStatus getHealthStatus() {
        HealthStatus globalHealthStatus = HealthStatus.HEALTHY;
        Set healthStatuses = Stream.concat(this.cacheManager.getCacheNames().stream(), this.internalCacheRegistry.getInternalCacheNames().stream()).map(cacheName -> this.cacheManager.getCache((String)cacheName, false)).filter(Objects::nonNull).map(CacheHealthImpl::new).map(CacheHealthImpl::getStatus).collect(Collectors.toSet());
        if (healthStatuses.contains((Object)HealthStatus.DEGRADED)) {
            globalHealthStatus = HealthStatus.DEGRADED;
        } else if (healthStatuses.contains((Object)HealthStatus.HEALTHY_REBALANCING)) {
            globalHealthStatus = HealthStatus.HEALTHY_REBALANCING;
        }
        return globalHealthStatus;
    }

    @Override
    public String getClusterName() {
        return this.cacheManager.getClusterName();
    }

    @Override
    public int getNumberOfNodes() {
        return Optional.ofNullable(this.cacheManager.getMembers()).orElse(Collections.emptyList()).size();
    }

    @Override
    public List<String> getNodeNames() {
        return Optional.ofNullable(this.cacheManager.getMembers()).orElse(Collections.emptyList()).stream().map(Object::toString).collect(Collectors.toList());
    }

    public Json toJson() {
        return Json.object().set("cluster_name", (Object)this.getClusterName()).set("health_status", (Object)this.getHealthStatus()).set("number_of_nodes", (Object)this.getNumberOfNodes()).set("node_names", Json.make(this.getNodeNames()));
    }
}

