/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.processors.AsyncProcessor;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.util.concurrent.CompletionStages;
import org.reactivestreams.Publisher;

public class RxJavaInterop {
    private static final Function<Object, Object> identityFunction = i -> i;
    private static final Consumer<Object> emptyConsumer = ignore -> {};
    private static final Function<Map.Entry<Object, Object>, Object> entryToKeyFunction = Map.Entry::getKey;
    private static final Function<? super Throwable, Publisher<?>> wrapThrowable = t -> Flowable.error((Throwable)Util.rewrapAsCacheException((Throwable)t));

    private RxJavaInterop() {
    }

    public static <R> Flowable<R> voidCompletionStageToFlowable(CompletionStage<Void> stage) {
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            return Flowable.empty();
        }
        AsyncProcessor ap = AsyncProcessor.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                ap.onError(t);
            } else {
                ap.onComplete();
            }
        });
        return ap;
    }

    public static <K, V> Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return entryToKeyFunction;
    }

    public static <R> Function<? super Throwable, Publisher<R>> cacheExceptionWrapper() {
        return wrapThrowable;
    }

    public static <R> Function<R, R> identityFunction() {
        return identityFunction;
    }

    public static <R> Consumer<R> emptyConsumer() {
        return emptyConsumer;
    }
}

