/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.intops.object.DistinctOperation;
import org.infinispan.stream.impl.intops.object.FilterOperation;
import org.infinispan.stream.impl.intops.object.FlatMapOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToIntOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToLongOperation;
import org.infinispan.stream.impl.intops.object.LimitOperation;
import org.infinispan.stream.impl.intops.object.MapOperation;
import org.infinispan.stream.impl.intops.object.MapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.MapToIntOperation;
import org.infinispan.stream.impl.intops.object.MapToLongOperation;
import org.infinispan.stream.impl.intops.object.PeekOperation;
import org.infinispan.stream.impl.intops.object.SortedComparatorOperation;
import org.infinispan.stream.impl.intops.object.SortedOperation;
import org.infinispan.stream.impl.intops.primitive.d.BoxedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.DistinctDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FilterDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.FlatMapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.LimitDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToIntDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToLongDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.MapToObjDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.PeekDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.d.SortedDoubleOperation;
import org.infinispan.stream.impl.intops.primitive.i.AsDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.AsLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.BoxedIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.DistinctIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FilterIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.FlatMapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.LimitIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToDoubleIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToLongIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.MapToObjIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.PeekIntOperation;
import org.infinispan.stream.impl.intops.primitive.i.SortedIntOperation;
import org.infinispan.stream.impl.intops.primitive.l.AsDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.BoxedLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.DistinctLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FilterLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FlatMapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.LimitLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToIntLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToObjLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.PeekLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.SortedLongOperation;

public class IntermediateOperationExternalizer
implements AdvancedExternalizer<IntermediateOperation> {
    private static final int DISTINCT = 0;
    private static final int FILTER = 1;
    private static final int FLATMAP = 2;
    private static final int FLATMAP_DOUBLE = 3;
    private static final int FLATMAP_INT = 4;
    private static final int FLATMAP_LONG = 5;
    private static final int LIMIT = 6;
    private static final int MAP = 7;
    private static final int MAP_DOUBLE = 8;
    private static final int MAP_INT = 9;
    private static final int MAP_LONG = 10;
    private static final int PEEK = 11;
    private static final int SORTED_COMPARATOR = 12;
    private static final int SORTED = 13;
    private static final int DOUBLE_BOXED = 20;
    private static final int DOUBLE_DISTINCT = 21;
    private static final int DOUBLE_FILTER = 22;
    private static final int DOUBLE_FLATMAP = 23;
    private static final int DOUBLE_LIMIT = 24;
    private static final int DOUBLE_MAP = 25;
    private static final int DOUBLE_MAP_INT = 26;
    private static final int DOUBLE_MAP_LONG = 27;
    private static final int DOUBLE_MAP_OBJ = 28;
    private static final int DOUBLE_PEEK = 29;
    private static final int DOUBLE_SORTED = 30;
    private static final int INT_AS_DOUBLE = 40;
    private static final int INT_AS_LONG = 41;
    private static final int INT_BOXED = 42;
    private static final int INT_DISTINCT = 43;
    private static final int INT_FILTER = 44;
    private static final int INT_FLATMAP = 45;
    private static final int INT_LIMIT = 46;
    private static final int INT_MAP = 47;
    private static final int INT_MAP_DOUBLE = 48;
    private static final int INT_MAP_LONG = 49;
    private static final int INT_MAP_OBJ = 50;
    private static final int INT_PEEK = 51;
    private static final int INT_SORTED = 52;
    private static final int LONG_AS_DOUBLE = 60;
    private static final int LONG_BOXED = 61;
    private static final int LONG_DISTINCT = 62;
    private static final int LONG_FILTER = 63;
    private static final int LONG_FLATMAP = 64;
    private static final int LONG_LIMIT = 65;
    private static final int LONG_MAP = 66;
    private static final int LONG_MAP_DOUBLE = 67;
    private static final int LONG_MAP_INT = 68;
    private static final int LONG_MAP_OBJ = 69;
    private static final int LONG_PEEK = 70;
    private static final int LONG_SORTED = 71;
    private final Map<Class<? extends IntermediateOperation>, Integer> operations = new HashMap<Class<? extends IntermediateOperation>, Integer>(72);

    public IntermediateOperationExternalizer() {
        this.operations.put(DistinctOperation.class, 0);
        this.operations.put(FilterOperation.class, 1);
        this.operations.put(FlatMapOperation.class, 2);
        this.operations.put(FlatMapToDoubleOperation.class, 3);
        this.operations.put(FlatMapToIntOperation.class, 4);
        this.operations.put(FlatMapToLongOperation.class, 5);
        this.operations.put(LimitOperation.class, 6);
        this.operations.put(MapOperation.class, 7);
        this.operations.put(MapToDoubleOperation.class, 8);
        this.operations.put(MapToIntOperation.class, 9);
        this.operations.put(MapToLongOperation.class, 10);
        this.operations.put(PeekOperation.class, 11);
        this.operations.put(SortedComparatorOperation.class, 12);
        this.operations.put(SortedOperation.class, 13);
        this.operations.put(BoxedDoubleOperation.class, 20);
        this.operations.put(DistinctDoubleOperation.class, 21);
        this.operations.put(FilterDoubleOperation.class, 22);
        this.operations.put(FlatMapDoubleOperation.class, 23);
        this.operations.put(LimitDoubleOperation.class, 24);
        this.operations.put(MapDoubleOperation.class, 25);
        this.operations.put(MapToIntDoubleOperation.class, 26);
        this.operations.put(MapToLongDoubleOperation.class, 27);
        this.operations.put(MapToObjDoubleOperation.class, 28);
        this.operations.put(PeekDoubleOperation.class, 29);
        this.operations.put(SortedDoubleOperation.class, 30);
        this.operations.put(AsDoubleIntOperation.class, 40);
        this.operations.put(AsLongIntOperation.class, 41);
        this.operations.put(BoxedIntOperation.class, 42);
        this.operations.put(DistinctIntOperation.class, 43);
        this.operations.put(FilterIntOperation.class, 44);
        this.operations.put(FlatMapIntOperation.class, 45);
        this.operations.put(LimitIntOperation.class, 46);
        this.operations.put(MapIntOperation.class, 47);
        this.operations.put(MapToDoubleIntOperation.class, 48);
        this.operations.put(MapToLongIntOperation.class, 49);
        this.operations.put(MapToObjIntOperation.class, 50);
        this.operations.put(PeekIntOperation.class, 51);
        this.operations.put(SortedIntOperation.class, 52);
        this.operations.put(AsDoubleLongOperation.class, 60);
        this.operations.put(BoxedLongOperation.class, 61);
        this.operations.put(DistinctLongOperation.class, 62);
        this.operations.put(FilterLongOperation.class, 63);
        this.operations.put(FlatMapLongOperation.class, 64);
        this.operations.put(LimitLongOperation.class, 65);
        this.operations.put(MapLongOperation.class, 66);
        this.operations.put(MapToDoubleLongOperation.class, 67);
        this.operations.put(MapToIntLongOperation.class, 68);
        this.operations.put(MapToObjLongOperation.class, 69);
        this.operations.put(PeekLongOperation.class, 70);
        this.operations.put(SortedLongOperation.class, 71);
    }

    public Set<Class<? extends IntermediateOperation>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{DistinctOperation.class, FilterOperation.class, FlatMapOperation.class, FlatMapToDoubleOperation.class, FlatMapToIntOperation.class, FlatMapToLongOperation.class, LimitOperation.class, MapOperation.class, MapToDoubleOperation.class, MapToIntOperation.class, MapToLongOperation.class, PeekOperation.class, SortedComparatorOperation.class, SortedOperation.class, BoxedDoubleOperation.class, DistinctDoubleOperation.class, FilterDoubleOperation.class, FlatMapDoubleOperation.class, LimitDoubleOperation.class, MapDoubleOperation.class, MapToIntDoubleOperation.class, MapToLongDoubleOperation.class, MapToDoubleOperation.class, PeekDoubleOperation.class, SortedDoubleOperation.class, AsDoubleIntOperation.class, AsLongIntOperation.class, BoxedIntOperation.class, DistinctOperation.class, FilterIntOperation.class, FlatMapIntOperation.class, LimitIntOperation.class, MapIntOperation.class, MapToDoubleIntOperation.class, MapToLongIntOperation.class, MapToObjIntOperation.class, PeekIntOperation.class, SortedIntOperation.class, AsDoubleLongOperation.class, BoxedLongOperation.class, DistinctOperation.class, FilterLongOperation.class, FlatMapLongOperation.class, LimitOperation.class, MapLongOperation.class, MapToDoubleLongOperation.class, MapToIntLongOperation.class, MapToObjLongOperation.class, PeekLongOperation.class, SortedLongOperation.class});
    }

    public Integer getId() {
        return 84;
    }

    public void writeObject(ObjectOutput output, IntermediateOperation object) throws IOException {
        int number = this.operations.getOrDefault(object.getClass(), -1);
        output.writeByte(number);
        switch (number) {
            case 1: {
                output.writeObject(((FilterOperation)object).getPredicate());
                break;
            }
            case 2: {
                output.writeObject(((FlatMapOperation)object).getFunction());
                break;
            }
            case 3: {
                output.writeObject(((FlatMapToDoubleOperation)object).getFunction());
                break;
            }
            case 4: {
                output.writeObject(((FlatMapToIntOperation)object).getFunction());
                break;
            }
            case 5: {
                output.writeObject(((FlatMapToLongOperation)object).getFunction());
                break;
            }
            case 6: {
                UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)((LimitOperation)object).getLimit());
                break;
            }
            case 7: {
                output.writeObject(((MapOperation)object).getFunction());
                break;
            }
            case 8: {
                output.writeObject(((MapToDoubleOperation)object).getFunction());
                break;
            }
            case 9: {
                output.writeObject(((MapToIntOperation)object).getFunction());
                break;
            }
            case 10: {
                output.writeObject(((MapToLongOperation)object).getFunction());
                break;
            }
            case 11: {
                output.writeObject(((PeekOperation)object).getConsumer());
                break;
            }
            case 12: {
                output.writeObject(((SortedComparatorOperation)object).getComparator());
                break;
            }
            case 22: {
                output.writeObject(((FilterDoubleOperation)object).getPredicate());
                break;
            }
            case 23: {
                output.writeObject(((FlatMapDoubleOperation)object).getFunction());
                break;
            }
            case 24: {
                UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)((LimitDoubleOperation)object).getLimit());
                break;
            }
            case 25: {
                output.writeObject(((MapDoubleOperation)object).getOperator());
                break;
            }
            case 26: {
                output.writeObject(((MapToIntDoubleOperation)object).getFunction());
                break;
            }
            case 27: {
                output.writeObject(((MapToLongDoubleOperation)object).getFunction());
                break;
            }
            case 28: {
                output.writeObject(((MapToObjDoubleOperation)object).getFunction());
                break;
            }
            case 29: {
                output.writeObject(((PeekDoubleOperation)object).getConsumer());
                break;
            }
            case 44: {
                output.writeObject(((FilterIntOperation)object).getPredicate());
                break;
            }
            case 45: {
                output.writeObject(((FlatMapIntOperation)object).getFunction());
                break;
            }
            case 46: {
                UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)((LimitIntOperation)object).getLimit());
                break;
            }
            case 47: {
                output.writeObject(((MapIntOperation)object).getOperator());
                break;
            }
            case 48: {
                output.writeObject(((MapToDoubleIntOperation)object).getFunction());
                break;
            }
            case 49: {
                output.writeObject(((MapToLongIntOperation)object).getFunction());
                break;
            }
            case 50: {
                output.writeObject(((MapToObjIntOperation)object).getFunction());
                break;
            }
            case 51: {
                output.writeObject(((PeekIntOperation)object).getConsumer());
                break;
            }
            case 63: {
                output.writeObject(((FilterLongOperation)object).getPredicate());
                break;
            }
            case 64: {
                output.writeObject(((FlatMapLongOperation)object).getFunction());
                break;
            }
            case 65: {
                UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)((LimitLongOperation)object).getLimit());
                break;
            }
            case 66: {
                output.writeObject(((MapLongOperation)object).getOperator());
                break;
            }
            case 67: {
                output.writeObject(((MapToDoubleLongOperation)object).getFunction());
                break;
            }
            case 68: {
                output.writeObject(((MapToIntLongOperation)object).getFunction());
                break;
            }
            case 69: {
                output.writeObject(((MapToObjLongOperation)object).getFunction());
                break;
            }
            case 70: {
                output.writeObject(((PeekLongOperation)object).getConsumer());
            }
        }
    }

    public IntermediateOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int number = input.readUnsignedByte();
        switch (number) {
            case 0: {
                return DistinctOperation.getInstance();
            }
            case 1: {
                return new FilterOperation((Predicate)input.readObject());
            }
            case 2: {
                return new FlatMapOperation((Function)input.readObject());
            }
            case 3: {
                return new FlatMapToDoubleOperation((Function)input.readObject());
            }
            case 4: {
                return new FlatMapToIntOperation((Function)input.readObject());
            }
            case 5: {
                return new FlatMapToLongOperation((Function)input.readObject());
            }
            case 6: {
                return new LimitOperation(UnsignedNumeric.readUnsignedLong((ObjectInput)input));
            }
            case 7: {
                return new MapOperation((Function)input.readObject());
            }
            case 8: {
                return new MapToDoubleOperation((ToDoubleFunction)input.readObject());
            }
            case 9: {
                return new MapToIntOperation((ToIntFunction)input.readObject());
            }
            case 10: {
                return new MapToLongOperation((ToLongFunction)input.readObject());
            }
            case 11: {
                return new PeekOperation((Consumer)input.readObject());
            }
            case 12: {
                return new SortedComparatorOperation((Comparator)input.readObject());
            }
            case 13: {
                return SortedOperation.getInstance();
            }
            case 20: {
                return BoxedDoubleOperation.getInstance();
            }
            case 21: {
                return DistinctDoubleOperation.getInstance();
            }
            case 22: {
                return new FilterDoubleOperation((DoublePredicate)input.readObject());
            }
            case 23: {
                return new FlatMapDoubleOperation((DoubleFunction)input.readObject());
            }
            case 24: {
                return new LimitDoubleOperation(UnsignedNumeric.readUnsignedLong((ObjectInput)input));
            }
            case 25: {
                return new MapDoubleOperation((DoubleUnaryOperator)input.readObject());
            }
            case 26: {
                return new MapToIntDoubleOperation((DoubleToIntFunction)input.readObject());
            }
            case 27: {
                return new MapToLongDoubleOperation((DoubleToLongFunction)input.readObject());
            }
            case 28: {
                return new MapToObjDoubleOperation((DoubleFunction)input.readObject());
            }
            case 29: {
                return new PeekDoubleOperation((DoubleConsumer)input.readObject());
            }
            case 30: {
                return SortedDoubleOperation.getInstance();
            }
            case 40: {
                return AsDoubleIntOperation.getInstance();
            }
            case 41: {
                return AsLongIntOperation.getInstance();
            }
            case 42: {
                return BoxedIntOperation.getInstance();
            }
            case 43: {
                return DistinctIntOperation.getInstance();
            }
            case 44: {
                return new FilterIntOperation((IntPredicate)input.readObject());
            }
            case 45: {
                return new FlatMapIntOperation((IntFunction)input.readObject());
            }
            case 46: {
                return new LimitIntOperation(UnsignedNumeric.readUnsignedLong((ObjectInput)input));
            }
            case 47: {
                return new MapIntOperation((IntUnaryOperator)input.readObject());
            }
            case 48: {
                return new MapToDoubleIntOperation((IntToDoubleFunction)input.readObject());
            }
            case 49: {
                return new MapToLongIntOperation((IntToLongFunction)input.readObject());
            }
            case 50: {
                return new MapToObjIntOperation((IntFunction)input.readObject());
            }
            case 51: {
                return new PeekIntOperation((IntConsumer)input.readObject());
            }
            case 52: {
                return SortedIntOperation.getInstance();
            }
            case 60: {
                return AsDoubleLongOperation.getInstance();
            }
            case 61: {
                return BoxedLongOperation.getInstance();
            }
            case 62: {
                return DistinctLongOperation.getInstance();
            }
            case 63: {
                return new FilterLongOperation((LongPredicate)input.readObject());
            }
            case 64: {
                return new FlatMapLongOperation((LongFunction)input.readObject());
            }
            case 65: {
                return new LimitLongOperation(UnsignedNumeric.readUnsignedLong((ObjectInput)input));
            }
            case 66: {
                return new MapLongOperation((LongUnaryOperator)input.readObject());
            }
            case 67: {
                return new MapToDoubleLongOperation((LongToDoubleFunction)input.readObject());
            }
            case 68: {
                return new MapToIntLongOperation((LongToIntFunction)input.readObject());
            }
            case 69: {
                return new MapToObjLongOperation((LongFunction)input.readObject());
            }
            case 70: {
                return new PeekLongOperation((LongConsumer)input.readObject());
            }
            case 71: {
                return SortedLongOperation.getInstance();
            }
        }
        throw new IllegalArgumentException("Found invalid number " + number);
    }
}

