/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.MetadataAwareCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;

public class ReplaceCommand
extends AbstractDataWriteCommand
implements MetadataAwareCommand {
    public static final byte COMMAND_ID = 11;
    private Object oldValue;
    private Object newValue;
    private Metadata metadata;
    private boolean successful = true;
    private PrivateMetadata internalMetadata;
    private ValueMatcher valueMatcher;

    public ReplaceCommand() {
    }

    public ReplaceCommand(Object key, Object oldValue, Object newValue, Metadata metadata, int segment, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(key, segment, flagsBitSet, commandInvocationId);
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.metadata = metadata;
        this.valueMatcher = oldValue != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_NON_NULL;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReplaceCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.PRIMARY;
    }

    @Override
    public byte getCommandId() {
        return 11;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.oldValue);
        output.writeObject(this.newValue);
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)this.segment);
        output.writeObject(this.metadata);
        MarshallUtil.marshallEnum((Enum)this.valueMatcher, (ObjectOutput)output);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.internalMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.oldValue = input.readObject();
        this.newValue = input.readObject();
        this.segment = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        this.metadata = (Metadata)input.readObject();
        this.valueMatcher = (ValueMatcher)MarshallUtil.unmarshallEnum((ObjectInput)input, ValueMatcher::valueOf);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.internalMetadata = (PrivateMetadata)input.readObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplaceCommand that = (ReplaceCommand)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.oldValue, that.oldValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
        result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void fail() {
        this.successful = false;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public String toString() {
        return "ReplaceCommand{key=" + Util.toStr((Object)this.key) + ", oldValue=" + Util.toStr((Object)this.oldValue) + ", newValue=" + Util.toStr((Object)this.newValue) + ", metadata=" + this.metadata + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", successful=" + this.successful + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", topologyId=" + this.getTopologyId() + '}';
    }

    @Override
    public PrivateMetadata getInternalMetadata() {
        return this.internalMetadata;
    }

    @Override
    public void setInternalMetadata(PrivateMetadata internalMetadata) {
        this.internalMetadata = internalMetadata;
    }
}

