/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.expiration.TouchMode;

public class ExpirationConfiguration
implements Matchable<ExpirationConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<Long> LIFESPAN = AttributeDefinition.builder((String)"lifespan", (Object)-1L).build();
    public static final AttributeDefinition<Long> MAX_IDLE = AttributeDefinition.builder((String)"maxIdle", (Object)-1L).build();
    public static final AttributeDefinition<Boolean> REAPER_ENABLED = AttributeDefinition.builder((String)"reaperEnabled", (Object)true).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Long> WAKEUP_INTERVAL = AttributeDefinition.builder((String)"wakeUpInterval", (Object)TimeUnit.MINUTES.toMillis(1L)).xmlName("interval").build();
    public static final AttributeDefinition<TouchMode> TOUCH = AttributeDefinition.builder((String)"touch", (Object)((Object)TouchMode.SYNC)).immutable().build();
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.EXPIRATION.getLocalName());
    private final Attribute<Long> lifespan;
    private final Attribute<Long> maxIdle;
    private final Attribute<Boolean> reaperEnabled;
    private final Attribute<Long> wakeUpInterval;
    private final Attribute<TouchMode> touch;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(ExpirationConfiguration.class, new AttributeDefinition[]{LIFESPAN, MAX_IDLE, REAPER_ENABLED, WAKEUP_INTERVAL, TOUCH});
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    ExpirationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.lifespan = attributes.attribute(LIFESPAN);
        this.maxIdle = attributes.attribute(MAX_IDLE);
        this.reaperEnabled = attributes.attribute(REAPER_ENABLED);
        this.wakeUpInterval = attributes.attribute(WAKEUP_INTERVAL);
        this.touch = attributes.attribute(TOUCH);
    }

    public long lifespan() {
        return (Long)this.lifespan.get();
    }

    public long maxIdle() {
        return (Long)this.maxIdle.get();
    }

    public boolean reaperEnabled() {
        return (Boolean)this.reaperEnabled.get();
    }

    public long wakeUpInterval() {
        return (Long)this.wakeUpInterval.get();
    }

    public TouchMode touch() {
        return (TouchMode)((Object)this.touch.get());
    }

    public String toString() {
        return "ExpirationConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpirationConfiguration other = (ExpirationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

