/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;

public class AbstractStoreConfiguration
implements StoreConfiguration,
ConfigurationInfo {
    public static final AttributeDefinition<Boolean> FETCH_PERSISTENT_STATE = AttributeDefinition.builder((String)"fetchPersistentState", (Object)false).xmlName("fetch-state").immutable().build();
    public static final AttributeDefinition<Boolean> PURGE_ON_STARTUP = AttributeDefinition.builder((String)"purgeOnStartup", (Object)false).immutable().xmlName("purge").build();
    public static final AttributeDefinition<Boolean> IGNORE_MODIFICATIONS = AttributeDefinition.builder((String)"ignoreModifications", (Object)false).immutable().xmlName("read-only").build();
    public static final AttributeDefinition<Boolean> WRITE_ONLY = AttributeDefinition.builder((String)"writeOnly", (Object)false).immutable().xmlName("write-only").build();
    public static final AttributeDefinition<Boolean> PRELOAD = AttributeDefinition.builder((String)"preload", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> SHARED = AttributeDefinition.builder((String)"shared", (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> TRANSACTIONAL = AttributeDefinition.builder((String)"transactional", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> MAX_BATCH_SIZE = AttributeDefinition.builder((String)"maxBatchSize", (Object)100).immutable().build();
    public static final AttributeDefinition<Boolean> SEGMENTED = AttributeDefinition.builder((String)"segmented", (Object)true).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((String)"properties", null, TypedProperties.class).initializer(() -> new TypedProperties()).autoPersist(false).immutable().build();
    protected final List<ConfigurationInfo> subElements = new ArrayList<ConfigurationInfo>();
    private final Attribute<Boolean> fetchPersistentState;
    private final Attribute<Boolean> purgeOnStartup;
    private final Attribute<Boolean> ignoreModifications;
    private final Attribute<Boolean> writeOnly;
    private final Attribute<Boolean> preload;
    private final Attribute<Boolean> shared;
    private final Attribute<Boolean> transactional;
    private final Attribute<Integer> maxBatchSize;
    private final Attribute<Boolean> segmented;
    private final Attribute<TypedProperties> properties;
    protected final AttributeSet attributes;
    private final AsyncStoreConfiguration async;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractStoreConfiguration.class, new AttributeDefinition[]{FETCH_PERSISTENT_STATE, PURGE_ON_STARTUP, IGNORE_MODIFICATIONS, WRITE_ONLY, PRELOAD, SHARED, TRANSACTIONAL, MAX_BATCH_SIZE, SEGMENTED, PROPERTIES});
    }

    public List<ConfigurationInfo> subElements() {
        return this.subElements;
    }

    public AbstractStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        this.attributes = attributes.checkProtection();
        this.async = async;
        this.fetchPersistentState = attributes.attribute(FETCH_PERSISTENT_STATE);
        this.purgeOnStartup = attributes.attribute(PURGE_ON_STARTUP);
        this.ignoreModifications = attributes.attribute(IGNORE_MODIFICATIONS);
        this.writeOnly = attributes.attribute(WRITE_ONLY);
        this.preload = attributes.attribute(PRELOAD);
        this.shared = attributes.attribute(SHARED);
        this.transactional = attributes.attribute(TRANSACTIONAL);
        this.maxBatchSize = attributes.attribute(MAX_BATCH_SIZE);
        this.segmented = attributes.attribute(SEGMENTED);
        this.properties = attributes.attribute(PROPERTIES);
        this.subElements.add(async);
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public boolean purgeOnStartup() {
        return (Boolean)this.purgeOnStartup.get();
    }

    @Override
    public boolean shared() {
        return (Boolean)this.shared.get();
    }

    @Override
    public boolean transactional() {
        return (Boolean)this.transactional.get();
    }

    @Override
    public int maxBatchSize() {
        return (Integer)this.maxBatchSize.get();
    }

    @Override
    public boolean segmented() {
        return (Boolean)this.segmented.get();
    }

    @Override
    public boolean fetchPersistentState() {
        return (Boolean)this.fetchPersistentState.get();
    }

    @Override
    public boolean ignoreModifications() {
        return (Boolean)this.ignoreModifications.get();
    }

    @Override
    public boolean writeOnly() {
        return (Boolean)this.writeOnly.get();
    }

    @Override
    public boolean preload() {
        return (Boolean)this.preload.get();
    }

    @Override
    public Properties properties() {
        return (Properties)this.properties.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AbstractStoreConfiguration [attributes=" + this.attributes + ", async=" + this.async + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.async == null ? 0 : this.async.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractStoreConfiguration other = (AbstractStoreConfiguration)obj;
        if (this.async == null ? other.async != null : !this.async.equals(other.async)) {
            return false;
        }
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

