/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractSegmentedStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.persistence.file.SingleFileStore;
import org.infinispan.persistence.spi.InitializationContext;

@BuiltBy(value=SingleFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileStore.class)
public class SingleFileStoreConfiguration
extends AbstractSegmentedStoreConfiguration<SingleFileStoreConfiguration>
implements ConfigurationInfo {
    public static final AttributeDefinition<String> LOCATION = AttributeDefinition.builder((String)"location", null, String.class).immutable().xmlName("path").global(false).build();
    public static final AttributeDefinition<Integer> MAX_ENTRIES = AttributeDefinition.builder((String)"maxEntries", (Object)-1).immutable().build();
    public static final AttributeDefinition<Float> FRAGMENTATION_FACTOR = AttributeDefinition.builder((String)"fragmentationFactor", (Object)Float.valueOf(0.75f)).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.SINGLE_FILE_STORE.getLocalName(), true, false);
    private final Attribute<String> location;
    private final Attribute<Integer> maxEntries;
    private final Attribute<Float> fragmentationFactor;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SingleFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{LOCATION, MAX_ENTRIES, FRAGMENTATION_FACTOR});
    }

    public SingleFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async) {
        super(attributes, async);
        this.location = attributes.attribute(LOCATION);
        this.maxEntries = attributes.attribute(MAX_ENTRIES);
        this.fragmentationFactor = attributes.attribute(FRAGMENTATION_FACTOR);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    @Override
    public SingleFileStoreConfiguration newConfigurationFrom(int segment, InitializationContext ctx) {
        AttributeSet set = SingleFileStoreConfiguration.attributeDefinitionSet();
        set.read(this.attributes);
        String location = (String)set.attribute(LOCATION).get();
        if (location == null) {
            location = ctx.getGlobalConfiguration().globalState().persistentLocation();
        }
        set.attribute(LOCATION).set((Object)SingleFileStoreConfiguration.fileLocationTransform(location, segment));
        return new SingleFileStoreConfiguration(set.protect(), this.async());
    }

    public String location() {
        return (String)this.location.get();
    }

    public int maxEntries() {
        return (Integer)this.maxEntries.get();
    }

    public float fragmentationFactor() {
        return ((Float)this.fragmentationFactor.get()).floatValue();
    }

    @Override
    public String toString() {
        return "SingleFileStoreConfiguration [attributes=" + this.attributes + "]";
    }
}

