/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;

public class StateTransferConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<StateTransferConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = StateTransferConfiguration.attributeDefinitionSet();

    StateTransferConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return StateTransferConfiguration.ELEMENT_DEFINITION;
    }

    public StateTransferConfigurationBuilder fetchInMemoryState(boolean b) {
        this.attributes.attribute(StateTransferConfiguration.FETCH_IN_MEMORY_STATE).set((Object)b);
        return this;
    }

    public StateTransferConfigurationBuilder awaitInitialTransfer(boolean b) {
        this.attributes.attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER).set((Object)b);
        return this;
    }

    public StateTransferConfigurationBuilder chunkSize(int i) {
        this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).set((Object)i);
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l) {
        this.attributes.attribute(StateTransferConfiguration.TIMEOUT).set((Object)l);
        return this;
    }

    public StateTransferConfigurationBuilder timeout(long l, TimeUnit unit) {
        return this.timeout(unit.toMillis(l));
    }

    public void validate() {
        Attribute fetchAttribute;
        int chunkSize = (Integer)this.attributes.attribute(StateTransferConfiguration.CHUNK_SIZE).get();
        if (chunkSize <= 0) {
            throw Log.CONFIG.invalidChunkSize(chunkSize);
        }
        if (this.clustering().cacheMode().isInvalidation() && (fetchAttribute = this.attributes.attribute(StateTransferConfiguration.FETCH_IN_MEMORY_STATE)).isModified() && ((Boolean)fetchAttribute.get()).booleanValue()) {
            throw Log.CONFIG.attributeNotAllowedInInvalidationMode(StateTransferConfiguration.FETCH_IN_MEMORY_STATE.name());
        }
        Attribute awaitInitialTransfer = this.attributes.attribute(StateTransferConfiguration.AWAIT_INITIAL_TRANSFER);
        if (awaitInitialTransfer.isModified() && ((Boolean)awaitInitialTransfer.get()).booleanValue() && !this.getClusteringBuilder().cacheMode().needsStateTransfer()) {
            throw Log.CONFIG.awaitInitialTransferOnlyForDistOrRepl();
        }
        Attribute timeoutAttribute = this.attributes.attribute(StateTransferConfiguration.TIMEOUT);
        Attribute remoteTimeoutAttribute = this.clustering().attributes().attribute(ClusteringConfiguration.REMOTE_TIMEOUT);
        if ((Long)timeoutAttribute.get() < (Long)remoteTimeoutAttribute.get()) {
            throw Log.CONFIG.invalidStateTransferTimeout((Long)timeoutAttribute.get(), (Long)remoteTimeoutAttribute.get());
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public StateTransferConfiguration create() {
        return new StateTransferConfiguration(this.attributes.protect());
    }

    public StateTransferConfigurationBuilder read(StateTransferConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "StateTransferConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

