/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    ADVANCED_EXTERNALIZER,
    ADVANCED_EXTERNALIZERS,
    ALLOW_LIST,
    ASYNC,
    AUTHORIZATION,
    BACKUP,
    BACKUPS,
    BACKUP_FOR,
    BINARY,
    BLOCKING_BOUNDED_QUEUE_THREAD_POOL,
    CACHE_CONTAINER,
    CACHES,
    CACHED_THREAD_POOL,
    CLASS,
    CLUSTERING,
    CLUSTER_LOADER,
    CLUSTER_STORE,
    CLUSTER_ROLE_MAPPER,
    COMMON_NAME_ROLE_MAPPER,
    COMPATIBILITY,
    CUSTOM_INTERCEPTORS,
    CUSTOM_CONFIGURATION_STORAGE,
    CUSTOM_ROLE_MAPPER,
    DATA,
    DATA_CONTAINER,
    DEFAULT,
    DISTRIBUTED_CACHE,
    DISTRIBUTED_CACHE_CONFIGURATION,
    ENCODING,
    EVICTION,
    EXPIRATION,
    FILE_STORE,
    GROUPS,
    GROUPER,
    GLOBAL,
    GLOBAL_STATE,
    HASH,
    HEAP,
    JGROUPS,
    IDENTITY_ROLE_MAPPER,
    IMMUTABLE_CONFIGURATION_STORAGE,
    INDEX,
    INDEXED_ENTITIES,
    INDEXED_ENTITY,
    INDEXING,
    INDEX_READER,
    INDEX_WRITER,
    INDEX_MERGE,
    INTERCEPTOR,
    INVALIDATION_CACHE,
    INVALIDATION_CACHE_CONFIGURATION,
    JMX,
    JMX_STATISTICS,
    KEY_DATA_TYPE("key"),
    KEY_TRANSFORMER,
    KEY_TRANSFORMERS,
    L1,
    LOADER,
    LOCAL_CACHE,
    LOCAL_CACHE_CONFIGURATION,
    PERSISTENCE,
    PERSISTENT_LOCATION,
    LOCKING,
    MANAGED_CONFIGURATION_STORAGE,
    MEMORY,
    METRICS,
    MODULES,
    OBJECT,
    OFF_HEAP,
    NON_BLOCKING_BOUNDED_QUEUE_THREAD_POOL,
    OVERLAY_CONFIGURATION_STORAGE,
    PARTITION_HANDLING,
    PROPERTIES,
    PROPERTY,
    RECOVERY,
    REGEX,
    REMOTE_SITE,
    REMOTE_SITES,
    REPLICATED_CACHE,
    REPLICATED_CACHE_CONFIGURATION,
    ROLE,
    ROLES,
    ROOT,
    SCATTERED_CACHE,
    SCATTERED_CACHE_CONFIGURATION,
    SERIALIZATION_CONTEXT_INITIALIZER("context-initializer"),
    SERIALIZATION_CONTEXT_INITIALIZERS("context-initializers"),
    SHARED_PERSISTENT_LOCATION,
    SCHEDULED_THREAD_POOL,
    SECURITY,
    SERIALIZATION,
    SHUTDOWN,
    SINGLE_FILE_STORE,
    SITE,
    SITES,
    STATE_TRANSFER,
    STACK,
    STACK_FILE,
    STORE,
    STORE_AS_BINARY,
    STORE_MIGRATOR,
    SYNC,
    TAKE_OFFLINE,
    TEMPORARY_LOCATION,
    THREADS,
    THREAD_FACTORIES,
    THREAD_FACTORY,
    THREAD_POOLS,
    TRANSACTION,
    TRANSPORT,
    UNSAFE,
    VALUE_DATA_TYPE("value"),
    VERSIONING,
    VOLATILE_CONFIGURATION_STORAGE,
    WHITE_LIST,
    WRITE_BEHIND,
    STACKS;

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    private Element() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>(8);
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

