/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;

public class CacheManagerInfo
implements JsonSerialization {
    public static final List<String> LOCAL_NODE = Collections.singletonList("local");
    private final DefaultCacheManager cacheManager;
    private final ConfigurationManager configurationManager;
    private final InternalCacheRegistry internalCacheRegistry;

    public CacheManagerInfo(DefaultCacheManager cacheManager, ConfigurationManager configurationManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.configurationManager = configurationManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    public String getCoordinatorAddress() {
        Transport t = this.cacheManager.getTransport();
        return t == null ? "N/A" : t.getCoordinator().toString();
    }

    public boolean isCoordinator() {
        return this.cacheManager.getTransport() != null && this.cacheManager.getTransport().isCoordinator();
    }

    public String getCacheManagerStatus() {
        return this.cacheManager.getStatus().toString();
    }

    public Set<BasicCacheInfo> getDefinedCaches() {
        return this.cacheManager.getCacheNames().stream().map(c -> {
            boolean started = this.cacheManager.getCaches().containsKey(c);
            return new BasicCacheInfo((String)c, started);
        }).collect(Collectors.toSet());
    }

    public Set<String> getCacheConfigurationNames() {
        HashSet<String> names = new HashSet<String>(this.configurationManager.getDefinedConfigurations());
        this.internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    public long getCreatedCacheCount() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> !this.internalCacheRegistry.isInternalCache((String)c)).count();
    }

    public long getRunningCacheCount() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> this.cacheManager.isRunning((String)c) && !this.internalCacheRegistry.isInternalCache((String)c)).count();
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public String getName() {
        return this.configurationManager.getGlobalConfiguration().cacheManagerName();
    }

    public String getNodeAddress() {
        return this.cacheManager.getLogicalAddressString();
    }

    public String getPhysicalAddresses() {
        if (this.cacheManager.getTransport() == null) {
            return "local";
        }
        List<Address> address = this.cacheManager.getTransport().getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    public List<String> getClusterMembers() {
        if (this.cacheManager.getTransport() == null) {
            return LOCAL_NODE;
        }
        return this.cacheManager.getTransport().getMembers().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public List<String> getClusterMembersPhysicalAddresses() {
        if (this.cacheManager.getTransport() == null) {
            return LOCAL_NODE;
        }
        List<Address> addressList = this.cacheManager.getTransport().getMembersPhysicalAddresses();
        return addressList.stream().map(Objects::toString).collect(Collectors.toList());
    }

    public int getClusterSize() {
        if (this.cacheManager.getTransport() == null) {
            return 1;
        }
        return this.cacheManager.getTransport().getMembers().size();
    }

    public String getClusterName() {
        return this.configurationManager.getGlobalConfiguration().transport().clusterName();
    }

    public String getLocalSite() {
        if (this.cacheManager.getTransport() == null) {
            return "local";
        }
        return this.cacheManager.getTransport().localSiteName();
    }

    public Collection<String> getSites() {
        return Optional.ofNullable(this.cacheManager.getTransport()).map(Transport::getSitesView).orElseGet(Collections::emptySet);
    }

    public boolean isSiteCoordinator() {
        Transport transport = this.cacheManager.getTransport();
        return transport != null && transport.isSiteCoordinator();
    }

    public Collection<String> getSiteCoordinatorsAddress() {
        Transport transport = this.cacheManager.getTransport();
        if (transport == null) {
            return LOCAL_NODE;
        }
        return transport.getSiteCoordinatorsAddress().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public Json toJson() {
        return Json.object().set("version", (Object)this.getVersion()).set("name", (Object)this.getName()).set("coordinator", (Object)this.isCoordinator()).set("cache_configuration_names", Json.make(this.getCacheConfigurationNames())).set("cluster_name", (Object)this.getClusterName()).set("physical_addresses", (Object)this.getPhysicalAddresses()).set("coordinator_address", (Object)this.getCoordinatorAddress()).set("cache_manager_status", (Object)this.getCacheManagerStatus()).set("created_cache_count", (Object)this.getCreatedCacheCount()).set("running_cache_count", (Object)this.getRunningCacheCount()).set("node_address", (Object)this.getNodeAddress()).set("cluster_members", Json.make(this.getClusterMembers())).set("cluster_members_physical_addresses", Json.make(this.getClusterMembersPhysicalAddresses())).set("cluster_size", (Object)this.getClusterSize()).set("defined_caches", Json.make(this.getDefinedCaches())).set("local_site", (Object)this.getLocalSite()).set("site_coordinator", (Object)this.isSiteCoordinator()).set("site_coordinators_address", this.getSiteCoordinatorsAddress()).set("sites_view", Json.make(this.getSites()));
    }

    static class BasicCacheInfo
    implements JsonSerialization {
        String name;
        boolean started;

        BasicCacheInfo(String name, boolean started) {
            this.name = name;
            this.started = started;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStarted() {
            return this.started;
        }

        public Json toJson() {
            return Json.object((Object[])new Object[]{"name", this.name}).set("started", (Object)this.started);
        }
    }
}

