/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import java.util.Arrays;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;

@BuiltBy(value=SoftIndexFileStoreConfigurationBuilder.class)
@ConfigurationFor(value=NonBlockingSoftIndexFileStore.class)
public class SoftIndexFileStoreConfiguration
extends AbstractStoreConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Integer> OPEN_FILES_LIMIT = AttributeDefinition.builder((String)"openFilesLimit", (Object)1000).immutable().build();
    public static final AttributeDefinition<Double> COMPACTION_THRESHOLD = AttributeDefinition.builder((String)"compactionThreshold", (Object)0.5).immutable().build();
    private final IndexConfiguration index;
    private final DataConfiguration data;
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.FILE_STORE.getLocalName(), true, false);

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(SoftIndexFileStoreConfiguration.class, AbstractStoreConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{OPEN_FILES_LIMIT, COMPACTION_THRESHOLD});
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public SoftIndexFileStoreConfiguration(AttributeSet attributes, AsyncStoreConfiguration async, IndexConfiguration indexConfiguration, DataConfiguration dataConfiguration) {
        super(attributes, async);
        this.index = indexConfiguration;
        this.data = dataConfiguration;
        this.subElements.addAll(Arrays.asList(this.index, this.data));
    }

    public String dataLocation() {
        return this.data.dataLocation();
    }

    public String indexLocation() {
        return this.index.indexLocation();
    }

    public int indexSegments() {
        return this.index.indexSegments();
    }

    public int maxFileSize() {
        return this.data.maxFileSize();
    }

    public int minNodeSize() {
        return this.index.minNodeSize();
    }

    public int maxNodeSize() {
        return this.index.maxNodeSize();
    }

    public int indexQueueLength() {
        return this.index.indexQueueLength();
    }

    public boolean syncWrites() {
        return this.data.syncWrites();
    }

    public int openFilesLimit() {
        return (Integer)this.attributes.attribute(OPEN_FILES_LIMIT).get();
    }

    public double compactionThreshold() {
        return (Double)this.attributes.attribute(COMPACTION_THRESHOLD).get();
    }

    public IndexConfiguration index() {
        return this.index;
    }

    public DataConfiguration data() {
        return this.data;
    }

    @Override
    public String toString() {
        return "SoftIndexFileStore [attributes=" + this.attributes + "]";
    }
}

