/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import java.util.Arrays;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.NonBlockingSoftIndexFileStore;
import org.infinispan.persistence.sifs.configuration.DataConfiguration;
import org.infinispan.persistence.sifs.configuration.DataConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.IndexConfiguration;
import org.infinispan.persistence.sifs.configuration.IndexConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.util.logging.LogFactory;

public class SoftIndexFileStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SoftIndexFileStoreConfiguration, SoftIndexFileStoreConfigurationBuilder>
implements ConfigurationBuilderInfo {
    private static final Log log = LogFactory.getLog(SoftIndexFileStoreConfigurationBuilder.class, Log.class);
    protected final IndexConfigurationBuilder index = new IndexConfigurationBuilder();
    protected final DataConfigurationBuilder data = new DataConfigurationBuilder();

    public SoftIndexFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        this(builder, SoftIndexFileStoreConfiguration.attributeDefinitionSet(), AsyncStoreConfiguration.attributeDefinitionSet());
    }

    public SoftIndexFileStoreConfigurationBuilder(PersistenceConfigurationBuilder builder, AttributeSet attributeSet, AttributeSet asyncAttributeSet) {
        super(builder, attributeSet, asyncAttributeSet);
        this.subElements.addAll(Arrays.asList(this.index, this.data));
    }

    public ElementDefinition getElementDefinition() {
        return SoftIndexFileStoreConfiguration.ELEMENT_DEFINITION;
    }

    @Override
    public AttributeSet attributes() {
        return this.attributes;
    }

    public SoftIndexFileStoreConfigurationBuilder dataLocation(String dataLocation) {
        this.data.dataLocation(dataLocation);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexLocation(String indexLocation) {
        this.index.indexLocation(indexLocation);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexSegments(int indexSegments) {
        this.index.indexSegments(indexSegments);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxFileSize(int maxFileSize) {
        this.data.maxFileSize(maxFileSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder minNodeSize(int minNodeSize) {
        this.index.minNodeSize(minNodeSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder maxNodeSize(int maxNodeSize) {
        this.index.maxNodeSize(maxNodeSize);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder indexQueueLength(int indexQueueLength) {
        this.index.indexQueueLength(indexQueueLength);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder syncWrites(boolean syncWrites) {
        this.data.syncWrites(syncWrites);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder openFilesLimit(int openFilesLimit) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.OPEN_FILES_LIMIT).set((Object)openFilesLimit);
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder compactionThreshold(double compactionThreshold) {
        this.attributes.attribute(SoftIndexFileStoreConfiguration.COMPACTION_THRESHOLD).set((Object)compactionThreshold);
        return this;
    }

    public SoftIndexFileStoreConfiguration create() {
        return new SoftIndexFileStoreConfiguration(this.attributes.protect(), this.async.create(), this.index.create(), this.data.create());
    }

    @Override
    public Builder<?> read(SoftIndexFileStoreConfiguration template) {
        super.read(template);
        this.index.read(template.index());
        this.data.read(template.data());
        return this;
    }

    public SoftIndexFileStoreConfigurationBuilder self() {
        return this;
    }

    @Override
    protected void validate(boolean skipClassChecks) {
        Attribute segmentedAttribute = this.attributes.attribute(AbstractStoreConfiguration.SEGMENTED);
        if (segmentedAttribute.isModified() && !((Boolean)segmentedAttribute.get()).booleanValue()) {
            throw org.infinispan.util.logging.Log.CONFIG.storeRequiresBeingSegmented(NonBlockingSoftIndexFileStore.class.getSimpleName());
        }
        super.validate(skipClassChecks);
        this.index.validate();
        double compactionThreshold = (Double)this.attributes.attribute(SoftIndexFileStoreConfiguration.COMPACTION_THRESHOLD).get();
        if (compactionThreshold <= 0.0 || compactionThreshold > 1.0) {
            throw log.invalidCompactionThreshold(compactionThreshold);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        PersistenceUtil.validateGlobalStateStoreLocation(globalConfig, NonBlockingSoftIndexFileStore.class.getSimpleName(), this.data.attributes().attribute(DataConfiguration.DATA_LOCATION), this.index.attributes().attribute(IndexConfiguration.INDEX_LOCATION));
        super.validate(globalConfig);
    }

    @Override
    public String toString() {
        return "SoftIndexFileStoreConfigurationBuilder{index=" + this.index + ", data=" + this.data + ", attributes=" + this.attributes + ", async=" + this.async + '}';
    }
}

