/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class AsyncStoreConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> MODIFICATION_QUEUE_SIZE = AttributeDefinition.builder((String)"modificationQueueSize", (Object)1024).immutable().build();
    @Deprecated
    public static final AttributeDefinition<Integer> THREAD_POOL_SIZE = AttributeDefinition.builder((String)"threadPoolSize", (Object)1).immutable().build();
    public static final AttributeDefinition<Boolean> FAIL_SILENTLY = AttributeDefinition.builder((String)"failSilently", (Object)false).immutable().build();
    static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.WRITE_BEHIND.getLocalName());
    private final Attribute<Boolean> enabled;
    private final Attribute<Integer> modificationQueueSize;
    private final Attribute<Integer> threadPoolSize;
    private final Attribute<Boolean> failSilently;
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AsyncStoreConfiguration.class, new AttributeDefinition[]{ENABLED, MODIFICATION_QUEUE_SIZE, THREAD_POOL_SIZE, FAIL_SILENTLY});
    }

    public AsyncStoreConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.modificationQueueSize = attributes.attribute(MODIFICATION_QUEUE_SIZE);
        this.threadPoolSize = attributes.attribute(THREAD_POOL_SIZE);
        this.failSilently = attributes.attribute(FAIL_SILENTLY);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public int modificationQueueSize() {
        return (Integer)this.modificationQueueSize.get();
    }

    @Deprecated
    public int threadPoolSize() {
        return (Integer)this.threadPoolSize.get();
    }

    public boolean failSilently() {
        return (Boolean)this.failSilently.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AsyncStoreConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsyncStoreConfiguration other = (AsyncStoreConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

