/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ClearCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.util.EntryLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class OrderedClusteringDependentLogic
implements ClusteringDependentLogic {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ClusteringDependentLogic cdl;
    private final boolean passivation;
    @Inject
    DataOperationOrderer orderer;
    @Inject
    ActivationManager activationManager;
    @Inject
    InternalDataContainer dataContainer;
    @Inject
    KeyPartitioner keyPartioner;
    @Inject
    ComponentRegistry componentRegistry;

    @Override
    @Start
    public void start() {
        this.componentRegistry.wireDependencies(this.cdl);
        this.cdl.start();
    }

    public OrderedClusteringDependentLogic(ClusteringDependentLogic cdl, boolean passivation) {
        this.cdl = cdl;
        this.passivation = passivation;
    }

    @Override
    public LocalizedCacheTopology getCacheTopology() {
        return this.cdl.getCacheTopology();
    }

    @Override
    public CompletionStage<Void> commitEntry(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
        if (entry instanceof ClearCacheEntry) {
            return this.cdl.commitEntry(entry, command, ctx, trackFlag, l1Invalidation);
        }
        if (this.passivation) {
            return this.commitEntryPassivation(entry, command, ctx, trackFlag, l1Invalidation);
        }
        return this.commitEntryOrdered(entry, command, ctx, trackFlag, l1Invalidation);
    }

    private CompletionStage<Void> commitEntryOrdered(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
        CompletableFuture<DataOperationOrderer.Operation> ourFuture;
        Object key = entry.getKey();
        CompletionStage<DataOperationOrderer.Operation> waitingFuture = this.orderer.orderOn(key, ourFuture = new CompletableFuture<DataOperationOrderer.Operation>());
        CompletionStage<Void> chainedStage = waitingFuture != null ? waitingFuture.thenCompose(ignore -> this.cdl.commitEntry(entry, command, ctx, trackFlag, l1Invalidation)) : this.cdl.commitEntry(entry, command, ctx, trackFlag, l1Invalidation);
        return chainedStage.whenComplete((ignore, ignoreT) -> this.orderer.completeOperation(key, ourFuture, OrderedClusteringDependentLogic.operation(entry)));
    }

    private CompletionStage<Void> commitEntryPassivation(CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
        Object key = entry.getKey();
        int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartioner);
        CompletableFuture<DataOperationOrderer.Operation> ourFuture = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage<DataOperationOrderer.Operation> waitingFuture = this.orderer.orderOn(key, ourFuture);
        CompletionStage<Void> chainedStage = waitingFuture != null ? waitingFuture.thenCompose(ignore -> this.activateKey(key, segment, entry, command, ctx, trackFlag, l1Invalidation)) : this.activateKey(key, segment, entry, command, ctx, trackFlag, l1Invalidation);
        return chainedStage.whenComplete((ignore, ignoreT) -> this.orderer.completeOperation(key, ourFuture, OrderedClusteringDependentLogic.operation(entry)));
    }

    private CompletionStage<Void> activateKey(Object key, int segment, CacheEntry entry, FlagAffectedCommand command, InvocationContext ctx, Flag trackFlag, boolean l1Invalidation) {
        boolean shouldActivate = this.dataContainer.peek(segment, key) == null;
        CompletionStage<Void> commitStage = this.cdl.commitEntry(entry, command, ctx, trackFlag, l1Invalidation);
        if (shouldActivate) {
            return commitStage.thenCompose(ignore1 -> {
                if (log.isTraceEnabled()) {
                    log.tracef("Activating entry for key %s due to update in dataContainer", key);
                }
                return this.activationManager.activateAsync(key, segment);
            });
        }
        if (log.isTraceEnabled()) {
            log.tracef("Skipping removal from store as %s was in the data container", key);
        }
        return commitStage;
    }

    private static DataOperationOrderer.Operation operation(CacheEntry entry) {
        return entry.isRemoved() ? DataOperationOrderer.Operation.REMOVE : DataOperationOrderer.Operation.WRITE;
    }

    @Override
    public ClusteringDependentLogic.Commit commitType(FlagAffectedCommand command, InvocationContext ctx, int segment, boolean removed) {
        return this.cdl.commitType(command, ctx, segment, removed);
    }

    @Override
    public CompletionStage<Map<Object, IncrementableEntryVersion>> createNewVersionsAndCheckForWriteSkews(VersionGenerator versionGenerator, TxInvocationContext context, VersionedPrepareCommand prepareCommand) {
        return this.cdl.createNewVersionsAndCheckForWriteSkews(versionGenerator, context, prepareCommand);
    }

    @Override
    public Address getAddress() {
        return this.cdl.getAddress();
    }

    @Override
    public <K, V> EntryLoader<K, V> getEntryLoader() {
        return this.cdl.getEntryLoader();
    }
}

