/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class IndexConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<String> INDEX_LOCATION = AttributeDefinition.builder((String)"indexLocation", null, String.class).immutable().autoPersist(false).xmlName("path").build();
    public static final AttributeDefinition<Integer> INDEX_QUEUE_LENGTH = AttributeDefinition.builder((String)"indexQueueLength", (Object)1000).immutable().autoPersist(false).xmlName("max-queue-length").build();
    public static final AttributeDefinition<Integer> INDEX_SEGMENTS = AttributeDefinition.builder((String)"indexSegments", (Object)16).immutable().autoPersist(false).xmlName("segments").build();
    public static final AttributeDefinition<Integer> MIN_NODE_SIZE = AttributeDefinition.builder((String)"minNodeSize", (Object)0).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> MAX_NODE_SIZE = AttributeDefinition.builder((String)"maxNodeSize", (Object)4096).immutable().autoPersist(false).build();
    private final AttributeSet attributes;
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.INDEX.getLocalName());

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexConfiguration.class, new AttributeDefinition[]{INDEX_LOCATION, INDEX_QUEUE_LENGTH, INDEX_SEGMENTS, MIN_NODE_SIZE, MAX_NODE_SIZE});
    }

    public IndexConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String indexLocation() {
        return (String)this.attributes.attribute(INDEX_LOCATION).get();
    }

    public void setLocation(String location) {
        this.attributes.attribute(INDEX_LOCATION).set((Object)location);
    }

    public int indexSegments() {
        return (Integer)this.attributes.attribute(INDEX_SEGMENTS).get();
    }

    public int minNodeSize() {
        return (Integer)this.attributes.attribute(MIN_NODE_SIZE).get();
    }

    public int maxNodeSize() {
        return (Integer)this.attributes.attribute(MAX_NODE_SIZE).get();
    }

    public int indexQueueLength() {
        return (Integer)this.attributes.attribute(INDEX_QUEUE_LENGTH).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexConfiguration that = (IndexConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "IndexConfiguration{attributes=" + this.attributes + '}';
    }
}

