/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractRepeatableReadIsolationTest
extends MultipleCacheManagersTest {
    private static final String INITIAL_VALUE = "init";
    private static final String FINAL_VALUE = "final";
    private static final String OTHER_VALUE = "other";
    private final CacheMode cacheMode;
    private final LockingMode lockingMode;

    protected AbstractRepeatableReadIsolationTest(CacheMode cacheMode, LockingMode lockingMode) {
        this.cacheMode = cacheMode;
        this.lockingMode = lockingMode;
    }

    public void testPutTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.PUT);
    }

    public void testPutTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.PUT);
    }

    public void testPutTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.PUT);
    }

    public void testPutTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.PUT);
    }

    public void testRemoveTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.REMOVE);
    }

    public void testRemoveTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.REMOVE);
    }

    public void testRemoveTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.REMOVE);
    }

    public void testRemoveTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.REMOVE);
    }

    public void testReplaceTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.REPLACE);
    }

    public void testReplaceTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.REPLACE);
    }

    public void testReplaceTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.REPLACE);
    }

    public void testReplaceTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.REPLACE);
    }

    public void testConditionalPutTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalPutTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalPutTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalPutTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalRemoveTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalRemoveTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalRemoveTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalRemoveTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalReplaceTxIsolationInOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(true, true, Operation.CONDITIONAL_REPLACE);
    }

    public void testConditionalReplaceTxIsolationInOwnerWithKeyNoInitialized() throws Exception {
        this.doIsolationTest(true, false, Operation.CONDITIONAL_REPLACE);
    }

    public void testConditionalReplaceTxIsolationInNonOwnerWithKeyInitialized() throws Exception {
        this.doIsolationTest(false, true, Operation.CONDITIONAL_REPLACE);
    }

    public void testConditionalReplaceTxIsolationInNonOwnerWithKeyNonInitialized() throws Exception {
        this.doIsolationTest(false, false, Operation.CONDITIONAL_REPLACE);
    }

    public void testPutTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.PUT);
    }

    public void testPutTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.PUT);
    }

    public void testRemoveTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.REMOVE);
    }

    public void testRemoveTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.REMOVE);
    }

    public void testReplaceTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.REPLACE);
    }

    public void testReplaceTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.REPLACE);
    }

    public void testConditionalPutTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalPutTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.CONDITIONAL_PUT);
    }

    public void testConditionalRemoveTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalRemoveTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.CONDITIONAL_REMOVE);
    }

    public void testConditionalReplaceTxIsolationAfterRemoveInOwner() throws Exception {
        this.doIsolationTestAfterRemove(true, Operation.CONDITIONAL_REPLACE);
    }

    public void testConditionalReplaceTxIsolationAfterRemoveInNonOwner() throws Exception {
        this.doIsolationTestAfterRemove(false, Operation.CONDITIONAL_REPLACE);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = AbstractRepeatableReadIsolationTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.transaction().lockingMode(this.lockingMode);
        builder.clustering().hash().numOwners(1);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
    }

    private void doIsolationTest(boolean executeOnOwner, boolean initialized, Operation operation) throws Exception {
        String initValue;
        Cache ownerCache = this.cache(0);
        MagicKey key = new MagicKey("shared", ownerCache);
        Cache cache = executeOnOwner ? this.cache(0) : this.cache(1);
        TransactionManager tm = executeOnOwner ? this.tm(0) : this.tm(1);
        this.assertValueInAllCaches(key, null);
        String string = initValue = initialized ? INITIAL_VALUE : null;
        if (initialized) {
            ownerCache.put((Object)key, (Object)initValue);
            this.assertValueInAllCaches(key, initValue);
        }
        tm.begin();
        AssertJUnit.assertEquals((String)"Wrong first get.", (Object)initValue, (Object)cache.get((Object)key));
        Transaction tx = tm.suspend();
        ownerCache.put((Object)key, (Object)OTHER_VALUE);
        this.assertValueInAllCaches(key, OTHER_VALUE);
        String finalValueExpected = null;
        boolean commitFails = false;
        tm.resume(tx);
        AssertJUnit.assertEquals((String)"Wrong second get.", (Object)initValue, (Object)cache.get((Object)key));
        switch (operation) {
            case PUT: {
                finalValueExpected = FINAL_VALUE;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC;
                AssertJUnit.assertEquals((String)"Wrong put return value.", (Object)initValue, (Object)cache.put((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)FINAL_VALUE, (Object)cache.get((Object)key));
                break;
            }
            case REMOVE: {
                finalValueExpected = null;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC;
                AssertJUnit.assertEquals((String)"Wrong remove return value.", (Object)initValue, (Object)cache.remove((Object)key));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            case REPLACE: {
                finalValueExpected = initialized ? FINAL_VALUE : OTHER_VALUE;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC && initialized;
                AssertJUnit.assertEquals((String)"Wrong replace return value.", (Object)initValue, (Object)cache.replace((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)(initialized ? FINAL_VALUE : null), (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_PUT: {
                finalValueExpected = initialized ? OTHER_VALUE : FINAL_VALUE;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC && !initialized;
                AssertJUnit.assertEquals((String)"Wrong put return value.", (Object)(initialized ? initValue : null), (Object)cache.putIfAbsent((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)(initialized ? initValue : FINAL_VALUE), (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_REMOVE: {
                finalValueExpected = initialized ? null : OTHER_VALUE;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC && initialized;
                AssertJUnit.assertEquals((String)"Wrong remove return value.", (boolean)initialized, (boolean)cache.remove((Object)key, (Object)INITIAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_REPLACE: {
                finalValueExpected = initialized ? FINAL_VALUE : OTHER_VALUE;
                commitFails = this.lockingMode == LockingMode.OPTIMISTIC && initialized;
                AssertJUnit.assertEquals((String)"Wrong replace return value.", (boolean)initialized, (boolean)cache.replace((Object)key, (Object)INITIAL_VALUE, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)(initialized ? FINAL_VALUE : null), (Object)cache.get((Object)key));
                break;
            }
            default: {
                AssertJUnit.fail((String)("Unknown operation " + (Object)((Object)operation)));
            }
        }
        if (commitFails) {
            Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        } else {
            tm.commit();
        }
        this.assertValueInAllCaches(key, this.lockingMode == LockingMode.PESSIMISTIC ? finalValueExpected : OTHER_VALUE);
        this.assertNoTransactions();
    }

    private void doIsolationTestAfterRemove(boolean executeOnOwner, Operation operation) throws Exception {
        Cache ownerCache = this.cache(0);
        MagicKey key = new MagicKey("shared", ownerCache);
        Cache cache = executeOnOwner ? this.cache(0) : this.cache(1);
        TransactionManager tm = executeOnOwner ? this.tm(0) : this.tm(1);
        this.assertValueInAllCaches(key, null);
        String initValue = INITIAL_VALUE;
        ownerCache.put((Object)key, (Object)initValue);
        this.assertValueInAllCaches(key, initValue);
        tm.begin();
        AssertJUnit.assertEquals((String)"Wrong first get.", (Object)initValue, (Object)cache.get((Object)key));
        Transaction tx = tm.suspend();
        ownerCache.put((Object)key, (Object)OTHER_VALUE);
        this.assertValueInAllCaches(key, OTHER_VALUE);
        String finalValueExpected = null;
        boolean commitFails = this.lockingMode == LockingMode.OPTIMISTIC;
        tm.resume(tx);
        AssertJUnit.assertEquals((String)"Wrong second get.", (Object)initValue, (Object)cache.get((Object)key));
        AssertJUnit.assertEquals((String)"Wrong value after remove.", (Object)initValue, (Object)cache.remove((Object)key));
        switch (operation) {
            case PUT: {
                finalValueExpected = FINAL_VALUE;
                AssertJUnit.assertEquals((String)"Wrong put return value.", null, (Object)cache.put((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)FINAL_VALUE, (Object)cache.get((Object)key));
                break;
            }
            case REMOVE: {
                finalValueExpected = null;
                AssertJUnit.assertEquals((String)"Wrong remove return value.", null, (Object)cache.remove((Object)key));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            case REPLACE: {
                finalValueExpected = null;
                AssertJUnit.assertEquals((String)"Wrong replace return value.", null, (Object)cache.replace((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_PUT: {
                finalValueExpected = FINAL_VALUE;
                AssertJUnit.assertEquals((String)"Wrong put return value.", null, (Object)cache.putIfAbsent((Object)key, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", (Object)FINAL_VALUE, (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_REMOVE: {
                finalValueExpected = null;
                AssertJUnit.assertEquals((String)"Wrong remove return value.", (boolean)false, (boolean)cache.remove((Object)key, (Object)INITIAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            case CONDITIONAL_REPLACE: {
                finalValueExpected = null;
                AssertJUnit.assertEquals((String)"Wrong replace return value.", (boolean)false, (boolean)cache.replace((Object)key, (Object)INITIAL_VALUE, (Object)FINAL_VALUE));
                AssertJUnit.assertEquals((String)"Wrong final get.", null, (Object)cache.get((Object)key));
                break;
            }
            default: {
                AssertJUnit.fail((String)("Unknown operation " + (Object)((Object)operation)));
            }
        }
        if (commitFails) {
            Exceptions.expectException(RollbackException.class, () -> ((TransactionManager)tm).commit());
        } else {
            tm.commit();
        }
        this.assertValueInAllCaches(key, this.lockingMode == LockingMode.PESSIMISTIC ? finalValueExpected : OTHER_VALUE);
        this.assertNoTransactions();
    }

    private void assertValueInAllCaches(Object key, Object value) {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)"Wrong value.", (Object)value, (Object)cache.get(key));
        }
    }

    private static enum Operation {
        PUT,
        REMOVE,
        REPLACE,
        CONDITIONAL_PUT,
        CONDITIONAL_REMOVE,
        CONDITIONAL_REPLACE;

    }
}

