/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.time.TimeService;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.AsyncAPITest")
public class AsyncAPITest
extends SingleCacheManagerTest {
    private Cache<String, String> c;
    private ControlledTimeService timeService = new ControlledTimeService();
    private Long startTime;

    @BeforeMethod
    public void clearCache() {
        this.c.clear();
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(false);
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        this.c = cm.getCache();
        return cm;
    }

    public void testGetAsyncWhenKeyIsNotPresent() throws Exception {
        CompletableFuture f = this.c.getAsync((Object)"k");
        this.assertFutureResult(f, null);
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
    }

    public void testGetAsyncAfterPut() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.getAsync((Object)"k");
        this.assertFutureResult(f, "v");
    }

    public void testGetAllAsync() throws Exception {
        this.c.put((Object)"key-one-get", (Object)"one");
        this.c.put((Object)"key-two-get", (Object)"two");
        this.c.put((Object)"key-three-get", (Object)"three");
        HashSet<String> keys = new HashSet<String>();
        keys.add("key-one-get");
        keys.add("key-two-get");
        keys.add("key-three-get");
        CompletableFuture getAllF = this.c.getAllAsync(keys);
        AssertJUnit.assertNotNull((Object)getAllF);
        AssertJUnit.assertFalse((boolean)getAllF.isCancelled());
        Map resultAsMap = (Map)getAllF.get();
        AssertJUnit.assertNotNull((Object)resultAsMap);
        AssertJUnit.assertEquals((String)"one", (String)((String)resultAsMap.get("key-one-get")));
        AssertJUnit.assertEquals((String)"two", (String)((String)resultAsMap.get("key-two-get")));
        AssertJUnit.assertEquals((String)"three", (String)((String)resultAsMap.get("key-three-get")));
        AssertJUnit.assertTrue((boolean)getAllF.isDone());
    }

    public void testPutAsync() throws Exception {
        CompletableFuture f = this.c.putAsync((Object)"k", (Object)"v1");
        this.assertFutureResult(f, null);
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
        f = this.c.putAsync((Object)"k", (Object)"v2");
        this.assertFutureResult(f, "v1");
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.c.get((Object)"k")));
    }

    public void testPutAllAsyncSingleKeyValue() throws Exception {
        CompletableFuture f = this.c.putAllAsync(Collections.singletonMap("k", "v"));
        this.assertFutureResult(f, null);
        AssertJUnit.assertEquals((String)"v", (String)((String)this.c.get((Object)"k")));
    }

    public void testPutAllAsyncMultipleKeyValue() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("one-key", "one");
        map.put("two-key", "two");
        CompletableFuture putAllF = this.c.putAllAsync(map);
        this.assertFutureResult(putAllF, null);
        AssertJUnit.assertEquals((String)"one", (String)((String)this.c.get((Object)"one-key")));
        AssertJUnit.assertEquals((String)"two", (String)((String)this.c.get((Object)"two-key")));
    }

    public void testPutIfAbsentAsync() throws Exception {
        CompletableFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v1");
        this.assertFutureResult(f, null);
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v2");
        this.assertFutureResult(f, "v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
    }

    public void testRemoveAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.c.get((Object)"k")));
        CompletableFuture f = this.c.removeAsync((Object)"k");
        this.assertFutureResult(f, "v");
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
    }

    public void testRemoveConditionalAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.removeAsync((Object)"k", (Object)"v_nonexistent");
        this.assertFutureResult(f, false);
        AssertJUnit.assertEquals((String)"v", (String)((String)this.c.get((Object)"k")));
        f = this.c.removeAsync((Object)"k", (Object)"v");
        this.assertFutureResult(f, true);
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
    }

    public void testReplaceAsyncNonExistingKey() throws Exception {
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v");
        this.assertFutureResult(f, null);
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
    }

    public void testReplaceAsyncExistingKey() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v2");
        this.assertFutureResult(f, "v");
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.c.get((Object)"k")));
    }

    public void testReplaceAsyncConditionalOnOldValueNonExisting() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v_nonexistent", (Object)"v2");
        this.assertFutureResult(f, false);
        AssertJUnit.assertEquals((String)"v", (String)((String)this.c.get((Object)"k")));
    }

    public void testReplaceAsyncConditionalOnOldValue() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v", (Object)"v2");
        this.assertFutureResult(f, true);
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.c.get((Object)"k")));
    }

    public void testComputeIfAbsentAsync() throws Exception {
        Function<Object, String> mappingFunction = k -> k + " world";
        AssertJUnit.assertEquals((String)"hello world", (String)((String)this.c.computeIfAbsentAsync((Object)"hello", mappingFunction).get()));
        AssertJUnit.assertEquals((String)"hello world", (String)((String)this.c.get((Object)"hello")));
        Function<Object, String> functionAfterPut = k -> k + " happy";
        AssertJUnit.assertEquals((String)"hello world", (String)((String)this.c.computeIfAbsentAsync((Object)"hello", functionAfterPut).get()));
        AssertJUnit.assertEquals((String)"hello world", (String)((String)this.c.get((Object)"hello")));
        int cacheSizeBeforeNullValueCompute = this.c.size();
        Function<Object, String> functionMapsToNull = k -> null;
        AssertJUnit.assertNull((String)"with function mapping to null returns null", this.c.computeIfAbsentAsync((Object)"kaixo", functionMapsToNull).get());
        AssertJUnit.assertNull((String)"the key does not exist", (Object)this.c.get((Object)"kaixo"));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)this.c.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        Function<Object, String> functionMapsToException = k -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(ExecutionException.class, RuntimeException.class, (String)"hi there", () -> this.c.computeIfAbsentAsync((Object)"es", functionMapsToException).get());
    }

    public void testComputeIfPresentAsync() throws Exception {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + k + ":" + v;
        this.c.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((String)"hello_es:hola", (String)((String)this.c.computeIfPresentAsync((Object)"es", mappingFunction).get()));
        AssertJUnit.assertEquals((String)"hello_es:hola", (String)((String)this.c.get((Object)"es")));
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, String> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(ExecutionException.class, RuntimeException.class, (String)"hi there", () -> this.c.computeIfPresentAsync((Object)"es", mappingToException).get());
        BiFunction<Object, Object, String> mappingForNotPresentKey = (k, v) -> "absent_" + k + ":" + v;
        AssertJUnit.assertNull((String)"unexisting key should return null", this.c.computeIfPresentAsync((Object)"fr", mappingForNotPresentKey).get());
        AssertJUnit.assertNull((String)"unexisting key should return null", (Object)this.c.get((Object)"fr"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", this.c.computeIfPresentAsync((Object)"es", mappingToNull).get());
        AssertJUnit.assertNull((String)"the key is removed", (Object)this.c.get((Object)"es"));
    }

    public void testComputeAsync() throws Exception {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + k + ":" + v;
        this.c.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((String)"hello_es:hola", (String)((String)this.c.computeAsync((Object)"es", mappingFunction).get()));
        AssertJUnit.assertEquals((String)"hello_es:hola", (String)((String)this.c.get((Object)"es")));
        BiFunction<Object, Object, String> mappingForNotPresentKey = (k, v) -> "absent_" + k + ":" + v;
        AssertJUnit.assertEquals((String)"absent_fr:null", (String)((String)this.c.computeAsync((Object)"fr", mappingForNotPresentKey).get()));
        AssertJUnit.assertEquals((String)"absent_fr:null", (String)((String)this.c.get((Object)"fr")));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        AssertJUnit.assertNull((String)"mapping to null returns null", this.c.computeAsync((Object)"es", mappingToNull).get());
        AssertJUnit.assertNull((String)"the key is removed", (Object)this.c.get((Object)"es"));
        int cacheSizeBeforeNullValueCompute = this.c.size();
        AssertJUnit.assertNull((String)"mapping to null returns null", this.c.computeAsync((Object)"eus", mappingToNull).get());
        AssertJUnit.assertNull((String)"the key does not exist", (Object)this.c.get((Object)"eus"));
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)this.c.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, String> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(ExecutionException.class, RuntimeException.class, (String)"hi there", () -> this.c.computeAsync((Object)"es", mappingToException).get());
    }

    public void testMergeAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        this.c.mergeAsync((Object)"k", (Object)"v", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue).get();
        AssertJUnit.assertEquals((String)"vv", (String)((String)this.c.get((Object)"k")));
        this.c.mergeAsync((Object)"k", (Object)"v2", (SerializableBiFunction & Serializable)(oldValue, newValue) -> null).get();
        AssertJUnit.assertEquals(null, (String)((String)this.c.get((Object)"k")));
        this.c.mergeAsync((Object)"k2", (Object)"42", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue).get();
        AssertJUnit.assertEquals((String)"42", (String)((String)this.c.get((Object)"k2")));
        this.c.put((Object)"k", (Object)"v");
        RuntimeException mergeRaisedException = new RuntimeException("hi there");
        Exceptions.expectException(ExecutionException.class, RuntimeException.class, (String)"hi there", () -> this.cache.mergeAsync((Object)"k", (Object)"v1", (SerializableBiFunction & Serializable)(k, v) -> {
            throw mergeRaisedException;
        }).get());
    }

    public void testPutAsyncWithLifespanAndMaxIdle() throws Exception {
        CompletableFuture f = this.c.putAsync((Object)"k", (Object)"v", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 1000L, 500L, true);
        log.warn((Object)"STARTING FAILING ONE");
        f = this.c.putAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 1000L, 500L, false);
        f = this.c.putAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 3000L, 500L, true);
    }

    public void testPutAllAsyncWithLifespanAndMaxIdle() throws Exception {
        CompletableFuture f = this.c.putAllAsync(Collections.singletonMap("k", "v1"), 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v1", 1000L, 500L, true);
        f = this.c.putAllAsync(Collections.singletonMap("k", "v2"), 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v2", 1000L, 500L, false);
        f = this.c.putAllAsync(Collections.singletonMap("k", "v3"), 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v3", 3000L, 500L, true);
    }

    public void testPutIfAbsentAsyncWithLifespanAndMaxIdle() throws Exception {
        this.c.put((Object)"k", (Object)"v1");
        CompletableFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v2", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
        Thread.sleep(300L);
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.remove((Object)"k")));
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 1000L, 500L, true);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 1000L, 500L, false);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        this.verifyEviction("k", "v", 3000L, 500L, true);
    }

    public void testReplaceAsyncWithLifespan() throws Exception {
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, null);
        AssertJUnit.assertNull((Object)this.c.get((Object)"k"));
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v1", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v");
        this.verifyEviction("k", "v1", 1000L, 500L, true);
        this.c.put((Object)"k", (Object)"v1");
        CompletableFuture f3 = this.c.replaceAsync((Object)"k", (Object)"v_nonexistent", (Object)"v2", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f3, false);
        Thread.sleep(300L);
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.c.get((Object)"k")));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v1", (Object)"v2", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f3, true);
        this.verifyEviction("k", "v2", 1000L, 500L, true);
    }

    public void testReplaceAsyncWithLifespanAndMaxIdle() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.replaceAsync((Object)"k", (Object)"v1", 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v");
        this.verifyEviction("k", "v1", 1000L, 500L, false);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v1", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v");
        this.verifyEviction("k", "v1", 3000L, 500L, true);
        this.c.put((Object)"k", (Object)"v1");
        f = this.c.replaceAsync((Object)"k", (Object)"v1", (Object)"v2", 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, true);
        this.verifyEviction("k", "v2", 1000L, 500L, false);
        this.c.put((Object)"k", (Object)"v1");
        f = this.c.replaceAsync((Object)"k", (Object)"v1", (Object)"v2", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, true);
        this.verifyEviction("k", "v2", 3000L, 500L, true);
    }

    public void testMergeAsyncWithLifespan() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.mergeAsync((Object)"k", (Object)"v1", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "vv1");
        this.verifyEviction("k", "vv1", 1000L, 500L, true);
        f = this.c.mergeAsync((Object)"k2", (Object)"42", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "42");
        this.verifyEviction("k2", "42", 1000L, 500L, true);
    }

    public void testMergeAsyncWithLifespanAndMaxIdle() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.mergeAsync((Object)"k", (Object)"v1", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "vv1");
        this.verifyEviction("k", "vv1", 1000L, 500L, false);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.mergeAsync((Object)"k", (Object)"v1", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 500L, TimeUnit.MILLISECONDS, 5000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "vv1");
        this.verifyEviction("k", "vv1", 500L, 500L, false);
        f = this.c.mergeAsync((Object)"k2", (Object)"v", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v");
        this.verifyEviction("k2", "v", 1000L, 500L, false);
        f = this.c.mergeAsync((Object)"k2", (Object)"v", (SerializableBiFunction & Serializable)(oldValue, newValue) -> "" + oldValue + newValue, 500L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "v");
        this.verifyEviction("k2", "v", 500L, 500L, false);
    }

    public void testComputeAsyncWithLifespan() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.computeAsync((Object)"k", (SerializableBiFunction & Serializable)(key, value) -> "" + key + value, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 1000L, 500L, true);
        f = this.c.computeAsync((Object)"k2", (SerializableBiFunction & Serializable)(key, value) -> "42", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "42");
        this.verifyEviction("k2", "42", 1000L, 500L, true);
    }

    public void testComputeAsyncWithLifespanAndMaxIdle() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.computeAsync((Object)"k", (SerializableBiFunction & Serializable)(key, value) -> "" + key + value, 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 1000L, 500L, false);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.computeAsync((Object)"k", (SerializableBiFunction & Serializable)(key, value) -> "" + key + value, 500L, TimeUnit.MILLISECONDS, 5000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 500L, 500L, false);
        f = this.c.computeAsync((Object)"k2", (SerializableBiFunction & Serializable)(key, value) -> "42", 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "42");
        this.verifyEviction("k2", "42", 1000L, 500L, false);
        f = this.c.computeAsync((Object)"k2", (SerializableBiFunction & Serializable)(key, value) -> "" + value + 42, 500L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "null42");
        this.verifyEviction("k2", "null42", 500L, 500L, false);
    }

    public void testComputeIfPresentAsyncWithLifespan() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.computeIfPresentAsync((Object)"k", (key, value) -> "" + key + value, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 1000L, 500L, true);
    }

    public void testComputeIfPresentAsyncWithLifespanAndMaxIdle() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        CompletableFuture f = this.c.computeIfPresentAsync((Object)"k", (key, value) -> "" + key + value, 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 1000L, 500L, false);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.computeIfPresentAsync((Object)"k", (key, value) -> "" + key + value, 500L, TimeUnit.MILLISECONDS, 5000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "kv");
        this.verifyEviction("k", "kv", 500L, 500L, false);
    }

    public void testComputeIfAbsentAsyncWithLifespan() throws Exception {
        CompletableFuture f = this.c.computeIfAbsentAsync((Object)"k2", (SerializableFunction & Serializable)key -> key + 42, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "k242");
        this.verifyEviction("k2", "k242", 1000L, 500L, true);
    }

    public void testComputeIfAbsentAsyncWithLifespanAndMaxIdle() throws Exception {
        CompletableFuture f = this.c.computeIfAbsentAsync((Object)"k2", (SerializableFunction & Serializable)key -> key + 42, 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "k242");
        this.verifyEviction("k2", "k242", 1000L, 500L, false);
        f = this.c.computeIfAbsentAsync((Object)"k2", (SerializableFunction & Serializable)key -> "" + key + 42, 500L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        this.assertFutureResult(f, "k242");
        this.verifyEviction("k2", "k242", 500L, 500L, false);
    }

    private void assertFutureResult(Future<?> f, Object expected) throws Exception {
        AssertJUnit.assertNotNull(f);
        AssertJUnit.assertFalse((boolean)f.isCancelled());
        AssertJUnit.assertEquals((Object)expected, f.get());
        AssertJUnit.assertTrue((boolean)f.isDone());
    }

    private void markStartTime() {
        this.startTime = this.timeService.wallClockTime();
    }

    private void verifyEviction(String key, String expectedValue, long expectedLifetime, long checkPeriod, boolean touchKey) {
        if (this.startTime == null) {
            throw new IllegalStateException("markStartTime() must be called before verifyEviction(..)");
        }
        try {
            long expectedEndTime = this.startTime + expectedLifetime;
            AbstractInfinispanTest.Condition condition = () -> {
                if (touchKey) {
                    return !this.c.containsKey((Object)key);
                }
                InternalCacheEntry entry = this.c.getAdvancedCache().getDataContainer().peek((Object)key);
                return entry == null || entry.isExpired(this.timeService.wallClockTime());
            };
            AssertJUnit.assertTrue((expectedValue.equals(this.c.get((Object)key)) || this.timeService.wallClockTime() > expectedEndTime ? 1 : 0) != 0);
            while (this.timeService.wallClockTime() <= expectedEndTime) {
                AssertJUnit.assertFalse((String)"Entry evicted too soon!", (boolean)condition.isSatisfied());
                this.timeService.advance(checkPeriod);
            }
            AssertJUnit.assertTrue((this.timeService.wallClockTime() > expectedEndTime ? 1 : 0) != 0);
            AssertJUnit.assertTrue((boolean)condition.isSatisfied());
            Object value = this.c.get((Object)key);
            AssertJUnit.assertNull((Object)value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.startTime = null;
        }
    }
}

