/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.AsyncWithTxTest")
public class AsyncWithTxTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfig = AsyncWithTxTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.addClusterEnabledCacheManager(defaultConfig);
        this.addClusterEnabledCacheManager(defaultConfig);
    }

    public void testWithTx() throws Exception {
        TransactionManager transactionManager = TestingUtil.getTransactionManager(this.cache(0));
        this.cache(0).put((Object)"k", (Object)"v1");
        transactionManager.begin();
        CompletableFuture future = this.cache(0).putAsync((Object)"k", (Object)"v2");
        "v1".equals(future.get(2000L, TimeUnit.MILLISECONDS));
        transactionManager.commit();
    }
}

