/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.lang.invoke.MethodHandles;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ClearTest")
public class ClearTest
extends MultipleCacheManagersTest {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected AdvancedCache<Integer, String> c0;
    protected AdvancedCache<Integer, String> c1;
    protected AdvancedCache<Integer, String> c2;

    @Override
    public Object[] factory() {
        return new Object[]{new ClearTest().cacheMode(CacheMode.DIST_SYNC).transactional(false), new ClearTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.OPTIMISTIC), new ClearTest().cacheMode(CacheMode.DIST_SYNC).transactional(true).lockingMode(LockingMode.PESSIMISTIC), new ClearTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.NEVER).transactional(false), new ClearTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.ON_WRITE).transactional(false)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ClearTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional, this.transactional);
        builder.clustering().hash().numSegments(3).stateTransfer().fetchInMemoryState(true).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        if (this.transactional.booleanValue()) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(this.lockingMode);
        }
        if (this.biasAcquisition != null) {
            builder.clustering().biasAcquisition(this.biasAcquisition);
        }
        this.createCluster(builder, 3);
        this.waitForClusterToForm();
        this.c0 = this.advancedCache(0);
        this.c1 = this.advancedCache(1);
        this.c2 = this.advancedCache(2);
    }

    public void testClear() throws Exception {
        int numKeys = 5;
        log.infof("Putting %d keys into cache ..", (Object)5);
        for (int i = 0; i < 5; ++i) {
            String value = "val_" + i;
            this.c0.put((Object)i, (Object)value);
            AssertJUnit.assertEquals((String)value, (String)((String)this.c0.get((Object)i)));
            AssertJUnit.assertEquals((String)value, (String)((String)this.c1.get((Object)i)));
            AssertJUnit.assertEquals((String)value, (String)((String)this.c2.get((Object)i)));
        }
        log.info((Object)"Finished putting keys");
        DataContainer dc0 = this.c0.getDataContainer();
        DataContainer dc1 = this.c1.getDataContainer();
        DataContainer dc2 = this.c2.getDataContainer();
        AssertJUnit.assertTrue((dc0.size() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((dc1.size() > 0 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((dc2.size() > 0 ? 1 : 0) != 0);
        log.info((Object)"Clearing cache ..");
        this.c0.clear();
        log.info((Object)"Finished clearing cache");
        AssertJUnit.assertEquals((int)0, (int)dc0.size());
        AssertJUnit.assertEquals((int)0, (int)dc1.size());
        AssertJUnit.assertEquals((int)0, (int)dc2.size());
    }
}

