/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.statetransfer.StateResponseCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.impl.EntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ConditionalOperationPrimaryOwnerFailTest")
public class ConditionalOperationPrimaryOwnerFailTest
extends MultipleCacheManagersTest {
    private static final String INITIAL_VALUE = "initial";
    private static final String FINAL_VALUE = "final";

    public void testEntryNotWrapped() throws Throwable {
        this.assertClusterSize("Wrong cluster size!", 3);
        MagicKey key = new MagicKey(this.cache(0), this.cache(1));
        Cache futureBackupOwnerCache = this.cache(2);
        this.cache(0).put((Object)key, (Object)INITIAL_VALUE);
        PerCacheInboundInvocationHandler spyHandler = this.spyInvocationHandler(futureBackupOwnerCache);
        EntryFactory spyEntryFactory = this.spyEntryFactory(futureBackupOwnerCache);
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        ((PerCacheInboundInvocationHandler)Mockito.doAnswer(invocation -> {
            CacheRpcCommand command = (CacheRpcCommand)invocation.getArguments()[0];
            if (command instanceof StateResponseCommand) {
                log.debugf("Blocking command %s", (Object)command);
                latch2.countDown();
                latch1.await();
            }
            return invocation.callRealMethod();
        }).when((Object)spyHandler)).handle((CacheRpcCommand)Matchers.any(CacheRpcCommand.class), (Reply)Matchers.any(Reply.class), (DeliverOrder)Matchers.any(DeliverOrder.class));
        ((EntryFactory)Mockito.doAnswer(invocation -> {
            InvocationContext context = (InvocationContext)invocation.getArguments()[0];
            log.debugf("wrapEntryForWriting invoked with %s", (Object)context);
            CompletionStage stage = (CompletionStage)invocation.callRealMethod();
            CompletionStages.join((CompletionStage)stage);
            Assert.assertNull((Object)context.lookupEntry(key), (String)"Entry should not be wrapped!");
            return stage;
        }).when((Object)spyEntryFactory)).wrapEntryForWriting((InvocationContext)Matchers.any(InvocationContext.class), Matchers.any(), ArgumentMatchers.anyInt(), Matchers.anyBoolean(), Matchers.anyBoolean());
        Future<Void> killMemberResult = this.fork(() -> this.killMember(1));
        latch2.await(30L, TimeUnit.SECONDS);
        futureBackupOwnerCache.put((Object)key, (Object)FINAL_VALUE);
        latch1.countDown();
        killMemberResult.get(30L, TimeUnit.SECONDS);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ConditionalOperationPrimaryOwnerFailTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.clustering().hash().numOwners(2).stateTransfer().fetchInMemoryState(true);
        this.createClusteredCaches(3, TestDataSCI.INSTANCE, builder);
    }

    private EntryFactory spyEntryFactory(Cache<Object, Object> cache) {
        EntryFactory spy = (EntryFactory)Mockito.spy((Object)TestingUtil.extractComponent(cache, EntryFactory.class));
        TestingUtil.replaceComponent(cache, EntryFactory.class, spy, true);
        return spy;
    }

    private PerCacheInboundInvocationHandler spyInvocationHandler(Cache cache) {
        return TestingUtil.wrapInboundInvocationHandler(cache, Mockito::spy);
    }
}

