/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ConditionalOperationsConcurrentTest")
public class ConditionalOperationsConcurrentTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected final int nodes;
    protected final int operations;
    protected final int threads;
    private static final String SHARED_KEY = "thisIsTheKeyForConcurrentAccess";
    private final String[] validMoves;
    private final AtomicBoolean failed = new AtomicBoolean(false);
    private final AtomicBoolean quit = new AtomicBoolean(false);
    private final AtomicInteger liveWorkers = new AtomicInteger();
    private volatile String failureMessage = "";
    protected boolean transactional = false;
    protected LockingMode lockingMode = LockingMode.OPTIMISTIC;
    protected boolean writeSkewCheck = false;

    @Override
    public Object[] factory() {
        return new Object[]{new ConditionalOperationsConcurrentTest().cacheMode(CacheMode.DIST_SYNC), new ConditionalOperationsConcurrentTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.NEVER), new ConditionalOperationsConcurrentTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    public ConditionalOperationsConcurrentTest() {
        this(2, 10, 2);
    }

    public ConditionalOperationsConcurrentTest(int nodes, int operations, int threads) {
        this.nodes = nodes;
        this.operations = operations;
        this.threads = threads;
        this.validMoves = this.generateValidMoves();
    }

    @BeforeMethod
    public void init() {
        this.failed.set(false);
        this.quit.set(false);
        this.liveWorkers.set(0);
        this.failureMessage = "";
        AssertJUnit.assertEquals((int)this.operations, (int)this.validMoves.length);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = ConditionalOperationsConcurrentTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        dcc.transaction().lockingMode(this.lockingMode);
        if (this.writeSkewCheck) {
            dcc.transaction().locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        if (this.biasAcquisition != null) {
            dcc.clustering().biasAcquisition(this.biasAcquisition);
        }
        this.createCluster(TestDataSCI.INSTANCE, dcc, this.nodes);
        this.waitForClusterToForm();
    }

    public void testReplace() throws Exception {
        List<Cache> caches = this.caches(null);
        this.testOnCaches(caches, new ReplaceOperation(true));
    }

    public void testConditionalRemove() throws Exception {
        List<Cache> caches = this.caches(null);
        this.testOnCaches(caches, new ConditionalRemoveOperation(true));
    }

    public void testPutIfAbsent() throws Exception {
        List<Cache> caches = this.caches(null);
        this.testOnCaches(caches, new PutIfAbsentOperation(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testOnCaches(List<Cache> caches, CacheOperation operation) {
        this.failed.set(false);
        this.quit.set(false);
        caches.get(0).put((Object)SHARED_KEY, (Object)"initialValue");
        SharedState state = new SharedState(this.threads);
        PostOperationStateCheck stateCheck = new PostOperationStateCheck(caches, state, operation);
        CyclicBarrier barrier = new CyclicBarrier(this.threads, stateCheck);
        String className = this.getClass().getSimpleName();
        ExecutorService exec = Executors.newFixedThreadPool(this.threads, this.getTestThreadFactory("Mover"));
        for (int threadIndex = 0; threadIndex < this.threads; ++threadIndex) {
            ValidMover validMover = new ValidMover(caches, barrier, threadIndex, state, operation);
            exec.execute(validMover);
        }
        exec.shutdown();
        try {
            boolean finished = exec.awaitTermination(5L, TimeUnit.MINUTES);
            AssertJUnit.assertTrue((String)"Test took too long", (boolean)finished);
        }
        catch (InterruptedException e) {
            this.fail("Thread interrupted!");
        }
        finally {
            exec.shutdownNow();
        }
        AssertJUnit.assertFalse((String)this.failureMessage, (boolean)this.failed.get());
    }

    private String[] generateValidMoves() {
        String[] validMoves = new String[this.operations];
        for (int i = 0; i < this.operations; ++i) {
            validMoves[i] = "v_" + i;
        }
        this.print("Valid moves ready");
        return validMoves;
    }

    private void fail(String message) {
        boolean firstFailure = this.failed.compareAndSet(false, true);
        if (firstFailure) {
            this.failureMessage = message;
        }
    }

    private void fail(Exception e) {
        log.error((Object)"Failing because of exception", (Throwable)e);
        this.fail(e.toString());
    }

    private void print(String s) {
        log.debug((Object)s);
    }

    class ConditionalRemoveOperation
    extends CacheOperation {
        ConditionalRemoveOperation(boolean cas) {
            super(cas);
        }

        @Override
        public boolean execute(Cache cache, String sharedKey, Object existing, String targetValue) {
            try {
                return cache.remove((Object)ConditionalOperationsConcurrentTest.SHARED_KEY, existing);
            }
            catch (CacheException e) {
                return false;
            }
        }

        @Override
        public void beforeOperation(Cache cache) {
            try {
                cache.put((Object)ConditionalOperationsConcurrentTest.SHARED_KEY, (Object)"someValue");
            }
            catch (CacheException e) {
                log.warn((Object)"Write skew check error while inserting the key", (Throwable)e);
            }
        }

        @Override
        boolean validateTargetValueForSuccess(Object afterTargetValue, Object currentStored) {
            return currentStored == null;
        }
    }

    class PutIfAbsentOperation
    extends CacheOperation {
        PutIfAbsentOperation(boolean cas) {
            super(cas);
        }

        @Override
        public boolean execute(Cache cache, String sharedKey, Object existing, String targetValue) {
            try {
                Object o = cache.putIfAbsent((Object)ConditionalOperationsConcurrentTest.SHARED_KEY, (Object)targetValue);
                return o == null;
            }
            catch (CacheException e) {
                return false;
            }
        }

        @Override
        public void beforeOperation(Cache cache) {
            try {
                cache.remove((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
            }
            catch (CacheException e) {
                log.debug((Object)"Write skew check error while removing the key", (Throwable)e);
            }
        }
    }

    static class ReplaceOperation
    extends CacheOperation {
        ReplaceOperation(boolean cas) {
            super(cas);
        }

        @Override
        public boolean execute(Cache cache, String sharedKey, Object existing, String targetValue) {
            try {
                return cache.replace((Object)ConditionalOperationsConcurrentTest.SHARED_KEY, existing, (Object)targetValue);
            }
            catch (CacheException e) {
                return false;
            }
        }

        @Override
        public void beforeOperation(Cache cache) {
        }
    }

    public static abstract class CacheOperation {
        private final boolean isCas;

        protected CacheOperation(boolean cas) {
            this.isCas = cas;
        }

        public final boolean isCas() {
            return this.isCas;
        }

        abstract boolean execute(Cache var1, String var2, Object var3, String var4);

        abstract void beforeOperation(Cache var1);

        boolean validateTargetValueForSuccess(Object afterTargetValue, Object currentStored) {
            return afterTargetValue.equals(currentStored);
        }
    }

    final class PostOperationStateCheck
    implements Runnable {
        private final List<Cache> caches;
        private final SharedState state;
        private final CacheOperation operation;
        private volatile int cycle = 0;

        public PostOperationStateCheck(List<Cache> caches, SharedState state, CacheOperation operation) {
            this.caches = caches;
            this.state = state;
            this.operation = operation;
        }

        @Override
        public void run() {
            if (this.state.isAfter()) {
                ++this.cycle;
                log.tracef("Starting cycle %d", this.cycle);
                if (this.cycle % Math.max(ConditionalOperationsConcurrentTest.this.operations / 100, 1) == 0) {
                    ConditionalOperationsConcurrentTest.this.print(this.cycle * 100 * ConditionalOperationsConcurrentTest.this.threads / ConditionalOperationsConcurrentTest.this.operations + "%");
                }
                this.checkAfterState();
            } else {
                this.checkBeforeState();
            }
        }

        private void checkSameValueOnAllCaches() {
            Object currentStored = this.caches.get(0).get((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
            log.tracef("Value seen by (first) cache %s is %s ", (Object)this.caches.get(0).getAdvancedCache().getRpcManager().getAddress(), currentStored);
            for (Cache c : this.caches) {
                Object v = c.get((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
                Address currentCache = c.getAdvancedCache().getRpcManager().getAddress();
                log.tracef("Value seen by cache %s is %s", (Object)currentCache, v);
                boolean sameValue = v == null ? currentStored == null : v.equals(currentStored);
                if (sameValue) continue;
                ConditionalOperationsConcurrentTest.this.fail(Thread.currentThread().getName() + ": Not all the caches see the same value. first cache: " + currentStored + " cache " + currentCache + " saw " + v);
            }
        }

        private void checkBeforeState() {
            Object currentStored = this.caches.get(0).get((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
            for (SharedThreadState threadState : this.state.threadStates) {
                if (threadState.sameBeforeValue(currentStored)) continue;
                ConditionalOperationsConcurrentTest.this.fail("Some cache expected a different value than what is stored");
            }
        }

        private void checkAfterState() {
            Object currentStored = this.assertTestCorrectness();
            this.checkSameValueOnAllCaches();
            if (this.operation.isCas()) {
                this.checkSingleSuccessfulThread();
                this.checkSuccessfulOperation(currentStored);
            }
            this.checkNoLocks();
        }

        private Object assertTestCorrectness() {
            AdvancedCache someCache = this.caches.get(0).getAdvancedCache();
            Object currentStored = someCache.get((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
            HashSet<Object> uniqueValueVerify = new HashSet<Object>();
            for (SharedThreadState threadState : this.state.threadStates) {
                uniqueValueVerify.add(threadState.afterTargetValue);
            }
            if (uniqueValueVerify.size() != ConditionalOperationsConcurrentTest.this.threads) {
                ConditionalOperationsConcurrentTest.this.fail("test bug");
            }
            return currentStored;
        }

        private void checkNoLocks() {
            for (Cache c : this.caches) {
                LockManager lockManager = (LockManager)c.getAdvancedCache().getComponentRegistry().getComponent(LockManager.class);
                boolean isLocked = true;
                for (int i = 0; i < 30; ++i) {
                    if (!lockManager.isLocked((Object)ConditionalOperationsConcurrentTest.SHARED_KEY)) {
                        isLocked = false;
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!isLocked) continue;
                ConditionalOperationsConcurrentTest.this.fail("lock on the entry wasn't cleaned up");
            }
        }

        private void checkSuccessfulOperation(Object currentStored) {
            for (SharedThreadState threadState : this.state.threadStates) {
                if (threadState.successfulOperation) {
                    if (this.operation.validateTargetValueForSuccess(threadState.afterTargetValue, currentStored)) continue;
                    ConditionalOperationsConcurrentTest.this.fail("operation successful but the current stored value doesn't match the write operation of the successful thread");
                    continue;
                }
                if (!threadState.afterTargetValue.equals(currentStored)) continue;
                ConditionalOperationsConcurrentTest.this.fail("operation not successful (which is fine) but the current stored value matches the write attempt");
            }
        }

        private void checkSingleSuccessfulThread() {
            int successfulThreads = 0;
            for (SharedThreadState threadState : this.state.threadStates) {
                if (!threadState.successfulOperation) continue;
                ++successfulThreads;
            }
            if (successfulThreads != 1) {
                ConditionalOperationsConcurrentTest.this.fail(successfulThreads + " threads assume a successful replacement! (CAS should succeed on a single thread only)");
            }
        }
    }

    static final class SharedThreadState {
        Object beforeExpected;
        Object beforeTargetValue;
        Object afterExpected;
        Object afterTargetValue;
        boolean successfulOperation;

        SharedThreadState() {
        }

        public void beforeReplace(Object expected, Object targetValue) {
            this.beforeExpected = expected;
            this.beforeTargetValue = targetValue;
        }

        public void afterReplace(Object expected, Object targetValue, boolean replaced) {
            this.afterExpected = expected;
            this.afterTargetValue = targetValue;
            this.successfulOperation = replaced;
        }

        public boolean sameBeforeValue(Object currentStored) {
            return currentStored == null ? this.beforeExpected == null : currentStored.equals(this.beforeExpected);
        }
    }

    static final class SharedState {
        private final SharedThreadState[] threadStates;
        private volatile boolean after = false;

        public SharedState(int threads) {
            this.threadStates = new SharedThreadState[threads];
            for (int i = 0; i < threads; ++i) {
                this.threadStates[i] = new SharedThreadState();
            }
        }

        synchronized void beforeOperation(int threadIndex, Object expected, String targetValue) {
            this.threadStates[threadIndex].beforeReplace(expected, targetValue);
            this.after = false;
        }

        synchronized void afterOperation(int threadIndex, Object expected, String targetValue, boolean successful) {
            this.threadStates[threadIndex].afterReplace(expected, targetValue, successful);
            this.after = true;
        }

        public boolean isAfter() {
            return this.after;
        }
    }

    final class ValidMover
    implements Runnable {
        private final List<Cache> caches;
        private final int threadIndex;
        private final CyclicBarrier barrier;
        private final SharedState state;
        private final CacheOperation operation;

        public ValidMover(List<Cache> caches, CyclicBarrier barrier, int threadIndex, SharedState state, CacheOperation operation) {
            this.caches = caches;
            this.barrier = barrier;
            this.threadIndex = threadIndex;
            this.state = state;
            this.operation = operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int cachePickIndex = this.threadIndex;
            ConditionalOperationsConcurrentTest.this.liveWorkers.incrementAndGet();
            try {
                for (int moveToIndex = this.threadIndex; !(moveToIndex >= ConditionalOperationsConcurrentTest.this.validMoves.length || this.barrier.isBroken() || ConditionalOperationsConcurrentTest.this.failed.get() || ConditionalOperationsConcurrentTest.this.quit.get()); moveToIndex += ConditionalOperationsConcurrentTest.this.threads) {
                    this.operation.beforeOperation(this.caches.get(0));
                    ++cachePickIndex;
                    Cache cache = this.caches.get(cachePickIndex %= this.caches.size());
                    Object existing = cache.get((Object)ConditionalOperationsConcurrentTest.SHARED_KEY);
                    String targetValue = ConditionalOperationsConcurrentTest.this.validMoves[moveToIndex];
                    this.state.beforeOperation(this.threadIndex, existing, targetValue);
                    this.blockAtTheBarrier();
                    boolean successful = this.operation.execute(cache, ConditionalOperationsConcurrentTest.SHARED_KEY, existing, targetValue);
                    this.state.afterOperation(this.threadIndex, existing, targetValue, successful);
                    this.blockAtTheBarrier();
                }
                ConditionalOperationsConcurrentTest.this.quit.set(true);
                this.barrier.reset();
            }
            catch (InterruptedException | RuntimeException e) {
                log.error((Object)"Caught exception", (Throwable)e);
                ConditionalOperationsConcurrentTest.this.fail(e);
            }
            catch (BrokenBarrierException e) {
                log.error((Object)"Caught exception", (Throwable)e);
                ConditionalOperationsConcurrentTest.this.print("Broken barrier!");
            }
            finally {
                int andGet = ConditionalOperationsConcurrentTest.this.liveWorkers.decrementAndGet();
                this.barrier.reset();
                ConditionalOperationsConcurrentTest.this.print("Thread #" + this.threadIndex + " terminating. Still " + andGet + " threads alive");
            }
        }

        private void blockAtTheBarrier() throws InterruptedException, BrokenBarrierException {
            block2: {
                try {
                    this.barrier.await(10000L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (ConditionalOperationsConcurrentTest.this.quit.get()) break block2;
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

