/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.MetadataAPIDefaultExpiryTest")
public class MetadataAPIDefaultExpiryTest
extends SingleCacheManagerTest {
    public static final int EXPIRATION_TIMEOUT = 1000;
    private final ControlledTimeService controlledTimeService = new ControlledTimeService();

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.expiration().lifespan(1000L);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        TestingUtil.replaceComponent((CacheContainer)manager, TimeService.class, this.controlledTimeService, true);
        return manager;
    }

    public void testDefaultLifespanPut() {
        this.cache().put((Object)1, (Object)"v1");
        this.expectCachedThenExpired(1, "v1");
        this.cache().getAdvancedCache().put((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.expectCachedThenExpired(2, "v2");
    }

    public void testDefaultLifespanReplace() {
        this.cache().put((Object)1, (Object)"v1");
        this.cache().replace((Object)1, (Object)"v11");
        this.expectCachedThenExpired(1, "v11");
        this.cache().getAdvancedCache().put((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.cache().getAdvancedCache().replace((Object)2, (Object)"v22", new EmbeddedMetadata.Builder().build());
        this.expectCachedThenExpired(2, "v22");
    }

    public void testDefaultLifespanReplaceWithOldValue() {
        this.cache().put((Object)1, (Object)"v1");
        this.cache().replace((Object)1, (Object)"v1", (Object)"v11");
        this.expectCachedThenExpired(1, "v11");
        this.cache().getAdvancedCache().put((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.cache().getAdvancedCache().replace((Object)2, (Object)"v2", (Object)"v22", new EmbeddedMetadata.Builder().build());
        this.expectCachedThenExpired(2, "v22");
    }

    public void testDefaultLifespanPutIfAbsent() {
        this.cache().putIfAbsent((Object)1, (Object)"v1");
        this.expectCachedThenExpired(1, "v1");
        this.cache().getAdvancedCache().putIfAbsent((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.expectCachedThenExpired(2, "v2");
    }

    public void testDefaultLifespanPutForExternalRead() {
        this.cache().putForExternalRead((Object)1, (Object)"v1");
        this.expectCachedThenExpired(1, "v1");
        this.cache().getAdvancedCache().putForExternalRead((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.expectCachedThenExpired(2, "v2");
    }

    public void testDefaultLifespanPutAsync() throws Exception {
        CompletableFuture f = this.cache().putAsync((Object)1, (Object)"v1");
        f.get(10L, TimeUnit.SECONDS);
        this.expectCachedThenExpired(1, "v1");
        f = this.cache().getAdvancedCache().putAsync((Object)2, (Object)"v2", new EmbeddedMetadata.Builder().build());
        f.get(10L, TimeUnit.SECONDS);
        this.expectCachedThenExpired(2, "v2");
    }

    private void expectCachedThenExpired(Integer key, String value) {
        this.controlledTimeService.advance(999L);
        String v = (String)this.cache().get((Object)key);
        AssertJUnit.assertEquals((String)value, (String)v);
        this.controlledTimeService.advance(2L);
        AssertJUnit.assertNull((Object)this.cache.get((Object)key));
    }
}

