/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.util.ControlledRpcManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.NonDuplicateModificationTest")
public class NonDuplicateModificationTest
extends MultipleCacheManagersTest {
    @Override
    public Object[] factory() {
        return new Object[]{new NonDuplicateModificationTest().cacheMode(CacheMode.REPL_SYNC), new NonDuplicateModificationTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.NEVER)};
    }

    public void testPut() throws Exception {
        this.performTestOn(Operation.PUT);
    }

    public void testReplace() throws Exception {
        this.performTestOn(Operation.REPLACE);
    }

    public void testRemove() throws Exception {
        this.performTestOn(Operation.REMOVE);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonDuplicateModificationTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        if (this.biasAcquisition != null) {
            builder.clustering().biasAcquisition(this.biasAcquisition);
        }
        builder.clustering().hash().numSegments(60);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
    }

    private void performTestOn(Operation operation) throws Exception {
        MagicKey key = this.getKeyForCache(this.cache(0), this.cache(1));
        this.cache(0).put((Object)key, (Object)"v1");
        this.assertKeyValue(key, "v1");
        ControlledRpcManager controlledRpcManager = ControlledRpcManager.replaceRpcManager(this.cache(1));
        Future<Void> future = this.fork(() -> {
            operation.execute((Cache<Object, Object>)this.cache(1), key, "v2");
            return null;
        });
        ControlledRpcManager.BlockedResponseMap blockedResponses = operation.expectCommand(controlledRpcManager).send().expectAllResponses();
        this.cache(0).put((Object)key, (Object)"v3");
        blockedResponses.receive();
        future.get();
        controlledRpcManager.revertRpcManager();
        this.assertKeyValue(key, "v3");
    }

    private void assertKeyValue(Object key, Object expected) {
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)("Wrong value for key " + key + " on " + this.address(cache)), (Object)expected, (Object)cache.get(key));
        }
    }

    private static enum Operation {
        PUT(PutKeyValueCommand.class),
        REMOVE(RemoveCommand.class),
        REPLACE(ReplaceCommand.class);

        private final Class<? extends ReplicableCommand> classToBlock;

        private Operation(Class<? extends ReplicableCommand> classToBlock) {
            this.classToBlock = classToBlock;
        }

        private ControlledRpcManager.BlockedRequest expectCommand(ControlledRpcManager rpcManager) throws InterruptedException {
            return rpcManager.expectCommand(this.classToBlock);
        }

        private void execute(Cache<Object, Object> cache, Object key, Object value) {
            switch (this) {
                case PUT: {
                    cache.put(key, value);
                    break;
                }
                case REMOVE: {
                    cache.remove(key);
                    break;
                }
                case REPLACE: {
                    cache.replace(key, value);
                }
            }
        }
    }
}

