/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.CountingRpcManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.RepeatableReadRemoteGetCountTest")
public class RepeatableReadRemoteGetCountTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = RepeatableReadRemoteGetCountTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.clustering().hash().numOwners(1);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
    }

    public void testOnKeyInitialized() throws Exception {
        this.doTest(true);
    }

    public void testOnKeyNonInitialized() throws Exception {
        this.doTest(false);
    }

    public void testWithoutReading() throws Exception {
        MagicKey key = new MagicKey("key", this.cache(0));
        Cache cache = this.cache(1);
        TransactionManager tm = this.tm(1);
        CountingRpcManager rpcManager = this.replaceRpcManager(cache);
        this.cache(0).put((Object)key, (Object)"v0");
        tm.begin();
        rpcManager.resetStats();
        cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)key, (Object)"v1");
        AssertJUnit.assertEquals((String)"Wrong number of gets after put.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong value read.", (Object)"v1", (Object)cache.get((Object)key));
        AssertJUnit.assertEquals((String)"Wrong number of gets after read.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong put return value.", (Object)"v1", (Object)cache.put((Object)key, (Object)"v2"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after put.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong replace return value.", (Object)"v2", (Object)cache.replace((Object)key, (Object)"v3"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after replace.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional replace return value.", (boolean)true, (boolean)cache.replace((Object)key, (Object)"v3", (Object)"v4"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional replace.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional remove return value.", (boolean)true, (boolean)cache.remove((Object)key, (Object)"v4"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional remove.", (int)0, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional put return value.", null, (Object)cache.putIfAbsent((Object)key, (Object)"v5"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional put.", (int)0, (int)rpcManager.clusterGet);
        tm.commit();
    }

    private void doTest(boolean initialized) throws Exception {
        MagicKey key = new MagicKey("key", this.cache(0));
        Cache cache = this.cache(1);
        TransactionManager tm = this.tm(1);
        CountingRpcManager rpcManager = this.replaceRpcManager(cache);
        if (initialized) {
            this.cache(0).put((Object)key, (Object)"v1");
        }
        tm.begin();
        rpcManager.resetStats();
        AssertJUnit.assertEquals((String)"Wrong value read.", (Object)(initialized ? "v1" : null), (Object)cache.get((Object)key));
        AssertJUnit.assertEquals((String)"Wrong number of gets after read.", (int)1, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong put return value.", (Object)(initialized ? "v1" : null), (Object)cache.put((Object)key, (Object)"v2"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after put.", (int)1, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong replace return value.", (Object)"v2", (Object)cache.replace((Object)key, (Object)"v3"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after replace.", (int)1, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional replace return value.", (boolean)true, (boolean)cache.replace((Object)key, (Object)"v3", (Object)"v4"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional replace.", (int)1, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional remove return value.", (boolean)true, (boolean)cache.remove((Object)key, (Object)"v4"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional remove.", (int)1, (int)rpcManager.clusterGet);
        AssertJUnit.assertEquals((String)"Wrong conditional put return value.", null, (Object)cache.putIfAbsent((Object)key, (Object)"v5"));
        AssertJUnit.assertEquals((String)"Wrong number of gets after conditional put.", (int)1, (int)rpcManager.clusterGet);
        tm.commit();
    }

    private CountingRpcManager replaceRpcManager(Cache cache) {
        RpcManager current = TestingUtil.extractComponent(cache, RpcManager.class);
        if (current instanceof CountingRpcManager) {
            return (CountingRpcManager)current;
        }
        CountingRpcManager countingRpcManager = new CountingRpcManager(current);
        TestingUtil.replaceComponent(cache, RpcManager.class, countingRpcManager, true);
        return countingRpcManager;
    }
}

