/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.function.BiConsumer;
import org.infinispan.Cache;
import org.infinispan.api.APINonTxTest;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.CustomInterceptorConfigTest;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.Stats;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.SimpleCacheTest")
public class SimpleCacheTest
extends APINonTxTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.simpleCache(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cb);
        this.cache = AbstractDelegatingCache.unwrapCache((Cache)cm.getCache());
        AssertJUnit.assertTrue((boolean)(this.cache instanceof SimpleCacheImpl));
        return cm;
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testAddInterceptor() {
        this.cache().getAdvancedCache().getAsyncInterceptorChain().addInterceptor((AsyncInterceptor)new CustomInterceptorConfigTest.DummyInterceptor(), 0);
    }

    public void testFindInterceptor() {
        AsyncInterceptorChain interceptorChain = this.cache().getAdvancedCache().getAsyncInterceptorChain();
        AssertJUnit.assertNotNull((Object)interceptorChain);
        AssertJUnit.assertNull((Object)interceptorChain.findInterceptorExtending(InvocationContextInterceptor.class));
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testTransactions() {
        new ConfigurationBuilder().simpleCache(true).transaction().transactionMode(TransactionMode.TRANSACTIONAL).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testCustomInterceptors() {
        new ConfigurationBuilder().simpleCache(true).customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new BaseCustomAsyncInterceptor()).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testBatching() {
        new ConfigurationBuilder().simpleCache(true).invocationBatching().enable(true).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000381: This configuration is not supported for simple cache")
    public void testIndexing() {
        new ConfigurationBuilder().simpleCache(true).indexing().enable().build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testStoreAsBinary() {
        new ConfigurationBuilder().simpleCache(true).memory().storageType(StorageType.BINARY).build();
    }

    @Override
    @Test(dataProvider="lockedStreamActuallyLocks", expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamActuallyLocks(BiConsumer<Cache<Object, Object>, CacheEntry<Object, Object>> consumer, boolean forEachOrInvokeAll) throws Throwable {
        super.testLockedStreamActuallyLocks(consumer, forEachOrInvokeAll);
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamSetValue() {
        super.testLockedStreamSetValue();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamWithinLockedStream() {
        super.testLockedStreamWithinLockedStream();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamInvokeAllFilteredSet() {
        super.testLockedStreamInvokeAllFilteredSet();
    }

    @Override
    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void testLockedStreamInvokeAllPut() {
        super.testLockedStreamInvokeAllPut();
    }

    public void testStatistics() {
        Configuration cfg = new ConfigurationBuilder().simpleCache(true).jmxStatistics().enabled(true).build();
        String name = "statsCache";
        this.cacheManager.defineConfiguration(name, cfg);
        Cache cache = this.cacheManager.getCache(name);
        AssertJUnit.assertEquals((long)0L, (long)cache.getAdvancedCache().getStats().getStores());
        cache.put((Object)"key", (Object)"value");
        AssertJUnit.assertEquals((long)1L, (long)cache.getAdvancedCache().getStats().getStores());
    }

    public void testEvictionWithStatistics() {
        int KEY_COUNT = 5;
        Configuration cfg = new ConfigurationBuilder().simpleCache(true).memory().size(1L).jmxStatistics().enable().build();
        String name = "evictionCache";
        this.cacheManager.defineConfiguration(name, cfg);
        Cache cache = this.cacheManager.getCache(name);
        for (int i = 0; i < KEY_COUNT; ++i) {
            cache.put((Object)("key" + i), (Object)"value");
        }
        Stats stats = cache.getAdvancedCache().getStats();
        AssertJUnit.assertEquals((int)1, (int)stats.getCurrentNumberOfEntriesInMemory());
        AssertJUnit.assertEquals((long)KEY_COUNT, (long)stats.getStores());
        AssertJUnit.assertEquals((long)(KEY_COUNT - 1), (long)stats.getEvictions());
    }
}

