/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import java.lang.reflect.Method;
import java.util.concurrent.Future;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction", "smoke"})
public abstract class AbstractBatchTest
extends SingleCacheManagerTest {
    @Override
    public EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager(false);
    }

    public void testClearInBatch(Method method) {
        Cache cache = this.createCache(method.getName());
        cache.put((Object)"k2", (Object)"v2");
        cache.startBatch();
        cache.clear();
        cache.put((Object)"k1", (Object)"v1");
        cache.endBatch(true);
        AssertJUnit.assertEquals(null, (String)((String)cache.get((Object)"k2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
    }

    public void testPutForExternalReadInBatch(Method method) {
        Cache cache = this.createCache(method.getName());
        cache.startBatch();
        cache.putForExternalRead((Object)"k1", (Object)"v1");
        cache.put((Object)"k2", (Object)"v2");
        cache.endBatch(true);
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
        cache.startBatch();
        cache.putForExternalRead((Object)"k3", (Object)"v3");
        cache.put((Object)"k1", (Object)"v2");
        cache.endBatch(false);
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)cache.get((Object)"k3")));
    }

    String getOnDifferentThread(Cache<String, String> cache, String key) throws Exception {
        Future<String> f = this.fork(() -> {
            cache.startBatch();
            String v = (String)cache.get((Object)key);
            cache.endBatch(true);
            return v;
        });
        return f.get();
    }

    void assertNoTransaction(TransactionManager transactionManager) throws SystemException {
        AssertJUnit.assertNull((String)"Should have no ongoing txs", (Object)transactionManager.getTransaction());
    }

    protected abstract <K, V> Cache<K, V> createCache(String var1);
}

