/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.batch;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.api.batch.AbstractBatchTest;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "transaction"}, testName="api.batch.BatchWithCustomTMTest")
public class BatchWithCustomTMTest
extends AbstractBatchTest {
    public void testBatchWithOngoingTM(Method method) throws Exception {
        Cache cache = this.createCache(method.getName());
        TransactionManager tm = TestingUtil.getTransactionManager(cache);
        AssertJUnit.assertEquals(MyDummyTransactionManager.class, tm.getClass());
        tm.begin();
        cache.put((Object)"k", (Object)"v");
        cache.startBatch();
        cache.put((Object)"k2", (Object)"v2");
        tm.commit();
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
        cache.endBatch(false);
        AssertJUnit.assertEquals((String)"v", (String)((String)cache.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cache.get((Object)"k2")));
    }

    public void testBatchWithoutOngoingTMSuspension(Method method) throws Exception {
        Cache cache = this.createCache(method.getName());
        TransactionManager tm = TestingUtil.getTransactionManager(cache);
        AssertJUnit.assertEquals(MyDummyTransactionManager.class, tm.getClass());
        this.assertNoTransaction(tm);
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        this.assertNoTransaction(tm);
        cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
        Exceptions.expectException(IllegalStateException.class, () -> ((TransactionManager)tm).commit());
        this.assertNoTransaction(tm);
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
        cache.endBatch(true);
        AssertJUnit.assertEquals((String)"v", (String)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertEquals((String)"v2", (String)this.getOnDifferentThread(cache, "k2"));
    }

    public void testBatchRollback(Method method) throws Exception {
        Cache cache = this.createCache(method.getName());
        cache.startBatch();
        cache.put((Object)"k", (Object)"v");
        cache.put((Object)"k2", (Object)"v2");
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
        cache.endBatch(false);
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k"));
        AssertJUnit.assertNull((Object)this.getOnDifferentThread(cache, "k2"));
    }

    @Override
    protected <K, V> Cache<K, V> createCache(String name) {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.transaction().transactionManagerLookup((TransactionManagerLookup)new MyDummyTransactionManagerLookup());
        c.invocationBatching().enable();
        c.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.cacheManager.defineConfiguration(name, c.build());
        return this.cacheManager.getCache(name);
    }

    static class MyDummyTransactionManager
    extends EmbeddedBaseTransactionManager {
        MyDummyTransactionManager() {
        }
    }

    static class MyDummyTransactionManagerLookup
    extends EmbeddedTransactionManagerLookup {
        MyDummyTransactionManager tm = new MyDummyTransactionManager();

        MyDummyTransactionManagerLookup() {
        }

        public TransactionManager getTransactionManager() {
            return this.tm;
        }
    }
}

