/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.lang.reflect.Method;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.FlagsEnabledTest")
@CleanupAfterMethod
public class FlagsEnabledTest
extends MultipleCacheManagersTest {
    protected final String cacheName;

    public FlagsEnabledTest() {
        this("tx-replication");
    }

    protected FlagsEnabledTest(String cacheName) {
        this.cacheName = cacheName;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = FlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.createClusteredCaches(2, this.cacheName, TestDataSCI.INSTANCE, builder);
    }

    DummyInMemoryStore getCacheStore(Cache cache) {
        return (DummyInMemoryStore)TestingUtil.getFirstStore(cache);
    }

    public void testWithFlagsSemantics() {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        AssertJUnit.assertNotSame((String)"CacheStores", (Object)this.getCacheStore((Cache)cache1), (Object)this.getCacheStore((Cache)cache2));
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        AdvancedCache cache1LocalOnly = cache1.withFlags(Flag.CACHE_MODE_LOCAL);
        MagicKey localKey = new MagicKey("local", (Cache<?, ?>)cache1);
        cache1LocalOnly.put((Object)localKey, (Object)"value1");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 1, (Cache<?, ?>)cache2, 0);
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)localKey, (Object)"value2");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 1);
        this.assertCacheValue((Cache<?, ?>)cache1, localKey, "value1");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        this.assertCacheValue((Cache<?, ?>)cache2, localKey, "value2");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        MagicKey nonLocalKey = new MagicKey("nonLocal", (Cache<?, ?>)cache2);
        cache1.put((Object)nonLocalKey, (Object)"value");
        int cache1Loads = this.isTxCache() ? 1 : 0;
        this.assertLoadsAndReset((Cache<?, ?>)cache1, cache1Loads, (Cache<?, ?>)cache2, 1);
        this.assertCacheValue((Cache<?, ?>)cache2, nonLocalKey, "value");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        AdvancedCache cache1SkipRemoteAndStores = cache1LocalOnly.withFlags(Flag.SKIP_CACHE_LOAD);
        MagicKey localKey2 = new MagicKey("local2", (Cache<?, ?>)cache1);
        cache1SkipRemoteAndStores.put((Object)localKey2, (Object)"value");
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        this.assertCacheValue((Cache<?, ?>)cache1, localKey2, "value");
        this.assertCacheValue((Cache<?, ?>)cache2, localKey2, null);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 1);
        this.assertCacheValue((Cache<?, ?>)cache2, localKey2, null);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 1);
        this.assertCacheValue((Cache<?, ?>)cache2.withFlags(Flag.SKIP_CACHE_LOAD), localKey2, null);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        MagicKey localKey3 = new MagicKey("local3", (Cache<?, ?>)cache1);
        this.assertCacheValue((Cache<?, ?>)cache1LocalOnly, localKey3, null);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 1, (Cache<?, ?>)cache2, 0);
    }

    public void testWithFlagsAndDelegateCache() {
        CustomDelegateCache c1 = new CustomDelegateCache(this.advancedCache(0, this.cacheName));
        AdvancedCache c2 = this.advancedCache(1, this.cacheName);
        c1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)1, (Object)"v1");
        this.assertCacheValue((Cache<?, ?>)c2, 1, null);
    }

    public void testReplicateSkipCacheLoad(Method m) {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        String v = TestingUtil.v(m, 1);
        Object k = this.getKeyForCache(0, this.cacheName);
        cache1.withFlags(Flag.SKIP_CACHE_LOAD).put(k, (Object)v);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, this.isTxCache() ? 1 : 0, (Cache<?, ?>)cache2, 0);
        this.assertCacheValue((Cache<?, ?>)cache2, k, v);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
    }

    public void testReplicateSkipCacheLoaderWithinTxInCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        this.doReplicateSkipCacheLoaderWithinTx(m, cache1, cache2);
    }

    public void testReplicateSkipCacheLoaderWithinTxInNonCoordinator(Method m) throws Exception {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        this.doReplicateSkipCacheLoaderWithinTx(m, cache2, cache1);
    }

    public void testCacheLocalInPrimaryOwner() {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        MagicKey key = new MagicKey("k-po", (Cache<?, ?>)cache1);
        cache1.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, (Object)"value");
        this.assertCacheValue((Cache<?, ?>)cache1, key, "value");
        this.assertCacheValue((Cache<?, ?>)cache2, key, null);
    }

    public void testCacheLocalInBackupOwner() {
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        MagicKey key = new MagicKey("k-bo", (Cache<?, ?>)cache1);
        cache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, (Object)"value");
        this.assertCacheValue((Cache<?, ?>)cache2, key, "value");
        this.assertCacheValue((Cache<?, ?>)cache1, key, null);
    }

    private void doReplicateSkipCacheLoaderWithinTx(Method m, AdvancedCache<String, String> cache1, AdvancedCache<String, String> cache2) throws Exception {
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
        String v = TestingUtil.v(m, 1);
        String k = TestingUtil.k(m, 1);
        TestingUtil.withTx(cache1.getTransactionManager(), () -> {
            cache1.withFlags(Flag.SKIP_CACHE_LOAD).put((Object)k, (Object)v);
            return null;
        });
        this.assertLoadsAndReset((Cache<?, ?>)cache1, this.isPrimaryOwner((Cache<?, ?>)cache1, k) ? 1 : 0, (Cache<?, ?>)cache2, this.isPrimaryOwner((Cache<?, ?>)cache2, k) ? 1 : 0);
        this.assertCacheValue((Cache<?, ?>)cache2, k, v);
        this.assertLoadsAndReset((Cache<?, ?>)cache1, 0, (Cache<?, ?>)cache2, 0);
    }

    private void assertLoadsAndReset(Cache<?, ?> cache1, int expected1, Cache<?, ?> cache2, int expected2) {
        DummyInMemoryStore store1 = this.getCacheStore(cache1);
        DummyInMemoryStore store2 = this.getCacheStore(cache2);
        AssertJUnit.assertEquals((int)expected1, (int)store1.stats().get("load"));
        AssertJUnit.assertEquals((int)expected2, (int)store2.stats().get("load"));
        store1.clearStats();
        store2.clearStats();
    }

    protected final void assertCacheValue(Cache<?, ?> cache, Object key, Object value) {
        AssertJUnit.assertEquals((String)("Wrong value for key '" + key + "' in cache '" + cache + "'."), (Object)value, (Object)cache.get(key));
    }

    private boolean isPrimaryOwner(Cache<?, ?> cache, Object key) {
        return TestingUtil.extractComponent(cache, ClusteringDependentLogic.class).getCacheTopology().getDistribution(key).isPrimary();
    }

    private boolean isTxCache() {
        return this.advancedCache(0, this.cacheName).getCacheConfiguration().transaction().transactionMode().isTransactional();
    }

    public static class CustomDelegateCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        public CustomDelegateCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        public AdvancedCache rewrap(AdvancedCache newDelegate) {
            return new CustomDelegateCache<K, V>(newDelegate);
        }
    }
}

