/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.lang.reflect.Method;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.flags.FlagsEnabledTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.UnnecessaryLoadingTest;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.NonTxFlagsEnabledTest")
@CleanupAfterMethod
public class NonTxFlagsEnabledTest
extends FlagsEnabledTest {
    public NonTxFlagsEnabledTest() {
        super("non-tx-replication");
    }

    @Override
    @Test(enabled=false, description="non transactional cache")
    public void testReplicateSkipCacheLoaderWithinTxInCoordinator(Method m) throws Exception {
    }

    @Override
    @Test(enabled=false, description="non transactional cache")
    public void testReplicateSkipCacheLoaderWithinTxInNonCoordinator(Method m) throws Exception {
    }

    public void testCacheLocalInNonOwner() {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE);
        cm.createCache(this.cacheName, this.getConfigurationBuilder().build());
        this.waitForClusterToForm(this.cacheName);
        AdvancedCache cache1 = this.advancedCache(0, this.cacheName);
        AdvancedCache cache2 = this.advancedCache(1, this.cacheName);
        AdvancedCache cache3 = this.advancedCache(2, this.cacheName);
        MagicKey key = new MagicKey("k-no", (Cache<?, ?>)cache1);
        cache3.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, (Object)"value");
        this.assertCacheValue((Cache<?, ?>)cache3, key, "value");
        this.assertCacheValue((Cache<?, ?>)cache1, key, null);
        this.assertCacheValue((Cache<?, ?>)cache2, key, null);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NonTxFlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.createClusteredCaches(2, this.cacheName, TestDataSCI.INSTANCE, builder);
    }

    private ConfigurationBuilder getConfigurationBuilder() {
        ConfigurationBuilder builder = NonTxFlagsEnabledTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        ((UnnecessaryLoadingTest.CountingStoreConfigurationBuilder)builder.persistence().addStore(UnnecessaryLoadingTest.CountingStoreConfigurationBuilder.class)).persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        return builder;
    }
}

