/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.concurrent.locks.impl.LockContainer;
import org.testng.annotations.Test;

@Test(groups={"functional"}, singleThreaded=true, testName="api.mvcc.LockPerEntryTest")
public class LockPerEntryTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.locking().useLockStriping(false);
        return TestCacheManagerFactory.createCacheManager(cfg);
    }

    public void testLocksCleanedUp() {
        this.cache = this.cacheManager.getCache();
        this.cache.put((Object)"/a/b/c", (Object)"v");
        this.cache.put((Object)"/a/b/d", (Object)"v");
        this.assertNoLocks();
    }

    public void testLocksConcurrency() throws Exception {
        this.cache = this.cacheManager.getCache();
        int NUM_THREADS = 10;
        final CountDownLatch l = new CountDownLatch(1);
        int numLoops = 1000;
        final LinkedList exceptions = new LinkedList();
        Thread[] t = new Thread[10];
        for (int i = 0; i < 10; ++i) {
            t[i] = new Thread(){

                @Override
                public void run() {
                    try {
                        l.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (int i = 0; i < 1000; ++i) {
                        try {
                            switch (i % 2) {
                                case 0: {
                                    LockPerEntryTest.this.cache.put((Object)("Key" + i), (Object)"v");
                                    break;
                                }
                                case 1: {
                                    LockPerEntryTest.this.cache.remove((Object)("Key" + i));
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                    }
                }
            };
        }
        for (Thread th : t) {
            th.start();
        }
        l.countDown();
        for (Thread th : t) {
            th.join();
        }
        if (!exceptions.isEmpty()) {
            throw (Exception)exceptions.get(0);
        }
        this.assertNoLocks();
    }

    private void assertNoLocks() {
        LockManager lm = TestingUtil.extractLockManager(this.cache);
        LockAssert.assertNoLocks(lm);
        LockContainer lc = (LockContainer)TestingUtil.extractField(lm, "lockContainer");
        assert (lc.size() == 0);
    }
}

