/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc;

import java.util.function.Consumer;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.PutForExternalReadLockCleanupTest")
@CleanupAfterMethod
public class PutForExternalReadLockCleanupTest
extends MultipleCacheManagersTest {
    private static final String VALUE = "v";
    private static final Consumer<ConfigurationBuilder> ENABLE_L1 = c -> c.clustering().l1().enable();
    private String name;
    private Consumer<ConfigurationBuilder> amendConfiguration;

    @Override
    public Object[] factory() {
        return new Object[]{new PutForExternalReadLockCleanupTest("NonTx").transactional(false), new PutForExternalReadLockCleanupTest("Optimistic").transactional(true).lockingMode(LockingMode.OPTIMISTIC), new PutForExternalReadLockCleanupTest("Pessimistic").transactional(true).lockingMode(LockingMode.PESSIMISTIC), new PutForExternalReadLockCleanupTest("NonTxL1", ENABLE_L1).transactional(false), new PutForExternalReadLockCleanupTest("OptimisticL1", ENABLE_L1).transactional(true).lockingMode(LockingMode.OPTIMISTIC), new PutForExternalReadLockCleanupTest("PessimisticL1", ENABLE_L1).transactional(true).lockingMode(LockingMode.PESSIMISTIC)};
    }

    public PutForExternalReadLockCleanupTest() {
    }

    private PutForExternalReadLockCleanupTest(String name) {
        this(name, c -> {});
    }

    private PutForExternalReadLockCleanupTest(String name, Consumer<ConfigurationBuilder> amendConfiguration) {
        this.name = name;
        this.amendConfiguration = amendConfiguration;
    }

    @Override
    protected String parameters() {
        return "[" + this.name + "]";
    }

    public void testLockCleanupOnBackup() {
        this.doTest(false);
    }

    public void testLockCleanuponOwner() {
        this.doTest(true);
    }

    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder c = PutForExternalReadLockCleanupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, this.transactional);
        c.clustering().hash().numSegments(10).numOwners(1);
        c.clustering().l1().disable();
        this.amendConfiguration.accept(c);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, c);
    }

    private void doTest(boolean owner) {
        Cache cache1 = this.cache(0);
        Cache cache2 = this.cache(1);
        MagicKey magicKey = new MagicKey(cache1);
        if (owner) {
            cache1.putForExternalRead((Object)magicKey, (Object)VALUE);
        } else {
            cache2.putForExternalRead((Object)magicKey, (Object)VALUE);
        }
        this.eventually(() -> cache1.containsKey((Object)magicKey) && cache2.containsKey((Object)magicKey));
        AssertJUnit.assertEquals((String)VALUE, (String)((String)cache1.get((Object)magicKey)));
        AssertJUnit.assertEquals((String)VALUE, (String)((String)cache2.get((Object)magicKey)));
        this.assertNotLocked(magicKey);
    }
}

