/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.read_committed;

import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockTestBase;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.read_committed.ReadCommittedLockTest")
public class ReadCommittedLockTest
extends LockTestBase {
    public ReadCommittedLockTest() {
        this.repeatableRead = false;
    }

    public void testVisibilityOfCommittedDataPut() throws Exception {
        Cache<String, String> c = this.lockTestData.cache;
        c.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        this.lockTestData.tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        Transaction reader = this.lockTestData.tm.suspend();
        this.lockTestData.tm.begin();
        c.put((Object)"k", (Object)"v2");
        Transaction writer = this.lockTestData.tm.suspend();
        this.lockTestData.tm.resume(reader);
        AssertJUnit.assertEquals((String)"Should not read uncommitted data", (String)"v", (String)((String)c.get((Object)"k")));
        reader = this.lockTestData.tm.suspend();
        this.lockTestData.tm.resume(writer);
        this.lockTestData.tm.commit();
        this.lockTestData.tm.resume(reader);
        AssertJUnit.assertEquals((String)"Should read committed data", (String)"v2", (String)((String)c.get((Object)"k")));
        this.lockTestData.tm.commit();
    }

    public void testVisibilityOfCommittedDataReplace() throws Exception {
        Cache<String, String> c = this.lockTestData.cache;
        c.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        this.lockTestData.tm.begin();
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        AssertJUnit.assertEquals((String)"v", (String)((String)c.get((Object)"k")));
        Transaction reader = this.lockTestData.tm.suspend();
        this.lockTestData.tm.begin();
        c.replace((Object)"k", (Object)"v2");
        Transaction writer = this.lockTestData.tm.suspend();
        this.lockTestData.tm.resume(reader);
        AssertJUnit.assertEquals((String)"Should not read uncommitted data", (String)"v", (String)((String)c.get((Object)"k")));
        reader = this.lockTestData.tm.suspend();
        this.lockTestData.tm.resume(writer);
        this.lockTestData.tm.commit();
        this.lockTestData.tm.resume(reader);
        AssertJUnit.assertEquals((String)"Should read committed data", (String)"v2", (String)((String)c.get((Object)"k")));
        this.lockTestData.tm.commit();
    }

    @Override
    public void testConcurrentWriters() throws Exception {
        super.testConcurrentWriters();
    }
}

