/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.mvcc.repeatable_read;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.api.mvcc.LockAssert;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.mvcc.repeatable_read.WriteSkewTest")
public class WriteSkewTest
extends AbstractInfinispanTest {
    private static final Log log = LogFactory.getLog(WriteSkewTest.class);
    protected TransactionManager tm;
    protected LockManager lockManager;
    protected EmbeddedCacheManager cacheManager;
    protected volatile Cache<String, String> cache;

    @BeforeClass
    public void setUp() {
        ConfigurationBuilder configurationBuilder = this.createConfigurationBuilder();
        configurationBuilder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.cacheManager = TestCacheManagerFactory.createCacheManager(configurationBuilder);
        configurationBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        configurationBuilder.clustering().hash().groups().enabled();
        this.cacheManager.defineConfiguration("writeSkew", configurationBuilder.build());
    }

    protected ConfigurationBuilder createConfigurationBuilder() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).isolationLevel(IsolationLevel.REPEATABLE_READ);
        return configurationBuilder;
    }

    @AfterClass
    public void tearDown() {
        TestingUtil.killCacheManagers(this.cacheManager);
        this.cacheManager = null;
        this.cache = null;
        this.lockManager = null;
        this.tm = null;
    }

    @BeforeMethod
    public void postStart() {
        this.cache = this.cacheManager.getCache("writeSkew");
        this.lockManager = (LockManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(LockManager.class);
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(TransactionManager.class);
    }

    protected void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.tm.commit();
    }

    protected void assertNoLocks() {
        LockAssert.assertNoLocks(this.lockManager);
    }

    public void testDontCheckWriteSkew() throws Exception {
        this.cache = this.cacheManager.getCache();
        this.lockManager = (LockManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(LockManager.class);
        this.tm = (TransactionManager)TestingUtil.extractComponentRegistry(this.cache).getComponent(TransactionManager.class);
        this.doTest(true);
    }

    public void testCheckWriteSkew() throws Exception {
        this.doTest(false);
    }

    public void testCheckWriteSkewWithMultipleModifications() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        Future<Void> t1 = this.fork(() -> {
            latch1.await();
            this.tm.begin();
            try {
                try {
                    this.cache.get((Object)"k1");
                    this.cache.put((Object)"k1", (Object)"v1");
                    this.cache.put((Object)"k2", (Object)"thread 1");
                }
                finally {
                    latch2.countDown();
                }
                latch3.await();
                Exceptions.expectException(RollbackException.class, this::commit);
            }
            catch (Exception e) {
                log.error((Object)"Unexpected exception in transaction 1", (Throwable)e);
                this.tm.rollback();
            }
            return null;
        });
        Future<Void> t2 = this.fork(() -> {
            latch2.await();
            this.tm.begin();
            try {
                try {
                    this.cache.get((Object)"k1");
                    this.cache.put((Object)"k1", (Object)"v2");
                    this.cache.put((Object)"k3", (Object)"thread 2");
                    this.commit();
                }
                finally {
                    latch3.countDown();
                }
            }
            catch (Exception e) {
                if (this.tm.getTransaction() != null) {
                    try {
                        this.tm.rollback();
                    }
                    catch (SystemException e1) {
                        log.error((Object)"Failed to rollback", (Throwable)e1);
                    }
                }
                throw e;
            }
            return null;
        });
        latch1.countDown();
        t1.get(10L, TimeUnit.SECONDS);
        t2.get(10L, TimeUnit.SECONDS);
        AssertJUnit.assertTrue((String)"k1 is expected to be in cache.", (boolean)this.cache.containsKey((Object)"k1"));
        AssertJUnit.assertEquals((String)"Wrong value for key k1.", (String)"v2", (String)((String)this.cache.get((Object)"k1")));
    }

    public void testNoWriteSkewWithMultipleModifications() throws Exception {
        this.cache.put((Object)"k1", (Object)"init");
        this.tm.begin();
        AssertJUnit.assertEquals((String)"init", (String)((String)this.cache.get((Object)"k1")));
        this.cache.put((Object)"k1", (Object)"v2");
        this.cache.put((Object)"k2", (Object)"v3");
        this.commit();
    }

    public void testDontFailOnImmediateRemoval() throws Exception {
        String key = "testDontOnImmediateRemoval-Key";
        this.tm.begin();
        this.cache.put((Object)"testDontOnImmediateRemoval-Key", (Object)"testDontOnImmediateRemoval-Value");
        AssertJUnit.assertEquals((String)"Wrong value for key testDontOnImmediateRemoval-Key", (String)"testDontOnImmediateRemoval-Value", (String)((String)this.cache.get((Object)"testDontOnImmediateRemoval-Key")));
        this.cache.put((Object)"testDontOnImmediateRemoval-Key", (Object)"testDontOnImmediateRemoval-Value-Second");
        this.cache.remove((Object)"testDontOnImmediateRemoval-Key");
        this.commit();
        AssertJUnit.assertFalse((String)"Key testDontOnImmediateRemoval-Key was not removed as expected.", (boolean)this.cache.containsKey((Object)"testDontOnImmediateRemoval-Key"));
    }

    public void testNoWriteSkew() throws Exception {
        String key = "k";
        this.tm.begin();
        try {
            this.cache.put((Object)"k", (Object)"init");
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.commit();
            } else {
                this.tm.rollback();
            }
        }
        AdvancedCache putCache = this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES);
        this.tm.begin();
        putCache.put((Object)"k", (Object)"v1");
        Transaction tx1 = this.tm.suspend();
        this.tm.begin();
        putCache.put((Object)"k", (Object)"v2");
        Transaction tx2 = this.tm.suspend();
        this.tm.begin();
        putCache.put((Object)"k", (Object)"v3");
        Transaction tx3 = this.tm.suspend();
        this.tm.resume(tx1);
        this.commit();
        this.tm.resume(tx2);
        this.commit();
        this.tm.resume(tx3);
        this.commit();
    }

    public void testWriteSkew() throws Exception {
        String key = "k";
        this.tm.begin();
        try {
            this.cache.put((Object)"k", (Object)"init");
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.commit();
            } else {
                this.tm.rollback();
            }
        }
        this.tm.begin();
        this.cache.put((Object)"k", (Object)"v1");
        Transaction tx1 = this.tm.suspend();
        this.tm.begin();
        this.cache.put((Object)"k", (Object)"v2");
        Transaction tx2 = this.tm.suspend();
        this.tm.begin();
        this.cache.put((Object)"k", (Object)"v3");
        Transaction tx3 = this.tm.suspend();
        this.tm.resume(tx1);
        this.commit();
        try {
            this.tm.resume(tx2);
            this.commit();
            AssertJUnit.fail((String)"Transaction should fail!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        try {
            this.tm.resume(tx3);
            this.commit();
            AssertJUnit.fail((String)"Transaction should fail!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    public void testPreviousValueIgnored() throws Exception {
        this.cache.put((Object)"k", (Object)"init");
        this.tm.begin();
        this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)"k", (Object)"v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.cache.put((Object)"k", (Object)"v2")));
        Transaction tx = this.tm.suspend();
        AssertJUnit.assertEquals((String)"init", (String)((String)this.cache.put((Object)"k", (Object)"other")));
        this.tm.resume(tx);
        this.commit();
    }

    public void testWriteSkewWithOnlyPut() throws Exception {
        this.tm.begin();
        try {
            this.cache.put((Object)"k", (Object)"init");
        }
        catch (Exception e) {
            this.tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (this.tm.getStatus() == 0) {
                this.commit();
            } else {
                this.tm.rollback();
            }
        }
        int nbWriters = 10;
        CyclicBarrier barrier = new CyclicBarrier(nbWriters + 1);
        ArrayList<Future> futures = new ArrayList<Future>(nbWriters);
        for (int i = 0; i < nbWriters; ++i) {
            log.debug((Object)"Schedule execution");
            Future future = this.fork(new EntryWriter(barrier));
            futures.add(future);
        }
        barrier.await();
        barrier.await();
        log.debug((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
        for (Future future : futures) {
            future.get();
        }
    }

    private void doTest(boolean disabledWriteSkewCheck) throws Exception {
        String key = "k";
        CountDownLatch w1Signal = new CountDownLatch(1);
        CountDownLatch w2Signal = new CountDownLatch(1);
        CountDownLatch threadSignal = new CountDownLatch(2);
        this.cache.put((Object)"k", (Object)"v");
        Future<Void> w1 = this.fork(() -> {
            this.tm.begin();
            AssertJUnit.assertEquals((String)"Wrong value in Writer-1 for key k.", (String)"v", (String)((String)this.cache.get((Object)"k")));
            threadSignal.countDown();
            w1Signal.await();
            this.cache.put((Object)"k", (Object)"v2");
            this.commit();
            return null;
        });
        Future<Void> w2 = this.fork(() -> {
            this.tm.begin();
            AssertJUnit.assertEquals((String)"Wrong value in Writer-2 for key k.", (String)"v", (String)((String)this.cache.get((Object)"k")));
            threadSignal.countDown();
            w2Signal.await();
            this.cache.put((Object)"k", (Object)"v3");
            if (disabledWriteSkewCheck) {
                this.commit();
            } else {
                Exceptions.expectException(RollbackException.class, this::commit);
            }
            return null;
        });
        threadSignal.await(10L, TimeUnit.SECONDS);
        w1Signal.countDown();
        w1.get(10L, TimeUnit.SECONDS);
        w2Signal.countDown();
        w2.get(10L, TimeUnit.SECONDS);
        if (disabledWriteSkewCheck) {
            AssertJUnit.assertEquals((String)"W2 should have overwritten W1's work!", (String)"v3", (String)((String)this.cache.get((Object)"k")));
            this.assertNoLocks();
        } else {
            AssertJUnit.assertEquals((String)"W2 should *not* have overwritten W1's work!", (String)"v2", (String)((String)this.cache.get((Object)"k")));
            this.assertNoLocks();
        }
    }

    protected class EntryWriter
    implements Callable<Void> {
        private final CyclicBarrier barrier;

        EntryWriter(CyclicBarrier barrier) {
            this.barrier = barrier;
        }

        @Override
        public Void call() throws Exception {
            try {
                log.debug((Object)"Wait for all executions paths to be ready to perform calls");
                this.barrier.await();
                WriteSkewTest.this.tm.begin();
                try {
                    WriteSkewTest.this.cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).put((Object)"k", (Object)"_lockthisplease_");
                }
                catch (Exception e) {
                    log.error((Object)"Unexpected", (Throwable)e);
                    WriteSkewTest.this.tm.setRollbackOnly();
                    throw e;
                }
                finally {
                    if (WriteSkewTest.this.tm.getStatus() == 0) {
                        WriteSkewTest.this.commit();
                    } else {
                        WriteSkewTest.this.tm.rollback();
                    }
                }
                Void void_ = null;
                return void_;
            }
            finally {
                log.debug((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
        }
    }
}

