/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="commands.PutMapCommandNonTxTest")
@CleanupAfterMethod
public class PutMapCommandNonTxTest
extends MultipleCacheManagersTest {
    @Override
    public Object[] factory() {
        return new Object[]{new PutMapCommandNonTxTest().cacheMode(CacheMode.DIST_SYNC), new PutMapCommandNonTxTest().cacheMode(CacheMode.DIST_SYNC).useTriangle(false), new PutMapCommandNonTxTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.NEVER), new PutMapCommandNonTxTest().cacheMode(CacheMode.SCATTERED_SYNC).biasAcquisition(BiasAcquisition.ON_WRITE)};
    }

    @Override
    protected void createCacheManagers() {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.serialization().addContextInitializer((SerializationContextInitializer)TestDataSCI.INSTANCE);
        if (this.useTriangle == Boolean.FALSE) {
            ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        }
        ConfigurationBuilder dcc = PutMapCommandNonTxTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        if (!this.cacheMode.isScattered()) {
            dcc.clustering().hash().numOwners(3).l1().disable();
        }
        if (this.biasAcquisition != null) {
            dcc.clustering().biasAcquisition(this.biasAcquisition);
        }
        this.createCluster(gcb, dcc, 3);
        this.waitForClusterToForm();
    }

    public void testPutMapCommandSyncOnPrimaryOwner() throws Exception {
        this.testPutMapCommand(true, true);
    }

    public void testPutMapCommandAsyncOnPrimaryOwner() throws Exception {
        this.testPutMapCommand(false, true);
    }

    public void testPutMapCommandSyncOnBackupOwner() throws Exception {
        this.testPutMapCommand(true, false);
    }

    public void testPutMapCommandAsyncOnBackupOwner() throws Exception {
        this.testPutMapCommand(false, false);
    }

    private void testPutMapCommand(boolean sync, boolean putOnPrimary) throws Exception {
        MagicKey key = new MagicKey("key", this.cache(0));
        if (sync) {
            this.cache(putOnPrimary ? 0 : 1).putAll(Collections.singletonMap(key, "value"));
        } else {
            CompletableFuture f = this.cache(putOnPrimary ? 0 : 1).putAllAsync(Collections.singletonMap(key, "value"));
            AssertJUnit.assertNotNull((Object)f);
            AssertJUnit.assertNull(f.get());
            AssertJUnit.assertTrue((boolean)f.isDone());
            AssertJUnit.assertFalse((boolean)f.isCancelled());
        }
        if (this.cacheMode.isScattered()) {
            int hasValue = 0;
            for (Cache c : this.caches()) {
                Object value = c.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_OWNERSHIP_CHECK}).get((Object)key);
                if ("value".equals(value)) {
                    ++hasValue;
                    continue;
                }
                AssertJUnit.assertNull((Object)value);
            }
            AssertJUnit.assertEquals((int)2, (int)hasValue);
        } else {
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache(0).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)key));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache(1).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)key));
            AssertJUnit.assertEquals((Object)"value", (Object)this.cache(2).getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).get((Object)key));
        }
    }
}

