/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.module;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.infinispan.commands.module.TestGlobalConfigurationBuilder;
import org.infinispan.commands.module.TestGlobalConfigurationSerializer;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.AttributeCopier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.IdentityAttributeCopier;
import org.infinispan.configuration.serializing.SerializedWith;
import org.infinispan.factories.ComponentRegistry;

@SerializedWith(value=TestGlobalConfigurationSerializer.class)
@BuiltBy(value=TestGlobalConfigurationBuilder.class)
public class TestGlobalConfiguration {
    static final AttributeDefinition<Map<String, Object>> GLOBAL_TEST_COMPONENTS = AttributeDefinition.builder((String)"globalTestComponents", new HashMap()).initializer(HashMap::new).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).build();
    static final AttributeDefinition<Map<String, Map<String, Object>>> CACHE_TEST_COMPONENTS = AttributeDefinition.builder((String)"cacheTestComponents", new HashMap()).initializer(HashMap::new).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).build();
    static final AttributeDefinition<Consumer<ComponentRegistry>> CACHE_STARTING_CALLBACK = AttributeDefinition.builder((String)"cacheStartingCallback", cr -> {}).copier((AttributeCopier)IdentityAttributeCopier.identityCopier()).build();
    private final AttributeSet attributes;

    TestGlobalConfiguration(AttributeSet attributeSet) {
        this.attributes = attributeSet.checkProtection();
    }

    static AttributeSet attributeSet() {
        return new AttributeSet(TestGlobalConfiguration.class, new AttributeDefinition[]{GLOBAL_TEST_COMPONENTS, CACHE_TEST_COMPONENTS, CACHE_STARTING_CALLBACK});
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public Map<String, Object> globalTestComponents() {
        return (Map)this.attributes.attribute(GLOBAL_TEST_COMPONENTS).get();
    }

    public Map<String, Object> cacheTestComponents(String cacheName) {
        return (Map)((Map)this.attributes.attribute(CACHE_TEST_COMPONENTS).get()).get(cacheName);
    }

    public Set<String> cacheTestComponentNames() {
        return ((Map)this.attributes.attribute(CACHE_TEST_COMPONENTS).get()).values().stream().flatMap(m -> m.keySet().stream()).collect(Collectors.toSet());
    }

    public String toString() {
        return "TestGlobalConfiguration [attributes=" + this.attributes + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestGlobalConfiguration that = (TestGlobalConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public Consumer<ComponentRegistry> cacheStartCallback() {
        return (Consumer)this.attributes.attribute(CACHE_STARTING_CALLBACK).get();
    }
}

