/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.module.TestGlobalConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentAccessor;
import org.infinispan.factories.impl.DynamicModuleMetadataProvider;
import org.infinispan.factories.impl.ModuleMetadataBuilder;
import org.infinispan.factories.impl.WireContext;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ModuleLifecycle;

@InfinispanModule(name="core-tests", requiredModules={"core"}, optionalModules={"cloudevents"})
public final class TestModuleLifecycle
implements ModuleLifecycle,
DynamicModuleMetadataProvider {
    private TestGlobalConfiguration testGlobalConfiguration;

    public void registerDynamicMetadata(ModuleMetadataBuilder.ModuleBuilder moduleBuilder, GlobalConfiguration globalConfiguration) {
        this.testGlobalConfiguration = (TestGlobalConfiguration)globalConfiguration.module(TestGlobalConfiguration.class);
        if (this.testGlobalConfiguration != null) {
            HashMap<String, String> defaultFactoryNames = new HashMap<String, String>();
            ArrayList<String> componentNames = new ArrayList<String>(this.testGlobalConfiguration.globalTestComponents().keySet());
            ArrayList<String> cacheComponentNames = new ArrayList<String>(this.testGlobalConfiguration.cacheTestComponentNames());
            for (String componentName : cacheComponentNames) {
                defaultFactoryNames.put(componentName, moduleBuilder.getFactoryName(componentName));
            }
            moduleBuilder.registerComponentAccessor(TestGlobalComponentFactory.class.getName(), componentNames, (ComponentAccessor)new GlobalFactoryComponentAccessor(this.testGlobalConfiguration));
            moduleBuilder.registerComponentAccessor(TestCacheComponentFactory.class.getName(), cacheComponentNames, (ComponentAccessor)new CacheFactoryComponentAccessor(this.testGlobalConfiguration, defaultFactoryNames));
        }
    }

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalConfiguration) {
        if (this.testGlobalConfiguration == null) {
            return;
        }
        Set<String> componentNames = this.testGlobalConfiguration.globalTestComponents().keySet();
        for (String componentName : componentNames) {
            assert (this.testGlobalConfiguration.globalTestComponents().get(componentName) == gcr.getComponent(componentName));
        }
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        Map<String, Object> testCacheComponents;
        if (this.testGlobalConfiguration == null) {
            return;
        }
        if (this.testGlobalConfiguration.cacheStartCallback() != null) {
            this.testGlobalConfiguration.cacheStartCallback().accept(cr);
        }
        if ((testCacheComponents = this.testGlobalConfiguration.cacheTestComponents(cacheName)) == null) {
            return;
        }
        Set<String> componentNames = testCacheComponents.keySet();
        for (String componentName : componentNames) {
            assert (testCacheComponents.get(componentName) == cr.getComponent(componentName));
        }
    }

    private static final class CacheFactoryComponentAccessor
    extends ComponentAccessor<TestCacheComponentFactory> {
        private final TestGlobalConfiguration testGlobalConfiguration;
        private final HashMap<String, String> defaultFactoryNames;

        CacheFactoryComponentAccessor(TestGlobalConfiguration testGlobalConfiguration, HashMap<String, String> defaultFactoryNames) {
            super(TestCacheComponentFactory.class.getName(), Integer.valueOf(Scopes.NAMED_CACHE.ordinal()), true, null, Collections.emptyList());
            this.testGlobalConfiguration = testGlobalConfiguration;
            this.defaultFactoryNames = defaultFactoryNames;
        }

        protected void wire(TestCacheComponentFactory instance, WireContext context, boolean start) {
            instance.cacheComponentRegistry = (BasicComponentRegistry)context.get(BasicComponentRegistry.class.getName(), BasicComponentRegistry.class, false);
            instance.cacheName = (String)context.get("cacheName", String.class, false);
        }

        protected TestCacheComponentFactory newInstance() {
            return new TestCacheComponentFactory(this.testGlobalConfiguration, this.defaultFactoryNames);
        }
    }

    private static final class GlobalFactoryComponentAccessor
    extends ComponentAccessor<TestGlobalComponentFactory> {
        private final TestGlobalConfiguration testGlobalConfiguration;

        GlobalFactoryComponentAccessor(TestGlobalConfiguration testGlobalConfiguration) {
            super(TestGlobalComponentFactory.class.getName(), Integer.valueOf(Scopes.GLOBAL.ordinal()), true, null, Collections.emptyList());
            this.testGlobalConfiguration = testGlobalConfiguration;
        }

        protected TestGlobalComponentFactory newInstance() {
            return new TestGlobalComponentFactory(this.testGlobalConfiguration);
        }
    }

    private static final class TestCacheComponentFactory
    implements ComponentFactory {
        private final TestGlobalConfiguration testCacheConfiguration;
        private final HashMap<String, String> defaultFactoryNames;
        private String cacheName;
        private BasicComponentRegistry cacheComponentRegistry;

        TestCacheComponentFactory(TestGlobalConfiguration testCacheConfiguration, HashMap<String, String> defaultFactoryNames) {
            this.testCacheConfiguration = testCacheConfiguration;
            this.defaultFactoryNames = defaultFactoryNames;
        }

        public Object construct(String componentName) {
            Object testComponent;
            Map<String, Object> testCacheComponents = this.testCacheConfiguration.cacheTestComponents(this.cacheName);
            if (testCacheComponents != null && (testComponent = testCacheComponents.get(componentName)) != null) {
                return testComponent;
            }
            String defaultFactoryName = this.defaultFactoryNames.get(componentName);
            ComponentFactory defaultFactory = (ComponentFactory)this.cacheComponentRegistry.getComponent(defaultFactoryName, ComponentFactory.class).running();
            return defaultFactory.construct(componentName);
        }
    }

    private static final class TestGlobalComponentFactory
    implements ComponentFactory {
        private final TestGlobalConfiguration testGlobalConfiguration;

        TestGlobalComponentFactory(TestGlobalConfiguration testGlobalConfiguration) {
            this.testGlobalConfiguration = testGlobalConfiguration;
        }

        public Object construct(String componentName) {
            return this.testGlobalConfiguration.globalTestComponents().get(componentName);
        }
    }
}

