/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.ConfigurationOverrideTest")
public class ConfigurationOverrideTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cm;

    @AfterMethod
    public void stopCacheManager() {
        this.cm.stop();
    }

    public void testConfigurationOverride() throws Exception {
        ConfigurationBuilder defaultCfgBuilder = new ConfigurationBuilder();
        defaultCfgBuilder.memory().size(200L).storageType(StorageType.BINARY);
        this.cm = TestCacheManagerFactory.createCacheManager(defaultCfgBuilder);
        ConfigurationBuilder cacheCfgBuilder = new ConfigurationBuilder().read(defaultCfgBuilder.build());
        this.cm.defineConfiguration("my-cache", cacheCfgBuilder.build());
        Cache cache = this.cm.getCache("my-cache");
        AssertJUnit.assertEquals((long)200L, (long)cache.getCacheConfiguration().memory().size());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)cache.getCacheConfiguration().memory().storageType());
    }

    public void testSimpleDistributedClusterModeDefault() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numSegments(51);
        this.cm = TestCacheManagerFactory.createClusteredCacheManager(builder);
        this.cm.defineConfiguration("my-cache", builder.build());
        Cache cache = this.cm.getCache("my-cache");
        ClusteringConfiguration clusteringCfg = cache.getCacheConfiguration().clustering();
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)clusteringCfg.cacheMode());
        AssertJUnit.assertEquals((int)3, (int)clusteringCfg.hash().numOwners());
        AssertJUnit.assertEquals((int)51, (int)clusteringCfg.hash().numSegments());
    }

    public void testSimpleDistributedClusterModeNamedCache() throws Exception {
        String cacheName = "my-cache";
        Configuration config = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(3).numSegments(51).build();
        this.cm = TestCacheManagerFactory.createClusteredCacheManager();
        this.cm.defineConfiguration("my-cache", config);
        Cache cache = this.cm.getCache("my-cache");
        ClusteringConfiguration clusteringCfg = cache.getCacheConfiguration().clustering();
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)clusteringCfg.cacheMode());
        AssertJUnit.assertEquals((int)3, (int)clusteringCfg.hash().numOwners());
        AssertJUnit.assertEquals((int)51, (int)clusteringCfg.hash().numSegments());
    }

    public void testOverrideWithStore() {
        ConfigurationBuilder builder1 = new ConfigurationBuilder();
        builder1.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        this.cm = TestCacheManagerFactory.createCacheManager(builder1);
        ConfigurationBuilder builder2 = new ConfigurationBuilder();
        builder2.read(this.cm.getDefaultCacheConfiguration());
        builder2.memory().size(1000L);
        Configuration configuration = this.cm.defineConfiguration("named", builder2.build());
        AssertJUnit.assertEquals((int)1, (int)configuration.persistence().stores().size());
    }

    public void testPartialOverride() {
        ConfigurationBuilder baseBuilder = new ConfigurationBuilder();
        baseBuilder.memory().size(200L).storageType(StorageType.BINARY);
        Configuration base = baseBuilder.build();
        ConfigurationBuilder overrideBuilder = new ConfigurationBuilder();
        overrideBuilder.read(base).locking().concurrencyLevel(31);
        Configuration override = overrideBuilder.build();
        AssertJUnit.assertEquals((long)200L, (long)base.memory().size());
        AssertJUnit.assertEquals((long)200L, (long)override.memory().size());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)base.memory().storageType());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)override.memory().storageType());
        AssertJUnit.assertEquals((int)32, (int)base.locking().concurrencyLevel());
        AssertJUnit.assertEquals((int)31, (int)override.locking().concurrencyLevel());
    }

    public void testConfigurationUndefine() {
        this.cm = TestCacheManagerFactory.createCacheManager();
        this.cm.defineConfiguration("testConfig", new ConfigurationBuilder().build());
        this.cm.undefineConfiguration("testConfig");
        AssertJUnit.assertNull((Object)this.cm.getCacheConfiguration("testConfig"));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testConfigurationUndefineWhileInUse() {
        this.cm = TestCacheManagerFactory.createCacheManager();
        this.cm.defineConfiguration("testConfig", new ConfigurationBuilder().build());
        this.cm.getCache("testConfig");
        this.cm.undefineConfiguration("testConfig");
    }
}

