/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="configuration.CustomInterceptorInjectionTest")
public class CustomInterceptorInjectionTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.customInterceptors().addInterceptor().index(0).interceptor((AsyncInterceptor)new SomeAsyncInterceptor());
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testBaseCustomAsyncInterceptorInjection() {
        AsyncInterceptor interceptor = (AsyncInterceptor)this.cache.getAdvancedCache().getAsyncInterceptorChain().getInterceptors().get(0);
        AssertJUnit.assertEquals(SomeAsyncInterceptor.class, interceptor.getClass());
        SomeAsyncInterceptor someAsyncInterceptor = (SomeAsyncInterceptor)interceptor;
        AssertJUnit.assertSame((Object)this.cache.getAdvancedCache().getLockManager(), (Object)someAsyncInterceptor.lm);
        AssertJUnit.assertSame((Object)this.cache.getAdvancedCache().getDataContainer(), (Object)someAsyncInterceptor.dc);
    }

    static class SomeAsyncInterceptor
    extends BaseCustomAsyncInterceptor {
        @Inject
        LockManager lm;
        DataContainer dc;

        SomeAsyncInterceptor() {
        }

        protected void start() {
            this.dc = this.cache.getAdvancedCache().getDataContainer();
        }
    }
}

