/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.threads.AbstractThreadPoolExecutorFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.factories.threads.EnhancedQueueExecutorFactory;
import org.infinispan.interceptors.FooInterceptor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.marshall.AdvancedExternalizerTest;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfiguration;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfiguration;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.tx.TestLookup;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="configuration.XmlFileParsingTest")
public class XmlFileParsingTest
extends AbstractInfinispanTest {
    @Test(expectedExceptions={FileNotFoundException.class})
    public void testFailOnMissingConfigurationFile() throws IOException {
        new DefaultCacheManager("does-not-exist.xml");
    }

    public void testNamedCacheFile() throws IOException {
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parseFile("configs/named-cache-test.xml");
        this.assertNamedCacheFile(holder, false);
    }

    public void testNoNamedCaches() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">   <transport cluster=\"demoCluster\"/>\n   <replicated-cache name=\"default\">\n   </replicated-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        GlobalConfiguration globalCfg = holder.getGlobalConfigurationBuilder().build();
        AssertJUnit.assertTrue((boolean)(globalCfg.transport().transport() instanceof JGroupsTransport));
        AssertJUnit.assertEquals((String)"demoCluster", (String)globalCfg.transport().clusterName());
        Configuration cfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)cfg.clustering().cacheMode());
    }

    private ConfigurationBuilderHolder parseStringConfiguration(String config) {
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        ParserRegistry parserRegistry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), true, System.getProperties());
        return parserRegistry.parse((InputStream)is, null, MediaType.APPLICATION_XML);
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testDuplicateCacheNames() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"duplicatename\">   <transport cluster=\"demoCluster\"/>\n   <distributed-cache name=\"duplicatename\">\n   </distributed-cache>\n   <distributed-cache name=\"duplicatename\">\n   </distributed-cache>\n</cache-container>");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        TestCacheManagerFactory.fromStream(is);
    }

    public void testNoSchemaWithStuff() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n        <locking concurrency-level=\"10000\" isolation=\"REPEATABLE_READ\" />\n   </local-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        Configuration cfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((int)10000, (int)cfg.locking().concurrencyLevel());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)cfg.locking().isolationLevel());
    }

    public void testOffHeap() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <memory>\n        <off-heap strategy=\"MANUAL\"/>\n      </memory>\n   </local-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        Configuration cfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)StorageType.OFF_HEAP, (Object)cfg.memory().storageType());
        AssertJUnit.assertEquals((Object)EvictionStrategy.MANUAL, (Object)cfg.memory().evictionStrategy());
        config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <memory/>\n   </local-cache>\n</cache-container>");
        holder = this.parseStringConfiguration(config);
        cfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)StorageType.HEAP, (Object)cfg.memory().storageType());
        config = TestingUtil.wrapXMLWithoutSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <memory>\n         <binary/>\n      </memory>\n   </local-cache>\n</cache-container>");
        holder = this.parseStringConfiguration(config);
        cfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)cfg.memory().storageType());
    }

    public void testDummyInMemoryStore() {
        String config = TestingUtil.wrapXMLWithoutSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n<persistence >\n<store class=\"org.infinispan.persistence.dummy.DummyInMemoryStore\" >\n<property name=\"storeName\">myStore</property></store >\n</persistence >\n   </local-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        PersistenceConfiguration cfg = holder.getDefaultConfigurationBuilder().build().persistence();
        StoreConfiguration storeConfiguration = (StoreConfiguration)cfg.stores().get(0);
        AssertJUnit.assertTrue((boolean)(storeConfiguration instanceof DummyInMemoryStoreConfiguration));
        DummyInMemoryStoreConfiguration dummyInMemoryStoreConfiguration = (DummyInMemoryStoreConfiguration)storeConfiguration;
        AssertJUnit.assertEquals((String)"myStore", (String)dummyInMemoryStoreConfiguration.storeName());
    }

    public void testStoreWithNoConfigureBy() {
        String config = TestingUtil.wrapXMLWithoutSchema("<cache-container default-cache=\"default\">   <local-cache name=\"default\">\n      <persistence >\n         <store class=\"org.infinispan.configuration.XmlFileParsingTest$GenericLoader\" preload=\"true\" >\n            <property name=\"fetchState\">true</property>         </store >\n      </persistence >\n   </local-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        PersistenceConfiguration cfg = holder.getDefaultConfigurationBuilder().build().persistence();
        StoreConfiguration storeConfiguration = (StoreConfiguration)cfg.stores().get(0);
        AssertJUnit.assertTrue((boolean)(storeConfiguration instanceof AbstractStoreConfiguration));
        AbstractStoreConfiguration abstractStoreConfiguration = (AbstractStoreConfiguration)storeConfiguration;
        AssertJUnit.assertTrue((boolean)abstractStoreConfiguration.fetchPersistentState());
        AssertJUnit.assertTrue((boolean)abstractStoreConfiguration.preload());
    }

    public void testCustomTransport() {
        String config = TestingUtil.wrapXMLWithSchema("<jgroups transport=\"org.infinispan.configuration.XmlFileParsingTest$CustomTransport\"/>\n<cache-container default-cache=\"default\">\n  <transport cluster=\"ispn-perf-test\"/>\n  <distributed-cache name=\"default\"/>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        Transport transport = holder.getGlobalConfigurationBuilder().build().transport().transport();
        AssertJUnit.assertNotNull((Object)transport);
        AssertJUnit.assertTrue((boolean)(transport instanceof CustomTransport));
    }

    public void testNoDefaultCache() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container>   <transport cluster=\"demoCluster\"/>\n   <replicated-cache name=\"default\">\n   </replicated-cache>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        GlobalConfiguration globalCfg = holder.getGlobalConfigurationBuilder().build();
        AssertJUnit.assertFalse((boolean)globalCfg.defaultCacheName().isPresent());
        AssertJUnit.assertNull((Object)holder.getDefaultConfigurationBuilder());
        AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)this.getCacheConfiguration(holder, "default").clustering().cacheMode());
    }

    private Configuration getCacheConfiguration(ConfigurationBuilderHolder holder, String cacheName) {
        return ((ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(cacheName)).build();
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000432:.*")
    public void testNoDefaultCacheDeclaration() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container default-cache=\"non-existent\">   <transport cluster=\"demoCluster\"/>\n   <replicated-cache name=\"default\">\n   </replicated-cache>\n</cache-container>");
        this.parseStringConfiguration(config);
    }

    public void testNoCacheName() {
        String config = "<local-cache>\n   <expiration interval=\"10500\" lifespan=\"11\" max-idle=\"11\"/>\n</local-cache>";
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        Configuration configuration = holder.getCurrentConfigurationBuilder().build();
        AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)configuration.clustering().cacheMode());
        AssertJUnit.assertEquals((long)10500L, (long)configuration.expiration().wakeUpInterval());
        AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().lifespan());
        AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().maxIdle());
    }

    public void testWildcards() throws IOException {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container>   <local-cache-configuration name=\"wildcache*\">\n      <expiration interval=\"10500\" lifespan=\"11\" max-idle=\"11\"/>\n   </local-cache-configuration>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        try (DefaultCacheManager cm = new DefaultCacheManager(holder, false);){
            Configuration wildcache1 = cm.getCacheConfiguration("wildcache1");
            AssertJUnit.assertEquals((long)10500L, (long)wildcache1.expiration().wakeUpInterval());
            AssertJUnit.assertEquals((long)11L, (long)wildcache1.expiration().lifespan());
            AssertJUnit.assertEquals((long)11L, (long)wildcache1.expiration().maxIdle());
        }
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000485:.*")
    public void testAmbiguousWildcards() throws IOException {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container>   <local-cache-configuration name=\"wildcache*\">\n   </local-cache-configuration>\n   <local-cache-configuration name=\"wild*\">\n   </local-cache-configuration>\n</cache-container>");
        ConfigurationBuilderHolder holder = this.parseStringConfiguration(config);
        try (DefaultCacheManager cm = new DefaultCacheManager(holder, false);){
            cm.getCacheConfiguration("wildcache1");
        }
    }

    @Test(expectedExceptions={CacheConfigurationException.class}, expectedExceptionsMessageRegExp="ISPN000484:.*")
    public void testNoWildcardsInCacheName() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container>   <transport cluster=\"demoCluster\"/>\n   <replicated-cache name=\"wildcard*\">\n   </replicated-cache>\n</cache-container>");
        this.parseStringConfiguration(config);
        AssertJUnit.fail((String)"Should have failed earlier");
    }

    public void testAsyncInheritance() {
        String config = TestingUtil.wrapXMLWithSchema("<cache-container>   <transport cluster=\"demoCluster\"/>\n   <replicated-cache-configuration mode=\"ASYNC\" name=\"repl-1\">\n   </replicated-cache-configuration>\n   <replicated-cache-configuration name=\"repl-2\" configuration=\"repl-1\">\n   </replicated-cache-configuration>\n</cache-container>");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.parseStream(is, false);
        Configuration repl1 = this.getCacheConfiguration(holder, "repl-1");
        Configuration repl2 = this.getCacheConfiguration(holder, "repl-2");
        AssertJUnit.assertTrue((boolean)repl1.isTemplate());
        AssertJUnit.assertTrue((boolean)repl2.isTemplate());
        AssertJUnit.assertEquals((Object)CacheMode.REPL_ASYNC, (Object)repl1.clustering().cacheMode());
        AssertJUnit.assertEquals((Object)CacheMode.REPL_ASYNC, (Object)repl2.clustering().cacheMode());
    }

    private void assertNamedCacheFile(ConfigurationBuilderHolder holder, boolean deprecated) {
        GlobalConfiguration gc = holder.getGlobalConfigurationBuilder().build();
        EnhancedQueueExecutorFactory listenerThreadPool = (EnhancedQueueExecutorFactory)gc.listenerThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)5, (int)listenerThreadPool.maxThreads());
        AssertJUnit.assertEquals((int)10000, (int)listenerThreadPool.queueLength());
        DefaultThreadFactory listenerThreadFactory = (DefaultThreadFactory)gc.listenerThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"AsyncListenerThread", (String)listenerThreadFactory.threadNamePattern());
        AbstractThreadPoolExecutorFactory persistenceThreadPool = (AbstractThreadPoolExecutorFactory)gc.persistenceThreadPool().threadPoolFactory();
        AssertJUnit.assertNull((Object)persistenceThreadPool);
        AbstractThreadPoolExecutorFactory blockingThreadPool = (AbstractThreadPoolExecutorFactory)gc.blockingThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)6, (int)blockingThreadPool.maxThreads());
        AssertJUnit.assertEquals((int)10001, (int)blockingThreadPool.queueLength());
        DefaultThreadFactory persistenceThreadFactory = (DefaultThreadFactory)gc.blockingThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"BlockingThread", (String)persistenceThreadFactory.threadNamePattern());
        AbstractThreadPoolExecutorFactory asyncThreadPool = (AbstractThreadPoolExecutorFactory)gc.asyncThreadPool().threadPoolFactory();
        AssertJUnit.assertNull((Object)asyncThreadPool);
        AbstractThreadPoolExecutorFactory nonBlockingThreadPool = (AbstractThreadPoolExecutorFactory)gc.nonBlockingThreadPool().threadPoolFactory();
        AssertJUnit.assertEquals((int)5, (int)nonBlockingThreadPool.coreThreads());
        AssertJUnit.assertEquals((int)5, (int)nonBlockingThreadPool.maxThreads());
        AssertJUnit.assertEquals((int)10000, (int)nonBlockingThreadPool.queueLength());
        AssertJUnit.assertEquals((long)0L, (long)nonBlockingThreadPool.keepAlive());
        DefaultThreadFactory asyncThreadFactory = (DefaultThreadFactory)gc.nonBlockingThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"NonBlockingThread", (String)asyncThreadFactory.threadNamePattern());
        AbstractThreadPoolExecutorFactory transportThreadPool = (AbstractThreadPoolExecutorFactory)gc.transport().transportThreadPool().threadPoolFactory();
        AssertJUnit.assertNull((Object)transportThreadPool);
        AbstractThreadPoolExecutorFactory remoteCommandThreadPool = (AbstractThreadPoolExecutorFactory)gc.transport().remoteCommandThreadPool().threadPoolFactory();
        AssertJUnit.assertNull((Object)remoteCommandThreadPool);
        AbstractThreadPoolExecutorFactory stateTransferThreadPool = (AbstractThreadPoolExecutorFactory)gc.stateTransferThreadPool().threadPoolFactory();
        AssertJUnit.assertNull((Object)stateTransferThreadPool);
        DefaultThreadFactory evictionThreadFactory = (DefaultThreadFactory)gc.expirationThreadPool().threadFactory();
        AssertJUnit.assertEquals((String)"ExpirationThread", (String)evictionThreadFactory.threadNamePattern());
        AssertJUnit.assertTrue((boolean)(gc.transport().transport() instanceof JGroupsTransport));
        AssertJUnit.assertEquals((String)"infinispan-cluster", (String)gc.transport().clusterName());
        AssertJUnit.assertEquals((String)"Jalapeno", (String)gc.transport().nodeName());
        AssertJUnit.assertEquals((long)50000L, (long)gc.transport().distributedSyncTimeout());
        AssertJUnit.assertEquals((Object)ShutdownHookBehavior.REGISTER, (Object)gc.shutdown().hookBehavior());
        AssertJUnit.assertTrue((boolean)(gc.serialization().marshaller() instanceof TestObjectStreamMarshaller));
        Map externalizers = gc.serialization().advancedExternalizers();
        AssertJUnit.assertEquals((int)3, (int)externalizers.size());
        AssertJUnit.assertTrue((boolean)(externalizers.get(1234) instanceof AdvancedExternalizerTest.IdViaConfigObj.Externalizer));
        AssertJUnit.assertTrue((boolean)(externalizers.get(5678) instanceof AdvancedExternalizerTest.IdViaAnnotationObj.Externalizer));
        AssertJUnit.assertTrue((boolean)(externalizers.get(3456) instanceof AdvancedExternalizerTest.IdViaBothObj.Externalizer));
        Configuration defaultCfg = holder.getDefaultConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)1000L, (long)defaultCfg.locking().lockAcquisitionTimeout());
        AssertJUnit.assertEquals((int)100, (int)defaultCfg.locking().concurrencyLevel());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)defaultCfg.locking().isolationLevel());
        if (!deprecated) {
            this.assertReaperAndTimeoutInfo(defaultCfg);
        }
        Configuration c = this.getCacheConfiguration(holder, "transactional");
        AssertJUnit.assertFalse((boolean)c.clustering().cacheMode().isClustered());
        AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof GenericTransactionManagerLookup));
        if (!deprecated) {
            this.assertReaperAndTimeoutInfo(defaultCfg);
        }
        c = this.getCacheConfiguration(holder, "transactional2");
        AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof TestLookup));
        AssertJUnit.assertEquals((long)10000L, (long)c.transaction().cacheStopTimeout());
        AssertJUnit.assertEquals((Object)LockingMode.PESSIMISTIC, (Object)c.transaction().lockingMode());
        AssertJUnit.assertFalse((boolean)c.transaction().autoCommit());
        c = this.getCacheConfiguration(holder, "syncInval");
        AssertJUnit.assertEquals((Object)CacheMode.INVALIDATION_SYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((long)15000L, (long)c.clustering().remoteTimeout());
        c = this.getCacheConfiguration(holder, "asyncInval");
        AssertJUnit.assertEquals((Object)CacheMode.INVALIDATION_ASYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertEquals((long)15000L, (long)c.clustering().remoteTimeout());
        c = this.getCacheConfiguration(holder, "syncRepl");
        AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertFalse((boolean)c.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((long)15000L, (long)c.clustering().remoteTimeout());
        c = this.getCacheConfiguration(holder, "asyncRepl");
        AssertJUnit.assertEquals((Object)CacheMode.REPL_ASYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertFalse((boolean)c.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().awaitInitialTransfer());
        c = this.getCacheConfiguration(holder, "txSyncRepl");
        AssertJUnit.assertTrue((boolean)(c.transaction().transactionManagerLookup() instanceof GenericTransactionManagerLookup));
        AssertJUnit.assertEquals((Object)CacheMode.REPL_SYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertFalse((boolean)c.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().awaitInitialTransfer());
        AssertJUnit.assertEquals((long)15000L, (long)c.clustering().remoteTimeout());
        c = this.getCacheConfiguration(holder, "overriding");
        AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)c.clustering().cacheMode());
        AssertJUnit.assertEquals((long)20000L, (long)c.locking().lockAcquisitionTimeout());
        AssertJUnit.assertEquals((int)1000, (int)c.locking().concurrencyLevel());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)c.locking().isolationLevel());
        AssertJUnit.assertEquals((Object)StorageType.HEAP, (Object)c.memory().storageType());
        c = this.getCacheConfiguration(holder, "storeAsBinary");
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)c.memory().storageType());
        c = this.getCacheConfiguration(holder, "withFileStore");
        AssertJUnit.assertTrue((boolean)c.persistence().preload());
        AssertJUnit.assertFalse((boolean)c.persistence().passivation());
        AssertJUnit.assertEquals((int)1, (int)c.persistence().stores().size());
        SoftIndexFileStoreConfiguration loaderCfg = (SoftIndexFileStoreConfiguration)c.persistence().stores().get(0);
        AssertJUnit.assertTrue((boolean)loaderCfg.fetchPersistentState());
        AssertJUnit.assertFalse((boolean)loaderCfg.ignoreModifications());
        AssertJUnit.assertFalse((boolean)loaderCfg.purgeOnStartup());
        AssertJUnit.assertEquals((String)"/tmp/FileCacheStore-Location", (String)loaderCfg.dataLocation());
        AssertJUnit.assertTrue((boolean)loaderCfg.async().enabled());
        AssertJUnit.assertEquals((int)700, (int)loaderCfg.async().modificationQueueSize());
        c = this.getCacheConfiguration(holder, "withClusterLoader");
        AssertJUnit.assertEquals((int)1, (int)c.persistence().stores().size());
        ClusterLoaderConfiguration clusterLoaderCfg = (ClusterLoaderConfiguration)c.persistence().stores().get(0);
        AssertJUnit.assertEquals((long)15000L, (long)clusterLoaderCfg.remoteCallTimeout());
        c = this.getCacheConfiguration(holder, "withLoaderDefaults");
        loaderCfg = (SoftIndexFileStoreConfiguration)c.persistence().stores().get(0);
        AssertJUnit.assertEquals((String)"/tmp/Another-FileCacheStore-Location", (String)loaderCfg.dataLocation());
        c = this.getCacheConfiguration(holder, "withouthJmxEnabled");
        AssertJUnit.assertFalse((boolean)c.statistics().enabled());
        AssertJUnit.assertTrue((boolean)gc.statistics());
        AssertJUnit.assertTrue((boolean)gc.jmx().enabled());
        AssertJUnit.assertEquals((String)"funky_domain", (String)gc.jmx().domain());
        AssertJUnit.assertTrue((boolean)(gc.jmx().mbeanServerLookup() instanceof TestMBeanServerLookup));
        c = this.getCacheConfiguration(holder, "dist");
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertEquals((long)600000L, (long)c.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)120000L, (long)c.clustering().stateTransfer().timeout());
        AssertJUnit.assertEquals((long)1200L, (long)c.clustering().l1().cleanupTaskFrequency());
        AssertJUnit.assertTrue((boolean)(c.clustering().hash().consistentHashFactory() instanceof DefaultConsistentHashFactory));
        AssertJUnit.assertEquals((int)3, (int)c.clustering().hash().numOwners());
        AssertJUnit.assertTrue((boolean)c.clustering().l1().enabled());
        c = this.getCacheConfiguration(holder, "dist_with_capacity_factors");
        AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)c.clustering().cacheMode());
        AssertJUnit.assertEquals((long)600000L, (long)c.clustering().l1().lifespan());
        AssertJUnit.assertEquals((long)120000L, (long)c.clustering().stateTransfer().timeout());
        AssertJUnit.assertNull((Object)c.clustering().hash().consistentHashFactory());
        AssertJUnit.assertEquals((int)3, (int)c.clustering().hash().numOwners());
        AssertJUnit.assertTrue((boolean)c.clustering().l1().enabled());
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c.clustering().hash().capacityFactor()));
        if (!deprecated) {
            AssertJUnit.assertEquals((int)1000, (int)c.clustering().hash().numSegments());
        }
        c = this.getCacheConfiguration(holder, "groups");
        AssertJUnit.assertTrue((boolean)c.clustering().hash().groups().enabled());
        AssertJUnit.assertEquals((int)1, (int)c.clustering().hash().groups().groupers().size());
        AssertJUnit.assertEquals(String.class, (Object)((Grouper)c.clustering().hash().groups().groupers().get(0)).getKeyType());
        c = this.getCacheConfiguration(holder, "chunkSize");
        AssertJUnit.assertTrue((boolean)c.clustering().stateTransfer().fetchInMemoryState());
        AssertJUnit.assertEquals((long)120000L, (long)c.clustering().stateTransfer().timeout());
        AssertJUnit.assertEquals((int)1000, (int)c.clustering().stateTransfer().chunkSize());
        c = this.getCacheConfiguration(holder, "cacheWithCustomInterceptors");
        AssertJUnit.assertFalse((boolean)c.customInterceptors().interceptors().isEmpty());
        AssertJUnit.assertEquals((int)6, (int)c.customInterceptors().interceptors().size());
        for (InterceptorConfiguration i : c.customInterceptors().interceptors()) {
            if (!(i.asyncInterceptor() instanceof FooInterceptor)) continue;
            AssertJUnit.assertEquals((String)i.properties().getProperty("foo"), (String)"bar");
        }
        c = this.getCacheConfiguration(holder, "evictionCache");
        AssertJUnit.assertEquals((long)5000L, (long)c.memory().size());
        AssertJUnit.assertEquals((Object)EvictionStrategy.REMOVE, (Object)c.memory().evictionStrategy());
        AssertJUnit.assertEquals((Object)EvictionType.COUNT, (Object)c.memory().evictionType());
        AssertJUnit.assertEquals((Object)StorageType.OBJECT, (Object)c.memory().storageType());
        AssertJUnit.assertEquals((long)60000L, (long)c.expiration().lifespan());
        AssertJUnit.assertEquals((long)1000L, (long)c.expiration().maxIdle());
        AssertJUnit.assertEquals((long)500L, (long)c.expiration().wakeUpInterval());
        c = this.getCacheConfiguration(holder, "evictionMemoryExceptionCache");
        AssertJUnit.assertEquals((long)5000L, (long)c.memory().size());
        AssertJUnit.assertEquals((Object)EvictionStrategy.EXCEPTION, (Object)c.memory().evictionStrategy());
        AssertJUnit.assertEquals((Object)EvictionType.MEMORY, (Object)c.memory().evictionType());
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)c.memory().storageType());
        c = this.getCacheConfiguration(holder, "storeKeyValueBinary");
        AssertJUnit.assertEquals((Object)StorageType.BINARY, (Object)c.memory().storageType());
    }

    private void assertReaperAndTimeoutInfo(Configuration defaultCfg) {
        AssertJUnit.assertEquals((long)123L, (long)defaultCfg.transaction().reaperWakeUpInterval());
        AssertJUnit.assertEquals((long)3123L, (long)defaultCfg.transaction().completedTxTimeout());
    }

    public static class CustomTransport
    extends JGroupsTransport {
    }

    public static class GenericLoader
    implements CacheLoader {
        public void init(InitializationContext ctx) {
        }

        public MarshallableEntry loadEntry(Object key) {
            return null;
        }

        public boolean contains(Object key) {
            return false;
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

